/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class TraceNodeUI {
    protected Text _nodeAddress;
    protected Text _nodeName;
    protected Text _portNumber;
    protected Text _hour;
    protected Text _min;
    protected Text _sec;
    protected Text _micsec;
    protected Group deltaTime;
    private boolean _haveSeperator = true;

    public TraceNodeUI(boolean haveSeperator) {
        this._haveSeperator = haveSeperator;
    }

    public TraceNodeUI() {
    }

    public Composite createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        content.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 500;
        content.setLayoutData((Object)gd);
        if (this._haveSeperator) {
            Label sep = new Label(content, 258);
            GridData sepGrid = new GridData(768);
            sepGrid.horizontalSpan = 1;
            sep.setLayoutData((Object)sepGrid);
        }
        Composite group = new Composite(content, 0);
        group.setLayoutData((Object)GridUtil.createHorizontalFill());
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 5;
        group.setLayout((Layout)layout);
        Label label1 = new Label(group, 0);
        label1.setText(UIPlugin.getResourceString(TraceMessages.NODE_NAME));
        this._nodeName = new Text(group, 2052);
        this._nodeName.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label2 = new Label(group, 0);
        label2.setText(UIPlugin.getResourceString(TraceMessages.NODE_ADDRESS));
        this._nodeAddress = new Text(group, 2052);
        this._nodeAddress.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label3 = new Label(group, 0);
        label3.setText(UIPlugin.getResourceString(TraceMessages.RAC_PT));
        this._portNumber = new Text(group, 2052);
        this._portNumber.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._portNumber.setText(String.valueOf(10002));
        this.deltaTime = new Group(content, 0);
        layout = new GridLayout();
        layout.numColumns = 8;
        layout.verticalSpacing = 5;
        this.deltaTime.setLayout((Layout)layout);
        this.deltaTime.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.deltaTime.setText(UIPlugin.getResourceString(TraceMessages.SNCH_NDT));
        Label label = new Label((Composite)this.deltaTime, 0);
        label.setText(UIPlugin.getResourceString(TraceMessages.DLT_TM));
        this._hour = new Text((Composite)this.deltaTime, 2048);
        gd = new GridData();
        gd.widthHint = 40;
        this._hour.setLayoutData((Object)gd);
        this._hour.setTextLimit(4);
        label = new Label((Composite)this.deltaTime, 0);
        label.setText(":");
        this._min = new Text((Composite)this.deltaTime, 2048);
        gd = new GridData();
        gd.widthHint = 30;
        this._min.setLayoutData((Object)gd);
        this._min.setTextLimit(3);
        label = new Label((Composite)this.deltaTime, 0);
        label.setText(":");
        this._sec = new Text((Composite)this.deltaTime, 2048);
        gd = new GridData();
        gd.widthHint = 30;
        this._sec.setLayoutData((Object)gd);
        this._sec.setTextLimit(3);
        label.setText(":");
        this._micsec = new Text((Composite)this.deltaTime, 2048);
        gd = new GridData();
        gd.widthHint = 70;
        this._micsec.setLayoutData((Object)gd);
        this._micsec.setTextLimit(7);
        label = new Label((Composite)this.deltaTime, 0);
        label.setText(UIPlugin.getResourceString(TraceMessages.DLT_HMS));
        label = new Label((Composite)this.deltaTime, 0);
        label.setText(UIPlugin.getResourceString(TraceMessages.DLT_MIS));
        gd = new GridData();
        gd.horizontalSpan = 8;
        label.setLayoutData((Object)gd);
        this._nodeName.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._nodeAddress, String.valueOf(UIPlugin.getPluginId()) + ".nnwp0000");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._nodeName, String.valueOf(UIPlugin.getPluginId()) + ".nnwp0001");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._portNumber, String.valueOf(UIPlugin.getPluginId()) + ".nnwp0002");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._hour, String.valueOf(UIPlugin.getPluginId()) + ".nnwp0003");
        return content;
    }

    public Text getAddressUI() {
        return this._nodeAddress;
    }

    public Text getNodeNameUI() {
        return this._nodeName;
    }

    public Text getPortNumberUI() {
        return this._portNumber;
    }

    public Text getHourUI() {
        return this._hour;
    }

    public Text getMinUI() {
        return this._min;
    }

    public Text getSecUI() {
        return this._sec;
    }

    public Text getMicSecUI() {
        return this._micsec;
    }

    public void setEnabled(boolean enable) {
        this._nodeName.setEnabled(enable);
        this._nodeAddress.setEnabled(enable);
    }

    public double getDeltaTime() {
        int hours = 0;
        try {
            hours = Integer.parseInt(this._hour.getText());
        }
        catch (Exception exception) {}
        int min = 0;
        try {
            min = Integer.parseInt(this._min.getText());
        }
        catch (Exception exception) {}
        int sec = 0;
        try {
            sec = Integer.parseInt(this._sec.getText());
        }
        catch (Exception exception) {}
        int micsec = 0;
        try {
            micsec = Integer.parseInt(this._micsec.getText());
        }
        catch (Exception exception) {}
        if (hours < 0 || min < 0 || sec < 0 || micsec < 0) {
            return -((double)(Math.abs(hours) * 3600 + Math.abs(min) * 60 + Math.abs(sec)) * 1000000.0 + (double)Math.abs(micsec));
        }
        return ((double)hours * 3600.0 + (double)(min * 60) + (double)sec) * 1000000.0 + (double)micsec;
    }

    public void setDeltaTime(double delta) {
        try {
            int micsec = (int)(Math.abs(delta) % 1000000.0);
            double absDelta = Math.abs(delta) / 1000000.0;
            int hour = (int)(absDelta / 3600.0);
            int min = (int)(absDelta % 3600.0 / 60.0);
            int sec = (int)(absDelta % 3600.0 % 60.0);
            int hourValue = 0;
            int minValue = 0;
            int secValue = 0;
            int micsecValue = 0;
            if (delta >= 0.0) {
                hourValue = hour;
                minValue = min;
                secValue = sec;
                micsecValue = micsec;
            } else {
                int n = hourValue = hour > 0 ? -hour : hour;
                minValue = hourValue != 0 ? min : (min != 0 ? -min : 0);
                secValue = hourValue != 0 || minValue != 0 ? sec : (sec != 0 ? -sec : sec);
                micsecValue = hourValue != 0 || minValue != 0 || secValue != 0 ? micsec : (micsec != 0 ? -micsec : micsec);
            }
            this._hour.setText(hourValue == 0 ? "" : String.valueOf(hourValue));
            this._min.setText(minValue == 0 ? "" : String.valueOf(minValue));
            this._sec.setText(secValue == 0 ? "" : String.valueOf(secValue));
            this._micsec.setText(micsecValue == 0 ? "" : String.valueOf(micsecValue));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void setShowDelta(boolean enable) {
        this.deltaTime.setVisible(enable);
    }
}

