/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TraceOptionsUI
implements SelectionListener,
ModifyListener {
    private Button _enableProf;
    private Button _enableLog;
    private Button _enableInfoMsg;
    private Button _enableReloadMsg;
    private Button _always;
    private Button _never;
    private Button _prompt;
    private Button _alwaysPersp;
    private Button _neverPersp;
    private Button _promptPersp;
    private Text _projectName;
    private Text _localPort;
    private PreferencePage _preferencePage;
    private Button _manualRefreshBtn;
    private Button _automaticRefreshBtn;
    private Text _refreshIntervalText;
    private Label _refreshLabel;

    public TraceOptionsUI(PreferencePage preferencePage) {
        this._preferencePage = preferencePage;
    }

    public TraceOptionsUI() {
    }

    public Composite createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 10;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)GridUtil.createFill());
        Group profilingOptions = new Group(content, 0);
        profilingOptions.setText(UIPlugin.getResourceString(TraceMessages.PROF_LOG_GRP));
        layout = new GridLayout();
        layout.numColumns = 1;
        profilingOptions.setLayout((Layout)layout);
        profilingOptions.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._enableProf = new Button((Composite)profilingOptions, 32);
        this._enableProf.setText(UIPlugin.getResourceString(TraceMessages.E_PROFT));
        GridData data = new GridData();
        this._enableProf.setLayoutData((Object)data);
        this._enableLog = new Button((Composite)profilingOptions, 32);
        this._enableLog.setText(UIPlugin.getResourceString(TraceMessages.E_LOG));
        data = new GridData();
        this._enableLog.setLayoutData((Object)data);
        Group profilingInfo = new Group(content, 0);
        profilingInfo.setText(UIPlugin.getResourceString(TraceMessages.PROF_INF_GRP));
        layout = new GridLayout();
        layout.numColumns = 2;
        profilingInfo.setLayout((Layout)layout);
        profilingInfo.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label desc = new Label((Composite)profilingInfo, 0);
        desc.setText(UIPlugin.getResourceString(TraceMessages.TRCOPT));
        this._projectName = new Text((Composite)profilingInfo, 2048);
        data = GridUtil.createHorizontalFill();
        this._projectName.setLayoutData((Object)data);
        Label portdesc = new Label((Composite)profilingInfo, 0);
        portdesc.setText(UIPlugin.getResourceString(TraceMessages.RAC_LHP));
        this._localPort = new Text((Composite)profilingInfo, 2048);
        data = GridUtil.createHorizontalFill();
        this._localPort.setLayoutData((Object)data);
        this._localPort.addModifyListener((ModifyListener)this);
        this._enableInfoMsg = new Button((Composite)profilingInfo, 32);
        this._enableInfoMsg.setText(UIPlugin.getResourceString(TraceMessages.SP_TIP));
        data = new GridData();
        data.horizontalSpan = 2;
        this._enableInfoMsg.setLayoutData((Object)data);
        this._enableReloadMsg = new Button((Composite)profilingInfo, 32);
        this._enableReloadMsg.setText(UIPlugin.getResourceString(TraceMessages.SREL));
        data = new GridData();
        data.horizontalSpan = 2;
        this._enableReloadMsg.setLayoutData((Object)data);
        Group saveOnExitGroup = new Group(content, 0);
        saveOnExitGroup.setText(UIPlugin.getResourceString(TraceMessages.SAVE_EXITG));
        layout = new GridLayout();
        layout.numColumns = 3;
        saveOnExitGroup.setLayout((Layout)layout);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        saveOnExitGroup.setLayoutData((Object)data);
        this._always = new Button((Composite)saveOnExitGroup, 16);
        this._always.setText(UIPlugin.getResourceString(TraceMessages.ALWAYS));
        this._never = new Button((Composite)saveOnExitGroup, 16);
        this._never.setText(UIPlugin.getResourceString(TraceMessages.NEVER));
        this._prompt = new Button((Composite)saveOnExitGroup, 16);
        this._prompt.setText(UIPlugin.getResourceString(TraceMessages.PROMPT));
        Group switchPerspGroup = new Group(content, 0);
        switchPerspGroup.setText(UIPlugin.getResourceString(TraceMessages.SPERS_G));
        layout = new GridLayout();
        layout.numColumns = 3;
        switchPerspGroup.setLayout((Layout)layout);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        switchPerspGroup.setLayoutData((Object)data);
        this._alwaysPersp = new Button((Composite)switchPerspGroup, 16);
        this._alwaysPersp.setText(UIPlugin.getResourceString(TraceMessages.ALWAYS));
        this._neverPersp = new Button((Composite)switchPerspGroup, 16);
        this._neverPersp.setText(UIPlugin.getResourceString(TraceMessages.NEVER));
        this._promptPersp = new Button((Composite)switchPerspGroup, 16);
        this._promptPersp.setText(UIPlugin.getResourceString(TraceMessages.PROMPT));
        Group refreshGroup = new Group(content, 0);
        refreshGroup.setText(UIPlugin.getResourceString(TraceMessages.REF_VGRP));
        layout = new GridLayout();
        layout.numColumns = 2;
        refreshGroup.setLayout((Layout)layout);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        refreshGroup.setLayoutData((Object)data);
        this._manualRefreshBtn = new Button((Composite)refreshGroup, 16);
        this._manualRefreshBtn.setText(UIPlugin.getResourceString(TraceMessages.MN_REF));
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this._manualRefreshBtn.setLayoutData((Object)data);
        this._automaticRefreshBtn = new Button((Composite)refreshGroup, 16);
        this._automaticRefreshBtn.setText(UIPlugin.getResourceString(TraceMessages.AUT_REF));
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this._automaticRefreshBtn.setLayoutData((Object)data);
        this._refreshLabel = new Label((Composite)refreshGroup, 0);
        data = new GridData();
        data.horizontalIndent = 20;
        this._refreshLabel.setLayoutData((Object)data);
        this._refreshLabel.setText(UIPlugin.getResourceString(TraceMessages.RF_INT));
        this._refreshIntervalText = new Text((Composite)refreshGroup, 2048);
        this._refreshIntervalText.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._enableProf.addSelectionListener((SelectionListener)this);
        this._manualRefreshBtn.addSelectionListener((SelectionListener)this);
        this._automaticRefreshBtn.addSelectionListener((SelectionListener)this);
        this.initializeValues();
        return content;
    }

    public boolean getLogOption() {
        return this._enableLog.getSelection();
    }

    public boolean getProfOption() {
        return this._enableProf.getSelection();
    }

    public boolean getInfoMsgOption() {
        return this._enableInfoMsg.getSelection();
    }

    public boolean getReloadMsgOption() {
        return this._enableReloadMsg.getSelection();
    }

    public int getRefreshType() {
        return this._automaticRefreshBtn.getSelection() ? 1 : 0;
    }

    public int getRefreshInterval() {
        try {
            return Integer.parseInt(this._refreshIntervalText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("refresh_int");
        }
    }

    public String getProjectName() {
        return this._projectName.getText().trim();
    }

    public String getLocalPortNumber() {
        return this._localPort.getText().trim();
    }

    public String getSaveOnExitOption() {
        if (this._always.getSelection()) {
            return "always";
        }
        if (this._never.getSelection()) {
            return "never";
        }
        return "prompt";
    }

    public String getSwitchPerspOption() {
        if (this._alwaysPersp.getSelection()) {
            return "always";
        }
        if (this._neverPersp.getSelection()) {
            return "never";
        }
        return "prompt";
    }

    private void initializeValues() {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        this.setProfOption(store.getBoolean("prof_option"));
        this.setLogOption(store.getBoolean("log_option"));
        this.setProjectName(store.getString("prj_name"));
        this.setLocalHostPort(store.getString("localhost_port"));
        this.setInfoMsgOption(store.getBoolean("profile_tips"));
        this.setReloadMsgOption(store.getBoolean("reload_no_question"));
        this.setSaveOnExitOption(store.getString("save_on_exit"));
        this.setSwitchPerspOption(store.getString("switch_to_perspective"));
        this.setRefreshType(store.getInt("refresh_type"), store.getInt("refresh_int"));
    }

    public void setLogOption(boolean option) {
        this._enableLog.setSelection(option);
    }

    public void setRefreshType(int type, int interval) {
        if (type == 1) {
            this._manualRefreshBtn.setSelection(false);
            this._automaticRefreshBtn.setSelection(true);
        } else {
            this._manualRefreshBtn.setSelection(true);
            this._automaticRefreshBtn.setSelection(false);
            this._refreshLabel.setEnabled(false);
            this._refreshIntervalText.setEnabled(false);
        }
        this._refreshIntervalText.setText(String.valueOf(interval));
    }

    public void setInfoMsgOption(boolean option) {
        this._enableInfoMsg.setSelection(option);
    }

    public void setReloadMsgOption(boolean option) {
        this._enableReloadMsg.setSelection(option);
    }

    public void setProfOption(boolean option) {
        this._enableProf.setSelection(option);
    }

    public void setProjectName(String name) {
        this._projectName.setText(name);
    }

    public void setLocalHostPort(String portNum) {
        this._localPort.setText(portNum);
    }

    public void setSaveOnExitOption(String value) {
        if ("always".equals(value)) {
            this._always.setSelection(true);
            this._never.setSelection(false);
            this._prompt.setSelection(false);
        } else if ("never".equals(value)) {
            this._never.setSelection(true);
            this._always.setSelection(false);
            this._prompt.setSelection(false);
        } else {
            this._prompt.setSelection(true);
            this._always.setSelection(false);
            this._never.setSelection(false);
        }
    }

    public void setSwitchPerspOption(String value) {
        if ("always".equals(value)) {
            this._alwaysPersp.setSelection(true);
            this._neverPersp.setSelection(false);
            this._promptPersp.setSelection(false);
        } else if ("never".equals(value)) {
            this._neverPersp.setSelection(true);
            this._alwaysPersp.setSelection(false);
            this._promptPersp.setSelection(false);
        } else {
            this._promptPersp.setSelection(true);
            this._alwaysPersp.setSelection(false);
            this._neverPersp.setSelection(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this._manualRefreshBtn || e.widget == this._automaticRefreshBtn) {
            this._refreshLabel.setEnabled(this._automaticRefreshBtn.getSelection());
            this._refreshIntervalText.setEnabled(this._automaticRefreshBtn.getSelection());
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this._localPort) {
            try {
                if (this._localPort.getText().trim() == "") {
                    this._preferencePage.setErrorMessage(UIPlugin.getResourceString(TraceMessages.RAC_EMPTY_PORT));
                    return;
                }
                int value = Integer.parseInt(this._localPort.getText().trim());
                if (value < 0) {
                    this._preferencePage.setErrorMessage(UIPlugin.getResourceString(TraceMessages.RAC_INV_PRT));
                    this._localPort.setFocus();
                    return;
                }
                this._preferencePage.setErrorMessage(null);
            }
            catch (NumberFormatException numberFormatException) {
                if (this._preferencePage != null) {
                    this._preferencePage.setErrorMessage(UIPlugin.getResourceString(TraceMessages.RAC_INV_PRT));
                }
                this._localPort.setFocus();
            }
        }
    }
}

