/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSet;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.internal.wizard.AddWizard;
import org.eclipse.hyades.trace.ui.internal.wizard.AddWizardDialog;
import org.eclipse.hyades.trace.ui.internal.wizard.EditWizard;
import org.eclipse.hyades.trace.ui.internal.wizard.EditWizardDialog;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class TraceProfileOverviewUI
extends AbstractChangeable {
    private Composite _result;
    private List _profilingTypeList;
    private Table _table;
    private Table _profilingSetTable;
    private TableViewer _tableViewer;
    private CheckboxTableViewer _profilingSetTableViewer;
    private Button _addSetBtn;
    private Button _removeSetBtn;
    private Button _editBtn;
    private Label _contentLabel;
    private Label _profilingSetLabel;
    private ProfilingSetsManagerCopy _managerCopy;
    private ILaunchConfiguration _conf;

    public void dataChanged() {
        this.changed();
    }

    public Composite createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        this._result = new Composite(parent, 0);
        this._result.setLayout((Layout)layout);
        this._result.setLayoutData((Object)GridUtil.createFill());
        this.createProfilingSetTable(this._result);
        this.createProfilingTypeTable(this._result);
        return this._result;
    }

    private void createProfilingSetTable(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(TraceMessages.SPRF_SET);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        Composite tableGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        tableGroup.setLayout((Layout)layout);
        data = GridUtil.createFill();
        data.heightHint = 140;
        tableGroup.setLayoutData((Object)data);
        this._profilingSetTable = new Table(tableGroup, 68356);
        this._profilingSetTable.setLayoutData((Object)GridUtil.createFill());
        this._profilingSetTable.setLinesVisible(false);
        TableColumn column = new TableColumn(this._profilingSetTable, 0);
        column.setWidth(340);
        this._profilingSetTableViewer = new CheckboxTableViewer(this._profilingSetTable);
        this._profilingSetTableViewer.setContentProvider((IContentProvider)new ProfilingSetContentProvider());
        this._profilingSetTableViewer.setLabelProvider((IBaseLabelProvider)new ProfilingSetLabelProvider());
        this._profilingSetTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String a = ((ProfilingSet)e1).getDisplayName();
                String b = ((ProfilingSet)e2).getDisplayName();
                return a.compareTo(b);
            }
        });
        this._profilingSetTableViewer.setInput((Object)this.getManagerCopy());
        Composite btnGroup = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        btnGroup.setLayout((Layout)layout);
        btnGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite addGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        addGroup.setLayout((Layout)layout);
        addGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        this._addSetBtn = new Button(addGroup, 8);
        this._addSetBtn.setText(TraceMessages.APFS);
        this._addSetBtn.setToolTipText(TraceMessages.ADD_PFSTT);
        this._addSetBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._removeSetBtn = new Button(addGroup, 8);
        this._removeSetBtn.setText(TraceMessages.RPFS);
        this._removeSetBtn.setToolTipText(TraceMessages.RM_PFSTT);
        this._removeSetBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn = new Button(addGroup, 8);
        this._editBtn.setText(TraceMessages.EPFS);
        this._editBtn.setToolTipText(TraceMessages.ED_PFSTT);
        this._editBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._addSetBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TraceProfileOverviewUI.this.addProfilingSet();
            }
        });
        this._removeSetBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TraceProfileOverviewUI.this.removeProfilingSet();
            }
        });
        this._editBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = (IStructuredSelection)TraceProfileOverviewUI.this._profilingSetTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    ProfilingSet element = (ProfilingSet)selection.getFirstElement();
                    TraceProfileOverviewUI.this.showEditProfilingSetDialog(element);
                    TraceProfileOverviewUI.this.showProfilingTypeDetails(element);
                }
            }
        });
        this._profilingSetTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    ProfilingSet set = (ProfilingSet)selection.getFirstElement();
                    TraceProfileOverviewUI.this._profilingSetTableViewer.setAllChecked(false);
                    TraceProfileOverviewUI.this._profilingSetTableViewer.setChecked((Object)set, true);
                    TraceProfileOverviewUI.this._profilingSetTableViewer.refresh();
                    TraceProfileOverviewUI.this.getManagerCopy().setDefaultSet(set);
                    TraceProfileOverviewUI.this.showProfilingTypeDetails(set);
                    TraceProfileOverviewUI.this.changed();
                    TraceProfileOverviewUI.this._profilingSetLabel.setText(set.getDisplayDescription());
                    TraceProfileOverviewUI.this._removeSetBtn.setEnabled(TraceProfileOverviewUI.this.getManagerCopy().getProfilingSets().size() > 1);
                }
            }
        });
        this._profilingSetTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    ProfilingSet set = (ProfilingSet)selection.getFirstElement();
                    TraceProfileOverviewUI.this.showEditProfilingSetDialog(set);
                    TraceProfileOverviewUI.this.showProfilingTypeDetails(set);
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._profilingSetTable, String.valueOf(UIPlugin.getPluginId()) + ".pfps0001");
    }

    private void createProfilingTypeTable(Composite parent) {
        this.createVerticalSpacer(parent, 2);
        this._contentLabel = new Label(parent, 0);
        this._contentLabel.setText(TraceMessages.PRFST_CNT);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalIndent = 5;
        this._contentLabel.setLayoutData((Object)data);
        Composite tableGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        tableGroup.setLayout((Layout)layout);
        data = GridUtil.createFill();
        data.heightHint = 125;
        tableGroup.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        this._table = new Table(tableGroup, 2816);
        this._table.setEnabled(false);
        this._table.setLinesVisible(false);
        this._table.setLayoutData((Object)GridUtil.createFill());
        this._table.setLayout((Layout)tableLayout);
        this._table.setHeaderVisible(true);
        String[] headers = new String[]{TraceMessages.HPF_T};
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnPixelData(300, true)};
        TableColumn[] columns = new TableColumn[headers.length];
        int i = 0;
        while (i < headers.length) {
            tableLayout.addColumnData(layouts[i]);
            TableColumn tc = new TableColumn(this._table, 0, i);
            tc.setResizable(layouts[i].resizable);
            tc.setText(headers[i]);
            columns[i] = tc;
            ++i;
        }
        this._profilingTypeList = new ArrayList();
        this._tableViewer = new TableViewer(this._table);
        this._tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this._tableViewer.setInput((Object)this._profilingTypeList);
        Composite btnGroup = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        btnGroup.setLayout((Layout)layout);
        btnGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite addGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        addGroup.setLayout((Layout)layout);
        addGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite moveGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        moveGroup.setLayout((Layout)layout);
        moveGroup.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label = new Label(parent, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalIndent = 5;
        label.setLayoutData((Object)data);
        label.setText(TraceMessages.DESCP);
        this.setBold(label);
        this._profilingSetLabel = new Label(parent, 16448);
        data = new GridData();
        data.horizontalSpan = 2;
        data.heightHint = 65;
        data.widthHint = 600;
        data.horizontalIndent = 5;
        this._profilingSetLabel.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._table, String.valueOf(UIPlugin.getPluginId()) + ".pfpp0002");
    }

    private void setBold(Label label) {
        FontData[] fontData = label.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(fontData[i].getStyle() | 1);
            ++i;
        }
        label.setFont(new Font(null, fontData));
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
        label.setFont(comp.getFont());
    }

    private void showProfilingTypeDetails(IProfilingSet set) {
        this._profilingTypeList.clear();
        ArrayList<IProfilingSetType> types = new ArrayList<IProfilingSetType>();
        Iterator iter = set.getProfilingTypes().iterator();
        while (iter.hasNext()) {
            String type = (String)iter.next();
            IProfilingSetType pSetType = (IProfilingSetType)this.getManagerCopy().getProfilingTypes().get(type);
            types.add(pSetType);
        }
        IProfilingSetType[] sortedTypes = new IProfilingSetType[types.size()];
        types.toArray(sortedTypes);
        Arrays.sort(sortedTypes, new Comparator(){

            public int compare(Object o1, Object o2) {
                IProfilingSetType t1 = (IProfilingSetType)o1;
                IProfilingSetType t2 = (IProfilingSetType)o2;
                return t1.getName().compareTo(t2.getName());
            }
        });
        int i = 0;
        while (i < sortedTypes.length) {
            IProfilingSetType pSetType = sortedTypes[i];
            if (pSetType != null) {
                boolean descriptionExists;
                pSetType.setDescription(pSetType.getProfilingType().getDescription(this.getManagerCopy()));
                boolean bl = descriptionExists = pSetType.getDescription() != null && pSetType.getDescription().length() > 0;
                if (descriptionExists) {
                    if (i != 0) {
                        this._profilingTypeList.add("");
                    }
                    this._profilingTypeList.add(pSetType.getName());
                    this.addDescription(this._profilingTypeList, pSetType.getDescription());
                    this._profilingTypeList.add("");
                } else {
                    this._profilingTypeList.add(pSetType.getName());
                }
            }
            ++i;
        }
        this._table.setRedraw(false);
        this._tableViewer.refresh();
        this._table.setRedraw(true);
    }

    private void addDescription(List profilingList, String description) {
        String delim = "\n";
        StringTokenizer tokens = new StringTokenizer(description, delim, false);
        while (tokens.hasMoreElements()) {
            String token = tokens.nextToken();
            profilingList.add(token);
        }
    }

    private void showEditProfilingSetDialog(ProfilingSet set) {
        EditWizard wizard = new EditWizard(this);
        EditWizardDialog dialog = new EditWizardDialog(this._editBtn.getShell(), (IWizard)wizard);
        wizard.initializeSet(set);
        dialog.create();
        dialog.open();
    }

    public TableViewer getTableViewer() {
        return this._profilingSetTableViewer;
    }

    private void addProfilingSet() {
        AddWizard wizard = new AddWizard(this);
        AddWizardDialog dialog = new AddWizardDialog(this._addSetBtn.getShell(), (IWizard)wizard);
        wizard.initializeSet();
        dialog.create();
        dialog.open();
    }

    private void removeProfilingSet() {
        IStructuredSelection selection = (IStructuredSelection)this._profilingSetTableViewer.getSelection();
        if (!selection.isEmpty()) {
            IProfilingSet set = (IProfilingSet)selection.getFirstElement();
            try {
                boolean remove = true;
                String profilingSetId = set.getId();
                ILaunchConfiguration[] configurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
                Vector<ILaunchConfiguration> configurationsV = new Vector<ILaunchConfiguration>();
                int i = 0;
                while (i < configurations.length) {
                    if (!this._conf.getName().equals(configurations[i].getName()) && profilingSetId.equals(configurations[i].getAttributes().get(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET))) {
                        configurationsV.addElement(configurations[i]);
                    }
                    ++i;
                }
                if (configurationsV.size() > 0) {
                    String message = String.valueOf(TraceMessages.RPRF_WT1) + NLS.bind((String)TraceMessages.RPRF_WT2, (Object)((ProfilingSet)ProfilingSetsManager.instance().getInitialDefaultSet(profilingSetId)).getDisplayName().trim()) + TraceMessages.RPRF_WT3;
                    String[] buttons = new String[]{TraceMessages.RPRF_WTY, TraceMessages.RPRF_WTN};
                    MessageDialog messageDialog = new MessageDialog(this._removeSetBtn.getShell(), TraceMessages.RPRF_WT, null, message, 4, buttons, 0);
                    messageDialog.create();
                    boolean bl = remove = messageDialog.open() == 0;
                }
                if (remove) {
                    this.getManagerCopy().getProfilingSets().remove(set.getId());
                    this.getManagerCopy().applyChanges();
                    this._profilingSetTableViewer.refresh();
                    IProfilingSet newSet = this.getManagerCopy().getInitialDefaultSet(null);
                    int i2 = 0;
                    while (i2 < configurationsV.size()) {
                        ILaunchConfiguration currentConf = (ILaunchConfiguration)configurationsV.elementAt(i2);
                        ILaunchConfigurationWorkingCopy currentConfWorkingCopy = currentConf.getWorkingCopy();
                        currentConfWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, newSet.getId());
                        currentConfWorkingCopy.doSave();
                        ++i2;
                    }
                    this._profilingSetTableViewer.setSelection((ISelection)new StructuredSelection((Object)newSet));
                }
            }
            catch (CoreException e) {
                HyadesUIPlugin.logError((Throwable)e);
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        this._conf = conf;
        this.getManagerCopy().initializeFrom(conf);
        IProfilingSet set = this.getManagerCopy().getDefaultSet();
        if (set != null) {
            this._profilingSetTableViewer.setSelection((ISelection)new StructuredSelection((Object)set));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        this._managerCopy.performApply(wc);
    }

    public boolean isValid(ILaunchConfiguration conf) {
        return true;
    }

    public ProfilingSetsManagerCopy getManagerCopy() {
        if (this._managerCopy == null) {
            this._managerCopy = new ProfilingSetsManagerCopy();
        }
        return this._managerCopy;
    }

    private static class ProfilingSetLabelProvider
    extends LabelProvider {
        ProfilingSetLabelProvider() {
        }

        public String getText(Object element) {
            return ((ProfilingSet)element).getDisplayName();
        }

        public Image getImage(Object element) {
            return PDPluginImages.getImage("filter_obj.gif");
        }
    }

    private static class ProfilingSetContentProvider
    implements IStructuredContentProvider {
        ProfilingSetContentProvider() {
        }

        public Object[] getElements(Object parent) {
            ProfilingSetsManagerCopy copy = (ProfilingSetsManagerCopy)parent;
            return copy.getProfilingSets().values().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class ListContentProvider
    implements IStructuredContentProvider {
        ListContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input != null && input instanceof List) {
                return ((List)input).toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

