/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.AgentAttribute;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileLaunchUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.launcher.RunAttachProfileStatusHandler;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ProfileAttachDelegate
implements ILaunchConfigurationDelegate {
    private boolean isAgentAttachedOrMissing(Vector agents) {
        if (agents != null) {
            int i = 0;
            while (i < agents.size()) {
                if (agents.get(i) == null || ((Agent)agents.get(i)).isAttached()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void launch(final ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 4);
            monitor.subTask(TraceMessages.LNCH_MSGV);
            Vector agents = new Vector(ProfileAttachDelegate.getAgents(conf));
            monitor.worked(1);
            if (this.isAgentAttachedOrMissing(agents) || agents.size() == 0) {
                monitor.setCanceled(true);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        Shell shell = UIPlugin.getActiveWorkbenchShell();
                        DebugUITools.openLaunchConfigurationDialog((Shell)shell, (ILaunchConfiguration)conf, (String)IDebugUIConstants.ID_PROFILE_LAUNCH_GROUP, (IStatus)new Status(0, UIPlugin.getPluginId(), RunAttachProfileStatusHandler.CODE, "", null));
                    }
                });
                return;
            }
            monitor.worked(1);
            boolean success = ProfileLaunchUtil.performProfilingTypesLaunch(conf);
            if (!success) {
                monitor.setCanceled(true);
                return;
            }
            monitor.worked(1);
            IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
            String hostName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt("localhost_port"));
            String projectName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString("prj_name"));
            String monitorName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString("mon_name"));
            String profileFile = null;
            if (conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false)) {
                profileFile = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, null);
            }
            ProfilingSetsManager manager = ProfilingSetsManager.instance();
            ArrayList filters = manager.getFilters(conf);
            Vector options = manager.getOptions(conf);
            PDCoreUtil.attach(hostName, agents, options, filters, projectName, monitorName, String.valueOf(port), profileFile, launch);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        if (UIPlugin.getDefault().getPreferenceStore().getBoolean("profile_tips")) {
                            MessageDialogWithToggle.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)TraceMessages.PROF_TT, (String)TraceMessages.AT_INFOM, (String)TraceMessages.AT_MSGCB, (boolean)false, (IPreferenceStore)UIPlugin.getDefault().getPreferenceStore(), (String)"profile_tips");
                        }
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            });
            monitor.worked(1);
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            throw e;
        }
    }

    static List getNodeConfiguration(ILaunchConfiguration conf, boolean showErrorMsgs) {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        try {
            String host = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getDefaultInt("localhost_port"));
            Enumeration enum1 = PDCoreUtil.getNodeConfiguration(host, port, showErrorMsgs);
            if (enum1 != null) {
                ArrayList list = new ArrayList();
                while (enum1.hasMoreElements()) {
                    list.add(enum1.nextElement());
                }
                return list;
            }
            return null;
        }
        catch (CoreException e) {
            HyadesUIPlugin.logError((Throwable)e);
            return null;
        }
    }

    static List getNodeConfiguration(ILaunchConfiguration conf) {
        ArrayList list = ProfileAttachDelegate.getNodeConfiguration(conf, true);
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    public static List getAttributeAgents(ILaunchConfiguration conf) {
        try {
            List agents = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, null);
            if (agents == null) {
                return new ArrayList();
            }
            Iterator iter = agents.iterator();
            ArrayList<AgentAttribute> list = new ArrayList<AgentAttribute>();
            while (iter.hasNext()) {
                list.add(new AgentAttribute((String)iter.next()));
            }
            return list;
        }
        catch (Exception e) {
            HyadesUIPlugin.logError((Throwable)e);
            return new ArrayList();
        }
    }

    public static List getAgents(ILaunchConfiguration conf) {
        return ProfileAttachDelegate.getAgents(conf, ProfileAttachDelegate.getNodeConfiguration(conf));
    }

    static List getAgents(ILaunchConfiguration conf, List nodes) {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        if (nodes != null) {
            try {
                Iterator iter = nodes.iterator();
                List list = ProfileAttachDelegate.getAttributeAgents(conf);
                if (list != null) {
                    Map map = ProfileAttachDelegate.createMap(list);
                    while (iter.hasNext()) {
                        Process process = (Process)iter.next();
                        String[] selected = (String[])map.get(process.getProcessId());
                        if (selected == null) continue;
                        int i = 0;
                        while (i < selected.length) {
                            agents.add(process.getAgent(selected[i]));
                            ++i;
                        }
                    }
                }
            }
            catch (Exception e) {
                HyadesUIPlugin.logError((Throwable)e);
            }
        }
        return agents;
    }

    public static Map createMap(List list) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            AgentAttribute agentAttribute = (AgentAttribute)iter.next();
            Vector<String> agents = (Vector<String>)map.get(agentAttribute.getPID());
            if (agents == null) {
                agents = new Vector<String>();
            }
            agents.addElement(agentAttribute.getName());
            map.put(agentAttribute.getPID(), agents);
        }
        Iterator keys = map.keySet().iterator();
        String key = null;
        Vector agents = null;
        String[] stringArray = null;
        while (keys.hasNext()) {
            key = (String)keys.next();
            agents = (Vector)map.get(key);
            stringArray = new String[agents.size()];
            agents.toArray(stringArray);
            map.put(key, stringArray);
        }
        return map;
    }
}

