/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileLaunchUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.launcher.TraceArguments;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;
import org.eclipse.pde.ui.launcher.EquinoxLaunchConfiguration;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.AgentControllerFactoryImpl;

public class ProfileEquinoxLaunchConfiguration
extends EquinoxLaunchConfiguration {
    private static final String ECLIPSE_MAIN = "org.eclipse.core.launcher.Main";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 4);
            monitor.subTask(TraceMessages.LNCH_MSGV);
            this.preLaunchCheck(configuration, launch, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            this.fConfigDir = null;
            boolean success = ProfileLaunchUtil.performProfilingTypesLaunch(configuration);
            monitor.worked(1);
            if (!success) {
                monitor.setCanceled(true);
                return;
            }
            String workspace = LaunchArgumentsHelper.getWorkspaceLocation((ILaunchConfiguration)configuration);
            if (!LauncherUtils.clearWorkspace((ILaunchConfiguration)configuration, (String)workspace, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
                monitor.setCanceled(true);
                return;
            }
            if (configuration.getAttribute("clearConfig", false)) {
                CoreUtility.deleteContent((File)this.getConfigDir(configuration));
            }
            launch.setAttribute("configLocation", this.getConfigDir(configuration).toString());
            monitor.worked(1);
            TraceArguments traceArguments = new TraceArguments(ECLIPSE_MAIN);
            traceArguments.setClassPath(this.getClassPath(configuration));
            traceArguments.setParameters(this.getProgramArgs(configuration));
            traceArguments.setVMArguments(this.getVMArgs(configuration));
            traceArguments.setEnvironmentVariable(ProfileLaunchUtil.getEnvironmentVariables(configuration));
            traceArguments.setAutoMonitoring(this.isAutoMonitoring(configuration));
            traceArguments.setHostName(this.getHostName(configuration));
            traceArguments.setPortNumber(this.getPortNumber(configuration));
            traceArguments.setProfileFile(this.getProfileFile(configuration));
            ProfilingSetsManager manager = ProfilingSetsManager.instance();
            ArrayList filters = manager.getFilters(configuration);
            Vector options = manager.getOptions(configuration);
            String projectName = this.getProjectName(configuration);
            String monitorName = this.getMonitorName(configuration);
            monitor.worked(1);
            if (!PDCoreUtil.launchTrace(traceArguments, filters, options, projectName, monitorName, launch)) {
                monitor.setCanceled(true);
            }
            monitor.worked(1);
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            throw e;
        }
    }

    private String getProgramArgs(ILaunchConfiguration configuration) throws CoreException {
        String[] programArgs = this.getProgramArguments(configuration);
        if (programArgs.length == 0) {
            return null;
        }
        return ProfileLaunchUtil.convertToDelimitedString(programArgs, ' ');
    }

    private String getClassPath(ILaunchConfiguration conf) throws CoreException {
        String[] classpath = this.getClasspath(conf);
        if (classpath == null) {
            String message = TraceMessages.WCD_NST;
            throw new CoreException((IStatus)new Status(4, UIPlugin.getPluginId(), 0, message, null));
        }
        if (classpath.length == 0) {
            return null;
        }
        String classpathList = "";
        int i = 0;
        while (i < classpath.length - 1) {
            classpathList = String.valueOf(classpathList) + classpath[i] + File.pathSeparatorChar;
            ++i;
        }
        classpathList = String.valueOf(classpathList) + classpath[classpath.length - 1];
        return classpathList;
    }

    private String getVMArgs(ILaunchConfiguration configuration) throws CoreException {
        String[] vmArgs = new ExecutionArguments(configuration.getAttribute("vmargs", ""), "").getVMArgumentsArray();
        if (vmArgs.length == 0) {
            return null;
        }
        return ProfileLaunchUtil.convertToDelimitedString(vmArgs, ' ');
    }

    private boolean isAutoMonitoring(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, true);
    }

    private String getHostName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
    }

    private int getPortNumber(ILaunchConfiguration configuration) throws CoreException {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        if (AgentControllerFactoryImpl.whoIsRunning() == 1 && this.getHostName(configuration).equals("localhost")) {
            return configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, -1);
        }
        return configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt("localhost_port"));
    }

    private String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        return configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString("prj_name"));
    }

    private String getMonitorName(ILaunchConfiguration configuration) throws CoreException {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        return configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString("mon_name"));
    }

    private String getProfileFile(ILaunchConfiguration configuration) throws CoreException {
        if (configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false)) {
            return configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, null);
        }
        return null;
    }
}

