/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.RunLaunchProfileStatusHandler;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.ui.launcher.EquinoxLaunchShortcut;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ProfileEquinoxLaunchShortcut
extends EquinoxLaunchShortcut {
    private static final String CLASSPATH_PROVIDER = "org.eclipse.pde.ui.workbenchClasspathProvider";
    private static final String CONFIGURATION_TYPE = "org.eclipse.pde.ui.EquinoxLauncher";

    public void launch(ISelection selection, String mode) {
        this.launch((IPluginModelBase)null, mode);
    }

    public void launch(IEditorPart editor, String mode) {
        this.launch((IPluginModelBase)null, mode);
    }

    private void launch(IPluginModelBase model, String mode) {
        ILaunchConfiguration[] configs = this.getLaunchConfigurations();
        ILaunchConfiguration configuration = null;
        if (configs.length == 0) {
            IPluginModelBase osgi;
            IPluginModelBase[] iPluginModelBaseArray;
            PluginModelManager manager = PDECore.getDefault().getModelManager();
            if (model == null) {
                iPluginModelBaseArray = manager.getWorkspaceModels();
            } else {
                IPluginModelBase[] iPluginModelBaseArray2 = new IPluginModelBase[1];
                iPluginModelBaseArray = iPluginModelBaseArray2;
                iPluginModelBaseArray2[0] = model;
            }
            IPluginModelBase[] models = iPluginModelBaseArray;
            if (models.length == 0 && (osgi = manager.findModel("org.eclipse.osgi")) != null) {
                models = new IPluginModelBase[]{osgi};
            }
            configuration = this.createNewConfiguration(models, mode);
        } else {
            configuration = configs.length == 1 ? configs[0] : this.chooseConfiguration(configs, mode);
        }
        if (configuration != null) {
            final ILaunchConfiguration config = configuration;
            final String mod = mode;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    Shell shell = UIPlugin.getActiveWorkbenchShell();
                    int result = DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)shell, (ILaunchConfiguration)config, (String)IDebugUIConstants.ID_PROFILE_LAUNCH_GROUP, (IStatus)new Status(0, UIPlugin.getPluginId(), RunLaunchProfileStatusHandler.CODE, "", null));
                    if (result == 0) {
                        DebugUITools.launch((ILaunchConfiguration)config, (String)mod);
                    }
                }
            });
        }
    }

    protected ILaunchConfiguration chooseConfiguration(ILaunchConfiguration[] configs, String mode) {
        if (mode.equals("profile")) {
            IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(UIPlugin.getActiveWorkbenchShell(), (ILabelProvider)labelProvider);
            dialog.setElements((Object[])configs);
            dialog.setTitle(TraceMessages.LSH_SCFT);
            dialog.setMessage(TraceMessages.LSH_SCFM);
            dialog.setMultipleSelection(false);
            int result = dialog.open();
            labelProvider.dispose();
            if (result == 0) {
                return (ILaunchConfiguration)dialog.getFirstResult();
            }
            return null;
        }
        return super.chooseConfiguration(configs, mode);
    }

    private ILaunchConfiguration[] getLaunchConfigurations() {
        ArrayList<ILaunchConfiguration> result = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfiguration[] configs = manager.getLaunchConfigurations(this.getLaunchConfigurationType());
            int i = 0;
            while (i < configs.length) {
                if (!DebugUITools.isPrivate((ILaunchConfiguration)configs[i])) {
                    result.add(configs[i]);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return result.toArray(new ILaunchConfiguration[result.size()]);
    }

    private ILaunchConfiguration createNewConfiguration(IPluginModelBase[] selected, String mode) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getLaunchConfigurationType();
            String computedName = this.getComputedName("Equinox");
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, computedName);
            this.setJavaArguments(wc);
            wc.setAttribute("checked", "[NONE]");
            wc.setAttribute("automaticAdd", true);
            ProfileEquinoxLaunchShortcut.initializePluginState((ILaunchConfigurationWorkingCopy)wc, (IPluginModelBase[])selected);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, CLASSPATH_PROVIDER);
            config = wc.doSave();
        }
        catch (CoreException ce) {
            UIPlugin.getDefault().log(ce);
        }
        return config;
    }

    private ILaunchConfigurationType getLaunchConfigurationType() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        return manager.getLaunchConfigurationType(CONFIGURATION_TYPE);
    }

    private String getComputedName(String prefix) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.generateUniqueLaunchConfigurationNameFrom(prefix);
    }

    private void setJavaArguments(ILaunchConfigurationWorkingCopy wc) {
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        String progArgs = preferences.getString("program_args");
        if (progArgs.indexOf("-console") == -1) {
            progArgs = "-console " + progArgs;
        }
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, progArgs);
        String vmArgs = preferences.getString("vm_args");
        if (vmArgs.length() > 0) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
        }
    }
}

