/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.security.internal.util.ConnectUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceHostUI;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileAgentsTab;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.AgentControllerFactoryImpl;

public class ProfileHostTab
extends AbstractLaunchConfigurationTab {
    private TraceHostUI _ui;
    private ProfileAgentsTab _agents;
    private String _oldHost;
    private int _oldPort = -1;

    public ProfileHostTab() {
        this(null);
    }

    public ProfileHostTab(ProfileAgentsTab agents) {
        this._agents = agents;
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        this.setControl((Control)content);
        content.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(content, 1);
        this._ui = new TraceHostUI();
        this._ui.createControl(content);
        this._ui.addListener(new Listener(){

            public void handleEvent(Event event) {
                String host = ProfileHostTab.this._ui.getHost();
                int port = ProfileHostTab.this._ui.getPort();
                if (!(ProfileHostTab.this._agents == null || ProfileHostTab.this._oldPort == -1 || ProfileHostTab.this._oldHost == null || ProfileHostTab.this._oldHost.equals(host) && ProfileHostTab.this._oldPort == port)) {
                    ProfileHostTab.this._agents.reset();
                }
                ProfileHostTab.this._oldHost = host;
                ProfileHostTab.this._oldPort = port;
                ProfileHostTab.this.updateLaunchConfigurationDialog();
                ProfileHostTab.this.updatePreferences();
            }
        });
    }

    public boolean isValid(ILaunchConfiguration conf) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this._ui.getHost() == null) {
            this.setErrorMessage(TraceMessages.TAB_ERRHST);
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
        boolean isRACrunning = false;
        if (AgentControllerFactoryImpl.whoIsRunning() == 2) {
            isRACrunning = true;
        }
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, isRACrunning ? store.getDefaultInt("localhost_port") : -1);
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        try {
            String host = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, -1);
            String info = String.valueOf(host) + ":" + port;
            this._ui.addHost(info);
            this._ui.selectHost(info);
            this._oldHost = host;
            this._oldPort = port;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, this._ui.getHost());
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, this._ui.getPort());
        if (this._agents != null) {
            this._agents.performApply(wc);
        }
    }

    public String getName() {
        return TraceMessages.TAB_NHST;
    }

    public Image getImage() {
        return PDPluginImages.getImage("node_obj.gif");
    }

    public boolean isLocal() {
        return ConnectUtil.isLocalHost((String)this._ui.getHost());
    }

    private void updatePreferences() {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        StringBuffer buf = new StringBuffer();
        TableItem[] items = this._ui.getHosts();
        int idx = 0;
        while (idx < items.length) {
            buf.append(',');
            buf.append(items[idx].getText().trim());
            ++idx;
        }
        String hosts = buf.toString();
        if (hosts.startsWith(",") && hosts.length() > 1) {
            hosts = hosts.substring(1);
        }
        store.setValue("use_host", hosts);
    }
}

