/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileLaunchUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.launcher.TraceArguments;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfiguration;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.AgentControllerFactoryImpl;

public class ProfileJUnitDelegate
extends JUnitLaunchConfiguration {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 4);
            monitor.subTask(TraceMessages.LNCH_MSGV);
            boolean success = ProfileLaunchUtil.performProfilingTypesLaunch(configuration);
            monitor.worked(1);
            if (!success) {
                monitor.setCanceled(true);
                return;
            }
            IJavaProject javaProject = this.getJavaProject(configuration);
            IType[] testTypes = this.getTestTypes(configuration, javaProject, monitor);
            IVMInstall install = this.getVMInstall(configuration);
            install.getVMRunner("run");
            int port = SocketUtil.findFreePort();
            VMRunnerConfiguration runConfig = this.launchTypes(configuration, "run", testTypes, port);
            this.setDefaultSourceLocator(launch, configuration);
            monitor.worked(1);
            launch.setAttribute("org.eclipse.jdt.junit.PORT", Integer.toString(port));
            launch.setAttribute("org.eclipse.jdt.junit.TESTTYPE", testTypes[0].getHandleIdentifier());
            ProfilingSetsManager manager = ProfilingSetsManager.instance();
            IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
            TraceArguments args = new TraceArguments(runConfig.getClassToLaunch());
            args.setClassPath(ProfileLaunchUtil.convertToDelimitedString(runConfig.getClassPath(), File.pathSeparatorChar, false));
            args.setParameters(ProfileLaunchUtil.convertToDelimitedString(runConfig.getProgramArguments(), ' '));
            args.setVMArguments(ProfileLaunchUtil.convertToDelimitedString(runConfig.getVMArguments(), ' '));
            args.setEnvironmentVariable(ProfileLaunchUtil.getEnvironmentVariables(configuration));
            args.setAutoMonitoring(manager.getAutoMonitoring(configuration));
            args.setLocation(runConfig.getWorkingDirectory());
            String hostName = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            port = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt("localhost_port"));
            if (AgentControllerFactoryImpl.whoIsRunning() == 1 && hostName.equals("localhost")) {
                port = -1;
            }
            String projectName = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString("prj_name"));
            String monitorName = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString("mon_name"));
            args.setHostName(hostName);
            args.setPortNumber(port);
            if (configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false)) {
                args.setProfileFile(configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, null));
            }
            ArrayList filters = manager.getFilters(configuration);
            Vector options = manager.getOptions(configuration);
            monitor.worked(1);
            if (!PDCoreUtil.launchTrace(args, filters, options, projectName, monitorName, launch)) {
                monitor.setCanceled(true);
            }
            monitor.worked(1);
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            throw e;
        }
    }
}

