/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileLaunchUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.launcher.TraceArguments;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.AgentControllerFactoryImpl;

public class ProfileJavaAppletDelegate
extends AbstractJavaLaunchConfigurationDelegate
implements IDebugEventSetListener {
    private static Map fgLaunchToFileMap = new HashMap();

    public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 5);
            monitor.subTask(TraceMessages.LNCH_MSGV);
            boolean success = ProfileLaunchUtil.performProfilingTypesLaunch(conf);
            monitor.worked(1);
            if (!success) {
                monitor.setCanceled(true);
                return;
            }
            ProfilingSetsManager manager = ProfilingSetsManager.instance();
            IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
            this.verifyMainTypeName(conf);
            File workingDir = this.verifyWorkingDirectory(conf);
            String workingDirName = workingDir.getAbsolutePath();
            TraceArguments args = new TraceArguments(conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_APPLETVIEWER_CLASS, "sun.applet.AppletViewer"));
            args.setClassPath(this.getClasspathString(conf));
            args.setVMArguments(String.valueOf(this.getJavaPolicyFile(workingDir)) + ' ' + this.getVMArguments(conf));
            monitor.worked(1);
            File htmlFile = this.buildHTMLFile(conf, workingDir);
            args.setParameters(htmlFile.getName());
            args.setLocation(workingDirName);
            monitor.worked(1);
            if (fgLaunchToFileMap.isEmpty()) {
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
            }
            fgLaunchToFileMap.put(launch, htmlFile);
            this.setDefaultSourceLocator(launch, conf);
            String projectName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString("prj_name"));
            String monitorName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString("mon_name"));
            args.setHostName("localhost");
            if (AgentControllerFactoryImpl.whoIsRunning() == 1) {
                args.setPortNumber(-1);
            } else {
                args.setPortNumber(store.getInt("localhost_port"));
            }
            args.setAutoMonitoring(manager.getAutoMonitoring(conf));
            if (conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false)) {
                args.setProfileFile(conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, null));
            }
            ArrayList filters = manager.getFilters(conf);
            Vector options = manager.getOptions(conf);
            monitor.worked(1);
            if (!PDCoreUtil.launchTrace(args, filters, options, projectName, monitorName, launch)) {
                monitor.setCanceled(true);
            }
            monitor.worked(1);
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            throw e;
        }
    }

    public String getJavaPolicyFile(File workingDir) {
        File file = new File(workingDir, "java.policy.applet");
        if (!file.exists()) {
            File test = LaunchingPlugin.getFileInPlugin((IPath)new Path("java.policy.applet"));
            try {
                byte[] bytes = ProfileJavaAppletDelegate.getFileByteContent(test);
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
                outputStream.write(bytes);
                outputStream.close();
            }
            catch (IOException iOException) {
                return "";
            }
        }
        return "-Djava.security.policy=java.policy.applet";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File buildHTMLFile(ILaunchConfiguration configuration, File dir) {
        File tempFile;
        block12: {
            OutputStreamWriter writer = null;
            tempFile = null;
            try {
                try {
                    String name = this.getMainTypeName(configuration);
                    tempFile = new File(dir, String.valueOf(name) + System.currentTimeMillis() + ".html");
                    writer = new FileWriter(tempFile);
                    writer.write("<html>\n");
                    writer.write("<body>\n");
                    writer.write("<applet code=");
                    writer.write(name);
                    writer.write(".class ");
                    String appletName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_NAME, "");
                    if (appletName.length() != 0) {
                        writer.write("NAME =\"" + appletName + "\" ");
                    }
                    writer.write("width=\"");
                    writer.write(Integer.toString(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_WIDTH, 200)));
                    writer.write("\" height=\"");
                    writer.write(Integer.toString(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_HEIGHT, 200)));
                    writer.write("\" >\n");
                    Map parameters = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_PARAMETERS, new HashMap());
                    if (parameters.size() != 0) {
                        Iterator iterator = parameters.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry next = iterator.next();
                            writer.write("<param name=");
                            writer.write(this.getQuotedString((String)next.getKey()));
                            writer.write(" value=");
                            writer.write(this.getQuotedString((String)next.getValue()));
                            writer.write(">\n");
                        }
                    }
                    writer.write("</applet>\n");
                    writer.write("</body>\n");
                    writer.write("</html>\n");
                }
                catch (IOException iOException) {
                }
                catch (CoreException coreException) {}
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (writer == null) throw throwable;
                try {
                    writer.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var10_12 = null;
                if (writer == null) break block12;
            }
            try {}
            catch (IOException iOException) {}
            writer.close();
        }
        if (tempFile != null) return tempFile;
        return null;
    }

    private String getQuotedString(String string) {
        if (string.indexOf(34) == -1) {
            return String.valueOf('\"') + string + '\"';
        }
        return String.valueOf('\'') + string + '\'';
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            Object eventSource = event.getSource();
            switch (event.getKind()) {
                case 8: {
                    Object var7_7;
                    if (eventSource == null) break;
                    ILaunch launch = null;
                    if (eventSource instanceof IProcess) {
                        IProcess process = (IProcess)eventSource;
                        launch = process.getLaunch();
                    } else if (eventSource instanceof IDebugTarget) {
                        IDebugTarget debugTarget = (IDebugTarget)eventSource;
                        launch = debugTarget.getLaunch();
                    }
                    File temp = (File)fgLaunchToFileMap.get(launch);
                    if (temp == null) break;
                    try {
                        fgLaunchToFileMap.remove(launch);
                        temp.delete();
                    }
                    catch (Throwable throwable) {
                        var7_7 = null;
                        if (fgLaunchToFileMap.isEmpty()) {
                            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        }
                        throw throwable;
                    }
                }
                {
                    Object var7_7 = null;
                    if (!fgLaunchToFileMap.isEmpty()) break;
                }
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                break;
            }
            ++i;
        }
        return;
    }

    protected static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block5: {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(file));
                byArray = ProfileJavaAppletDelegate.getInputStreamAsByteArray(stream, (int)file.length());
                Object var2_3 = null;
                if (stream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var2_4 = null;
                    if (stream == null) break block6;
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    protected static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int bytesRead = -1;
            do {
                int available;
                if (contentsLength + (available = stream.available()) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + available];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((bytesRead = stream.read(contents, contentsLength, available)) <= 0) continue;
                contentsLength += bytesRead;
            } while (bytesRead > 0);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public File verifyWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IPath path = this.getWorkingDirectoryPath(configuration);
        if (path == null) {
            String outputDir = JavaRuntime.getProjectOutputDirectory((ILaunchConfiguration)configuration);
            if (outputDir == null) {
                return new File(System.getProperty("user.dir"));
            }
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(outputDir);
            if (resource == null || !resource.exists()) {
                return new File(System.getProperty("user.dir"));
            }
            return resource.getLocation().toFile();
        }
        if (path.isAbsolute()) {
            File dir = new File(path.toOSString());
            if (dir.isDirectory()) {
                return dir;
            }
            this.abort(MessageFormat.format((String)TraceMessages.AJLC_WNE, (Object[])new String[]{path.toString()}), null, 108);
        } else {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (res instanceof IContainer && res.exists()) {
                return res.getLocation().toFile();
            }
            this.abort(MessageFormat.format((String)UIPlugin.getResourceString("AbstractJavaLaunchConfigurationDelegate.Working_directory_does_not_exist__{0}_12"), (Object[])new String[]{path.toString()}), null, 108);
        }
        return null;
    }

    private String getClasspathString(ILaunchConfiguration conf) throws CoreException {
        String classPath = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, null);
        if (classPath == null) {
            StringBuffer buf = new StringBuffer();
            String[] entries = this.getClasspath(conf);
            int i = 0;
            while (i < entries.length - 1) {
                buf.append(entries[i]);
                buf.append(File.pathSeparatorChar);
                ++i;
            }
            buf.append(entries[entries.length - 1]);
            return buf.toString();
        }
        return classPath;
    }
}

