/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileCollectionsUI;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileTab;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;

public class ProfileLimitsTab {
    private TraceProfileCollectionsUI _limitsUI;
    private ProfileTab parentTab;

    public ProfileLimitsTab(ProfileTab pt, boolean attach) {
        this._limitsUI = new TraceProfileCollectionsUI(attach);
        this.parentTab = pt;
    }

    public Composite createControl(Composite parent) {
        return this._limitsUI.createControl(parent);
    }

    public void addListener(Listener _listener) {
        this._limitsUI.addListener(_listener);
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        try {
            this._limitsUI.setLimitInvocations(conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS, store.getBoolean("limitInvoc")));
            this._limitsUI.setLimitInvocNb(String.valueOf(conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS_NUM, store.getInt("invoc_nb"))));
            this._limitsUI.setLimitTime(conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS, store.getBoolean("limitTime")));
            this._limitsUI.setLimitTimeNb(String.valueOf(conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS_NUM, store.getInt("timeSec"))));
            this._limitsUI.setAutoMonitoring(conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, store.getBoolean("prof_auto_monitor")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS, this._limitsUI.getLimitInvocations());
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS_NUM, this._limitsUI.getLimitInvocNb());
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS, this._limitsUI.getLimitTime());
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS_NUM, this._limitsUI.getLimitTimeNb());
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, this._limitsUI.getAutoMonitoring());
    }

    public boolean isValid(ILaunchConfiguration conf) {
        int num;
        this.parentTab.setErrorMessage(null);
        this.parentTab.setMessage(null);
        try {
            if (this._limitsUI.getLimitInvocations() && (num = this._limitsUI.getLimitInvocNb()) < 1) {
                this.parentTab.setErrorMessage(TraceMessages.TAB_ERRLI);
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.parentTab.setErrorMessage(TraceMessages.TAB_ERRLI);
            return false;
        }
        try {
            if (this._limitsUI.getLimitTime() && (num = this._limitsUI.getLimitTimeNb()) < 1) {
                this.parentTab.setErrorMessage(TraceMessages.TAB_ERRLT);
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.parentTab.setErrorMessage(TraceMessages.TAB_ERRLT);
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS, store.getBoolean("limitInvoc"));
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS_NUM, store.getInt("invoc_nb"));
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS, store.getBoolean("limitTime"));
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS_NUM, store.getInt("timeSec"));
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, store.getBoolean("prof_auto_monitor"));
    }

    public String getName() {
        return TraceMessages.TB_NLIM;
    }

    public Image getImage() {
        return PDPluginImages.getImage("options_obj.gif");
    }
}

