/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileUI;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class ProfileTab
extends AbstractLaunchConfigurationTab {
    private TraceProfileUI _profileUI;
    private boolean isAttach = false;

    public ProfileTab(boolean attach) {
        this.isAttach = attach;
    }

    public void update() {
        this.updateLaunchConfigurationDialog();
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        this.setControl((Control)content);
        content.setLayout((Layout)new GridLayout());
        this._profileUI = new TraceProfileUI(this, this.isAttach);
        this._profileUI.createControl(content);
        this._profileUI.addListener(new Listener(){

            public void handleEvent(Event event) {
                ProfileTab.this.updateLaunchConfigurationDialog();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(UIPlugin.getPluginId()) + ".pcwp0000");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS, store.getBoolean("limitInvoc"));
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS_NUM, store.getInt("invoc_nb"));
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS, store.getBoolean("limitTime"));
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS_NUM, store.getInt("timeSec"));
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, store.getBoolean("prof_auto_monitor"));
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString("prj_name"));
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString("mon_name"));
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, null);
        ProfilingSetsManager manager = ProfilingSetsManager.instance();
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, manager.getDefaultSet().getId());
        wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_FILTER_SET, manager.getDefaultFilterSet().getId());
    }

    public void activated(ILaunchConfigurationWorkingCopy conf) {
        this._profileUI.activated(conf);
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        this._profileUI.initializeFrom(conf);
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        this._profileUI.performApply(wc);
    }

    public boolean isValid(ILaunchConfiguration conf) {
        return this._profileUI.isValid(conf);
    }

    public String getName() {
        return TraceMessages.TB_NPROF;
    }

    public Image getImage() {
        return PDPluginImages.getImage("profile_obj.gif");
    }

    public void setErrorMessage(String msg) {
        super.setErrorMessage(msg);
    }

    public void setMessage(String msg) {
        super.setMessage(msg);
    }
}

