/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher.defaults;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExecutionTimeUI
implements SelectionListener {
    private Composite _detailsHeapGroup;
    private Button _showHeapInstance;
    private Button _collectCPUtime;
    private Button _boundary;
    private Label _traceDepthLabel;
    private Text _traceDepth;
    private Composite _detailsExecGroup;
    private Button _showExecStatistic;
    private Button _showExecFlow;
    private Label titleLabel;
    private Label optionsLabel;
    private Composite _heapOptionGrp;
    private Button _advancedOptions;

    public Composite createControl(Composite parent) {
        FontData[] fonts;
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        GridData data = GridUtil.createFill();
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)data);
        this.titleLabel = new Label(result, 0);
        this.titleLabel.setText(UIPlugin.getResourceString("executionGroup"));
        this.titleLabel.setLayoutData((Object)GridUtil.createHorizontalFill());
        Font font = this.titleLabel.getFont();
        if (font != null && (fonts = font.getFontData()) != null && fonts.length >= 1) {
            this.titleLabel.setFont(new Font((Device)Display.getDefault(), fonts[0].getName(), fonts[0].getHeight() + 3, 1));
        }
        new Label(result, 0);
        this.optionsLabel = new Label(result, 64);
        this.optionsLabel.setText(TraceMessages.AN_EXTM);
        data = new GridData();
        data.horizontalIndent = 20;
        data.widthHint = 375;
        this.optionsLabel.setLayoutData((Object)data);
        Composite grp = new Composite(result, 0);
        data = GridUtil.createHorizontalFill();
        layout = new GridLayout();
        layout.numColumns = 1;
        grp.setLayout((Layout)layout);
        grp.setLayoutData((Object)data);
        this.addExecutionOption(grp);
        this.addHeapOption(grp);
        this._detailsHeapGroup.setVisible(true);
        this._detailsExecGroup.setVisible(true);
        this._traceDepth.setEnabled(this._boundary.getSelection());
        return result;
    }

    public void enableButtons() {
        this._traceDepth.setEnabled(this._boundary.getSelection());
        this.enableHeapInstance(this._showExecFlow.getSelection());
    }

    private void addHeapOption(Composite parent) {
        this._detailsHeapGroup = new Composite(parent, 0);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalIndent = 20;
        data.widthHint = 350;
        this._detailsHeapGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this._detailsHeapGroup.setLayout((Layout)layout);
        this._advancedOptions = new Button(this._detailsHeapGroup, 8);
        this._advancedOptions.setText(TraceMessages.ADV_BTN);
        this._advancedOptions.addSelectionListener((SelectionListener)this);
        this._heapOptionGrp = new Composite(this._detailsHeapGroup, 0);
        this._heapOptionGrp.setLayout((Layout)new GridLayout());
        this._showHeapInstance = new Button(this._heapOptionGrp, 32);
        this._showHeapInstance.setText(TraceMessages.SH_INSTLI);
        Label info = new Label(this._heapOptionGrp, 64);
        data = new GridData();
        data.widthHint = 375;
        info.setLayoutData((Object)data);
        info.setForeground(Display.getCurrent().getSystemColor(3));
        info.setText(TraceMessages.INSTL_INFO);
        this._heapOptionGrp.setVisible(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._showHeapInstance, String.valueOf(UIPlugin.getPluginId()) + ".topp0011");
    }

    private void addExecutionOption(Composite parent) {
        this._detailsExecGroup = new Composite(parent, 0);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalIndent = 20;
        this._detailsExecGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this._detailsExecGroup.setLayout((Layout)layout);
        this._collectCPUtime = new Button(this._detailsExecGroup, 32);
        this._collectCPUtime.setText(TraceMessages.COL_CPU);
        this._boundary = new Button(this._detailsExecGroup, 32);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this._boundary.setLayoutData((Object)data);
        this._boundary.setText(TraceMessages.AUI_BCLS);
        this._traceDepthLabel = new Label(this._detailsExecGroup, 0);
        this._traceDepthLabel.setText(TraceMessages.COL_DPT);
        this._traceDepth = new Text(this._detailsExecGroup, 2048);
        data = new GridData();
        data.widthHint = 70;
        this._traceDepth.setLayoutData((Object)data);
        Group _showExecGroup = new Group(this._detailsExecGroup, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        _showExecGroup.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        _showExecGroup.setLayout((Layout)layout);
        this._showExecStatistic = new Button((Composite)_showExecGroup, 16);
        this._showExecStatistic.setText(TraceMessages.EXEC_STAT);
        this._showExecFlow = new Button((Composite)_showExecGroup, 16);
        this._showExecFlow.setText(TraceMessages.DETAILED_DATA);
        this._boundary.addSelectionListener((SelectionListener)this);
        this._showExecStatistic.addSelectionListener((SelectionListener)this);
        this._showExecFlow.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._boundary, String.valueOf(UIPlugin.getPluginId()) + ".topp0002");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._traceDepth, String.valueOf(UIPlugin.getPluginId()) + ".topp0008");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)_showExecGroup, String.valueOf(UIPlugin.getPluginId()) + ".topp0009");
    }

    public void enable(boolean enable) {
        this.enableExecutionButtons(true);
    }

    public void enableExecutionButtons(boolean enable) {
        this._boundary.setEnabled(enable);
        this._traceDepth.setEnabled(enable);
        this._traceDepthLabel.setEnabled(enable);
        this._showExecStatistic.setEnabled(enable);
        this._showExecFlow.setEnabled(enable);
    }

    public void enableBtnGroup() {
        this.enableExecutionBtnGroup();
    }

    private void enableExecutionBtnGroup() {
        this._boundary.setEnabled(true);
        this._showExecFlow.setEnabled(true);
        this._showExecStatistic.setEnabled(true);
        this._traceDepth.setEnabled(this._boundary.getSelection());
        this._traceDepthLabel.setEnabled(this._boundary.getSelection());
    }

    public boolean getExecutionStatistic() {
        return this._showExecStatistic.getSelection();
    }

    public boolean getExecutionFlow() {
        return this._showExecFlow.getSelection();
    }

    public boolean getExecutionBoundary() {
        return this._boundary.getSelection();
    }

    public boolean getInstance() {
        return this._showHeapInstance.getSelection();
    }

    public boolean getCPUtime() {
        return this._collectCPUtime.getSelection();
    }

    public void setInstance(boolean selection) {
        this._showHeapInstance.setSelection(selection);
    }

    public void setCPUtime(boolean selection) {
        this._collectCPUtime.setSelection(selection);
    }

    public int getCollectionDepth() {
        String text = this._traceDepth.getText().trim();
        try {
            int depth = Integer.parseInt(text);
            if (depth > 0) {
                return depth;
            }
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("collect_depth");
        }
        catch (Exception exception) {
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("collect_depth");
        }
    }

    public void setExecutionStatistic(boolean select) {
        this._showExecStatistic.setSelection(select);
    }

    public void setExecutionFlow(boolean select) {
        this._showExecFlow.setSelection(select);
    }

    public void setExecutionBoundary(boolean setValue) {
        this._boundary.setSelection(setValue);
        this._traceDepth.setEnabled(this._boundary.getSelection());
        this._traceDepthLabel.setEnabled(this._boundary.getSelection());
    }

    public void setCollectionDepth(String value) {
        this._traceDepth.setText(value);
    }

    public void enableHeapInstance(boolean enable) {
        if (!enable) {
            this._showHeapInstance.setSelection(enable);
        }
        this._showHeapInstance.setEnabled(enable);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._boundary) {
            this._traceDepth.setEnabled(this._boundary.getSelection());
            this._traceDepthLabel.setEnabled(this._boundary.getSelection());
        } else if (event.widget == this._showExecStatistic) {
            this.enableHeapInstance(this._showExecFlow.getSelection());
        } else if (event.widget == this._showExecFlow) {
            this.enableHeapInstance(this._showExecFlow.getSelection());
        } else if (event.widget == this._advancedOptions) {
            this._heapOptionGrp.setVisible(!this._heapOptionGrp.getVisible());
        }
    }
}

