/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.navigator;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.navigator.ProfileDetailItem;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ProfileDetailNavigatorExtension
implements INavigatorContribution {
    protected static final String getProfilingTypesExtPoint = "profilingTypes";
    private static Map profilingTypes;
    private Map typeItems = new HashMap();

    public boolean hasChildren(Object item) {
        return item instanceof TRCAgentProxy;
    }

    public List getChildren(Object item) {
        if (item instanceof TRCAgentProxy) {
            return this.getProfileDetailItems((TRCAgentProxy)item);
        }
        return new ArrayList(0);
    }

    public Collection getModifiedItems() {
        return new ArrayList(0);
    }

    public void fillContextMenu(IMenuManager menu, IStructuredSelection selection) {
    }

    private List getProfileDetailItems(TRCAgentProxy agentProxy) {
        Vector<INavigatorItem> details = new Vector<INavigatorItem>();
        if (profilingTypes == null) {
            this.initializeProfilingTypes();
        }
        EList configs = agentProxy.getConfigurations();
        int i = 0;
        while (i < configs.size()) {
            TRCConfiguration config = (TRCConfiguration)configs.get(i);
            EList options = config.getOptions();
            int opt = 0;
            while (opt < options.size()) {
                INavigatorItem profilingType;
                TRCOption option = (TRCOption)options.get(opt);
                if (option.getKey().startsWith(String.valueOf(UIPlugin.getPluginId()) + ".type") && option.getValue().length() > 0 && (profilingType = this.getProfileDetailItem(agentProxy, option.getValue())) != null) {
                    details.add(profilingType);
                }
                ++opt;
            }
            if (details.size() > 0) break;
            ++i;
        }
        return details;
    }

    private ProfileDetailItem createProfileDetailItem(TRCAgentProxy agentProxy, String id) {
        IConfigurationElement elem = (IConfigurationElement)profilingTypes.get(id);
        if (elem != null) {
            URL pluginInstallUrl = Platform.getBundle((String)elem.getDeclaringExtension().getNamespace()).getEntry("/");
            try {
                URL url = null;
                if (elem.getAttribute("icon") != null) {
                    url = new URL(pluginInstallUrl + elem.getAttribute("icon"));
                }
                return new ProfileDetailItem(agentProxy, elem.getAttribute("name"), elem.getAttribute("id"), url);
            }
            catch (MalformedURLException e) {
                HyadesUIPlugin.logError((Throwable)e);
            }
        }
        return null;
    }

    private void initializeProfilingTypes() {
        profilingTypes = new HashMap();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.hyades.trace.ui", getProfilingTypesExtPoint);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement elem = elements[i];
                String id = elem.getAttribute("id");
                if (id.length() != 0) {
                    profilingTypes.put(id, elem);
                }
                ++i;
            }
        }
    }

    public void dispose() {
    }

    private INavigatorItem getProfileDetailItem(TRCAgentProxy agent, String typeID) {
        Map agentTypeItems;
        Object typeItem;
        Object obj = this.typeItems.get(agent);
        if (obj == null) {
            obj = new HashMap(5);
            this.typeItems.put(agent, obj);
        }
        if ((typeItem = (agentTypeItems = (Map)obj).get(typeID)) == null) {
            ProfileDetailItem item = this.createProfileDetailItem(agent, typeID);
            if (item != null) {
                agentTypeItems.put(typeID, item);
                return item;
            }
            return null;
        }
        return (INavigatorItem)typeItem;
    }
}

