/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.piclient;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.MessageFormat;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.InetAddress;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.internal.execution.local.common.ExtendedDataServerListener;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.util.ModelDebugger;
import org.eclipse.hyades.models.hierarchy.util.internal.InvalidEventException;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.internal.wizard.TraceWizardMessages;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class XMLTraceDataProcessor
extends XMLLoader
implements ExtendedDataServerListener {
    private boolean newFile;
    private static final String NEW_LINE = "\n";
    private static final int BUFFER_SIZE = 65536;
    private boolean firstEvent = true;
    private OutputStream fileWriter = null;
    private String profileFileName = null;
    private final String START_TAG = "<TRACE>";
    private final String END_TAG = "</TRACE>";
    private final String XML_VERSION_TAG = "<?xml version=\"1.0\"?>";
    private final String END_TAG_REPLACE = "\n<!-- new trace starts-->\n";
    private final String START_TRACE = "<TRACE>\n";
    private final String END_TRACE = "</TRACE>\n";
    private final String XML_VERSION = "<?xml version=\"1.0\"?>\n";
    private static final char[] ID1_IN = new char[]{'i', 'D', '1', '>'};
    private static final char[] ID1_OUT = new char[]{'i', 'D', '1', '<'};
    private static final char[] ID2_IN = new char[]{'i', 'D', '2', '>'};
    private static final char[] ID2_OUT = new char[]{'i', 'D', '2', '<'};
    private static final String INCOMMING_DATA = "incommingData";
    protected boolean specialProcessing = true;
    protected long totalBytesRead = 0L;
    protected long prevTotalBytesRead = 0L;
    protected long startTime;
    protected boolean validTag;
    protected int tempRemaining;

    public XMLTraceDataProcessor(TRCAgent agent) {
        super(agent);
        this.setCollectionMode(agent.getCollectionMode().getValue());
        new RefreshUI().start();
    }

    public XMLTraceDataProcessor(TRCAgentProxy agentProxy) {
        super(agentProxy);
        this.setCollectionMode(agentProxy.getCollectionMode().getValue());
        new RefreshUI().start();
    }

    public XMLTraceDataProcessor(TRCMonitor monitor) {
        super(monitor);
        new RefreshUI().start();
    }

    public void setWriter(OutputStream fw) {
        this.fileWriter = fw;
    }

    public OutputStream getWriter() {
        return this.fileWriter;
    }

    public void setProfileFileName(String profileFileName) {
        this.profileFileName = profileFileName;
    }

    public String getProfileFileName() {
        return this.profileFileName;
    }

    public void createWriter() {
        try {
            if (this.profileFileName != null) {
                this.fileWriter = this.makeWriter();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private OutputStream makeWriter() throws IOException {
        File f = new File(this.profileFileName);
        if (f.exists()) {
            if (!PDCoreUtil.isZipFile(this.profileFileName)) {
                this.checkAndRemoveEndTag(this.profileFileName);
                this.newFile = false;
                return new BufferedOutputStream(new FileOutputStream(this.profileFileName, true), 65536);
            }
            File newFileName = new File(f.getParentFile().getAbsolutePath() + System.getProperty("file.separator") + "Temp-" + new Date().getTime());
            this.renameFile(f, newFileName);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(f), 65536));
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(newFileName), 65536));
            this.copyZip(zipInputStream, zipOutputStream);
            zipInputStream.close();
            newFileName.delete();
            ZipEntry traceEntry = new ZipEntry("TraceContents-" + this.getTimeStamp() + ".xml");
            zipOutputStream.putNextEntry(traceEntry);
            this.newFile = true;
            return zipOutputStream;
        }
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.profileFileName));
        ZipOutputStream zipStream = new ZipOutputStream(fos);
        ZipEntry traceEntry = new ZipEntry("TraceContents-" + this.getTimeStamp() + ".xml");
        zipStream.putNextEntry(traceEntry);
        this.newFile = true;
        return zipStream;
    }

    private boolean renameFile(File f, File newFileName) {
        boolean ret = f.renameTo(newFileName);
        if (!ret) {
            ret = this.copyFile(f, newFileName);
            f.delete();
        }
        return ret;
    }

    private boolean copyFile(File f, File newFileName) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(f), 65536);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(newFileName), 65536);
            byte[] buffer = new byte[65536];
            while (bufferedInputStream.available() > 0) {
                bufferedInputStream.read(buffer);
                bufferedOutputStream.write(buffer);
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void copyZip(ZipInputStream zipInputStream, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry;
        byte[] data = new byte[65536];
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int byteCount;
            zipOutputStream.putNextEntry(zipEntry);
            while ((byteCount = zipInputStream.read(data, 0, 65536)) != -1) {
                zipOutputStream.write(data, 0, byteCount);
            }
            zipOutputStream.closeEntry();
        }
    }

    private String getTimeStamp() {
        return DateFormat.getDateTimeInstance((int)0, (int)0).format(new Date()).replace(' ', '_').replace(':', '_').replace(',', '_');
    }

    public void dataServerExited() {
        try {
            if (this.getAgentProxy() != null) {
                this.prevTotalBytesRead = this.totalBytesRead;
                this.getAgentProxy().setCollectionData(false);
                if (!this.getAgentProxy().eIsSet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_StopTime())) {
                    LoadersUtils.setSessionStopTime((double)System.currentTimeMillis(), (TRCAgentProxy)this.getAgentProxy());
                }
                this.endTrace(this.getWriter());
                this.setProfileFileName(null);
                this.setWriter(null);
                this.cleanUp();
                Display d = Display.getDefault();
                d.asyncExec(new Runnable(){

                    public void run() {
                        ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                        event.setSource(XMLTraceDataProcessor.this.getAgentProxy());
                        event.setType(1024);
                        UIPlugin.getDefault().notifyProfileEventListener(event);
                    }
                });
            }
        }
        catch (Exception exception) {}
    }

    public void dispose() {
        super.cleanUp();
        this.fileWriter = null;
    }

    public void endTrace(OutputStream randomFile) {
        try {
            if (randomFile != null) {
                randomFile.write("</TRACE>\n".getBytes());
                randomFile.flush();
                randomFile.close();
                randomFile = null;
            }
        }
        catch (IOException iOException) {}
    }

    private boolean isValidTag(byte[] buf, int offset, int length) {
        if (this.validTag) {
            return true;
        }
        if (this.startsWith(buf, offset, length, "<TRACE>".getBytes()) || this.startsWith(buf, offset, length, "<?xml version=\"1.0\"?>".getBytes())) {
            return false;
        }
        this.validTag = true;
        return true;
    }

    private boolean startsWith(byte[] container, int offset, int length, byte[] bytes) {
        if (length < bytes.length) {
            return false;
        }
        int i = 0;
        while (i < bytes.length) {
            if (container[offset + i] != bytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void incommingData(byte[] buffer, int offset, int length, InetAddress peer) {
        if (ModelDebugger.INSTANCE.debugEventValue) {
            ModelDebugger.INSTANCE.writeBinaryLog(INCOMMING_DATA, buffer, offset, length);
        }
        if (ModelDebugger.INSTANCE.debugEventFlow) {
            System.out.println(ID1_IN);
        }
        try {
            if (this.getAgentProxy() != null && this.getAgentProxy().isToProfileFile()) {
                this.totalBytesRead += (long)length;
                if (this.isValidTag(buffer, offset, length)) {
                    this.writeByte(buffer, offset, length);
                }
            } else {
                if (this.firstEvent) {
                    if (length > 1 && (buffer[offset] != 60 || buffer[offset + 1] != 63)) {
                        LoadersUtils.loadRootEvent((XMLLoader)this);
                    }
                    this.firstEvent = false;
                }
                super.loadEvent(buffer, offset, length);
            }
        }
        catch (InvalidXMLException invalidXMLException) {
        }
        catch (OutOfMemoryError e) {
            this.handleOutOfMemoryError();
            this.stopAgent();
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(ID1_OUT);
                System.out.println(" = " + e.getLocalizedMessage());
            }
            LoadersUtils.log((Throwable)e);
            throw e;
        }
        if (ModelDebugger.INSTANCE.debugEventFlow) {
            System.out.println(ID1_OUT);
        }
    }

    public void incommingData(char[] buffer, int offset, int length, InetAddress peer) {
        if (ModelDebugger.INSTANCE.debugEventFlow) {
            System.out.println(ID2_IN);
        }
        byte[] newBuffer = new byte[length];
        int i = 0;
        while (i < length) {
            newBuffer[i] = (byte)buffer[offset + i];
            ++i;
        }
        if (ModelDebugger.INSTANCE.debugEventValue) {
            ModelDebugger.INSTANCE.writeBinaryLog(INCOMMING_DATA, newBuffer, 0, length);
        }
        try {
            if (this.getAgentProxy() != null && this.getAgentProxy().isToProfileFile()) {
                this.totalBytesRead += (long)length;
                if (this.isValidTag(newBuffer, 0, length)) {
                    this.writeByte(newBuffer, 0, length);
                }
            } else {
                if (this.firstEvent) {
                    if (length > 1 && (buffer[0] != '<' || buffer[1] != '?')) {
                        LoadersUtils.loadRootEvent((XMLLoader)this);
                    }
                    this.firstEvent = false;
                }
                super.loadEvent(newBuffer, length);
            }
        }
        catch (InvalidXMLException invalidXMLException) {
        }
        catch (OutOfMemoryError e) {
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(ID2_OUT);
                System.out.println(" = " + e.getLocalizedMessage());
            }
            this.handleOutOfMemoryError();
            this.stopAgent();
            LoadersUtils.log((Throwable)e);
            throw e;
        }
        System.out.println(ID2_OUT);
    }

    public void invalidDataType(byte[] data, int offset, int length, InetAddress peer) {
    }

    public void waitingForData() {
    }

    public void startTrace(OutputStream randomFile) {
        try {
            if (this.getAgentProxy() != null) {
                randomFile.write("<TRACE>\n".getBytes());
                randomFile.flush();
            }
        }
        catch (IOException iOException) {}
    }

    public void writeHeader(Writer randomFile) {
    }

    public void writeXMLVersion(OutputStream randomFile) {
        try {
            randomFile.write("<?xml version=\"1.0\"?>\n".getBytes());
            randomFile.flush();
        }
        catch (IOException iOException) {}
    }

    private TRCAgentProxy getAgentProxy() {
        return this.getContext().getAgentProxy();
    }

    private void handleOutOfMemoryError() {
        final Status err = new Status(2, "org.eclipse.core.resources", 566, TraceMessages.POUTMEM_ERRT, null);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)new Shell(), (String)TraceMessages.TRC_MSGT, (String)TraceMessages.OUTMEM_ERRT, (IStatus)err);
            }
        });
    }

    private synchronized void notifyListener(Agent a, TRCAgentProxy agent) {
        final TRCAgentProxy ag = agent;
        Display d = Display.getDefault();
        d.asyncExec(new Runnable(){

            public void run() {
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource(ag);
                event.setType(2);
                UIPlugin.getDefault().notifyProfileEventListener(event);
            }
        });
    }

    private void stopAgent() {
        if (this.getAgentProxy() != null) {
            try {
                Agent ai = (Agent)LoadersUtils.locateAgentInstance((TRCAgentProxy)this.getAgentProxy());
                if (ai != null) {
                    ai.stopMonitoring();
                }
            }
            catch (InactiveAgentException e) {
                e.printStackTrace();
            }
            this.getAgentProxy().setMonitored(false);
            this.getAgentProxy().setAttached(false);
            this.getAgentProxy().setActive(false);
            LoadersUtils.deregisterDataProcessor((TRCAgentProxy)this.getAgentProxy());
            if (this.fileWriter != null) {
                this.endTrace(this.fileWriter);
            }
            this.notifyListener((Agent)LoadersUtils.locateAgentInstance((TRCAgentProxy)this.getAgentProxy()), this.getAgentProxy());
        }
    }

    private void writeByte(byte[] data, int offset, int length) {
        try {
            if (this.fileWriter != null) {
                this.fileWriter.write(data, offset, length);
                this.fileWriter.write(NEW_LINE.getBytes());
                this.fileWriter.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isNewProfileFile() {
        return this.newFile;
    }

    public boolean checkAndRemoveEndTag(String filename) {
        File checkFile = new File(filename);
        if (checkFile.exists() && checkFile.isFile()) {
            try {
                RandomAccessFile raf = new RandomAccessFile(checkFile, "rw");
                long checkFileSize = raf.length();
                StringBuffer b = new StringBuffer("</TRACE>");
                long seekLocation = checkFileSize - (long)b.length() - 2L;
                if (seekLocation < 0L) {
                    seekLocation = 0L;
                }
                raf.seek(seekLocation);
                while (seekLocation <= checkFileSize) {
                    String readLine = raf.readLine();
                    StringBuffer t = new StringBuffer(readLine);
                    if (readLine.indexOf("</TRACE>") >= 0) {
                        raf.seek(seekLocation);
                        raf.writeBytes("\n<!-- new trace starts-->\n");
                        raf.close();
                        return true;
                    }
                    seekLocation += (long)t.length();
                }
                raf.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void incommingData(byte[] data, int length, InetAddress peer) {
        this.incommingData(data, 0, length, peer);
    }

    public void incommingData(char[] data, int length, InetAddress peer) {
        this.incommingData(data, 0, length, peer);
    }

    public void invalidDataType(byte[] data, int length, InetAddress peer) {
        this.invalidDataType(data, 0, length, peer);
    }

    public void incommingStream(InputStream inputStream, InetAddress peer) {
        if (this.getAgentProxy() != null && this.getAgentProxy().isToProfileFile()) {
            try {
                int readBytes = 0;
                this.totalBytesRead = 0L;
                this.prevTotalBytesRead = 0L;
                byte[] buffer = new byte[65536];
                while ((readBytes = inputStream.read(buffer)) != -1) {
                    this.totalBytesRead += (long)readBytes;
                    this.fileWriter.write(buffer, 0, readBytes);
                }
                this.fileWriter.flush();
                this.fileWriter.close();
            }
            catch (IOException e) {
                Status status = new Status(4, UIPlugin.getPluginId(), 4, "", (Throwable)e);
                UIPlugin.getDefault().log((IStatus)status);
            }
        } else {
            this.loadEvents(inputStream, 0, -1);
        }
    }

    public void loadEvents(InputStream inputStream, int offset, int length) throws InvalidEventException {
        if (this.scanner == null) {
            return;
        }
        final InputStream delegatedInputStream = inputStream;
        InputStream monitoredInputStream = new InputStream(){
            byte[] temp;
            byte[] oneByte = new byte[1];

            public synchronized int read(byte[] b, int off, int len) throws IOException {
                int readBytes = 0;
                if (XMLTraceDataProcessor.this.specialProcessing) {
                    if (XMLTraceDataProcessor.this.firstEvent) {
                        readBytes = delegatedInputStream.read(b, off, 2);
                        if (readBytes > 1 && b[off] == 60 && b[off + 1] != 63) {
                            readBytes = "<TRACE>".getBytes().length;
                            this.temp = new byte[readBytes += 2];
                            System.arraycopy("<TRACE>".getBytes(), 0, this.temp, 0, "<TRACE>".getBytes().length);
                            this.temp[this.temp.length - 2] = b[off];
                            this.temp[this.temp.length - 1] = b[off + 1];
                            readBytes = Math.min(readBytes, len);
                            System.arraycopy(this.temp, 0, b, off, readBytes);
                            if ((len -= readBytes) > 0) {
                                readBytes += delegatedInputStream.read(b, off + readBytes, len);
                                XMLTraceDataProcessor.this.specialProcessing = false;
                                this.temp = null;
                            } else if (len < 0) {
                                XMLTraceDataProcessor.this.tempRemaining = this.temp.length - readBytes;
                            } else {
                                XMLTraceDataProcessor.this.specialProcessing = false;
                                this.temp = null;
                            }
                        } else {
                            readBytes = delegatedInputStream.read(b, off, len);
                            XMLTraceDataProcessor.this.specialProcessing = false;
                        }
                        XMLTraceDataProcessor.this.firstEvent = false;
                    } else {
                        readBytes = Math.min(XMLTraceDataProcessor.this.tempRemaining, len);
                        System.arraycopy(this.temp, 0, b, off, readBytes);
                        off += readBytes;
                        if ((len -= readBytes) > 0) {
                            readBytes += delegatedInputStream.read(b, off, len);
                        }
                        XMLTraceDataProcessor.this.tempRemaining -= readBytes;
                        if (XMLTraceDataProcessor.this.tempRemaining == 0) {
                            XMLTraceDataProcessor.this.specialProcessing = false;
                            this.temp = null;
                        }
                    }
                } else {
                    readBytes = delegatedInputStream.read(b, off, len);
                }
                XMLTraceDataProcessor.this.totalBytesRead += (long)readBytes;
                if (ModelDebugger.INSTANCE.debugEventValue) {
                    ModelDebugger.INSTANCE.writeBinaryLog(XMLTraceDataProcessor.INCOMMING_DATA, b, off, readBytes);
                }
                return readBytes;
            }

            public int available() throws IOException {
                return delegatedInputStream.available();
            }

            public void close() throws IOException {
                delegatedInputStream.close();
                XMLTraceDataProcessor.this.tempRemaining = -1;
            }

            public synchronized void mark(int readlimit) {
                delegatedInputStream.mark(readlimit);
            }

            public boolean markSupported() {
                return delegatedInputStream.markSupported();
            }

            public int read() throws IOException {
                if (this.read(this.oneByte, 0, 1) == -1) {
                    return -1;
                }
                return this.oneByte[0];
            }

            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            public synchronized void reset() throws IOException {
                delegatedInputStream.reset();
            }

            public long skip(long n) throws IOException {
                return delegatedInputStream.skip(n);
            }
        };
        try {
            this.scanner.scanContent((InputStream)new BufferedInputStream(monitoredInputStream, 16384), (long)offset, (long)length);
        }
        catch (Throwable e) {
            if (this.tempRemaining != -1) {
                long deltaTime = (System.currentTimeMillis() - this.startTime) / 1000L;
                if (deltaTime == 0L) {
                    deltaTime = 1L;
                }
                String status = MessageFormat.format((String)TraceWizardMessages.LIVE_PROGRESS, (Object[])new String[]{"" + this.getProcessedFragments(), "" + (long)this.getProcessedFragments() / deltaTime, "" + deltaTime, "" + this.totalBytesRead, "" + this.totalBytesRead / deltaTime});
                Status s = new Status(4, UIPlugin.getDefault().getName(), 4, status, e);
                UIPlugin.getDefault().log((IStatus)s);
            }
            return;
        }
        long deltaTime = (System.currentTimeMillis() - this.startTime) / 1000L;
        if (deltaTime == 0L) {
            deltaTime = 1L;
        }
        String status = MessageFormat.format((String)TraceWizardMessages.LIVE_PROGRESS, (Object[])new String[]{"" + this.getProcessedFragments(), "" + (long)this.getProcessedFragments() / deltaTime, "" + deltaTime, "" + this.totalBytesRead, "" + this.totalBytesRead / deltaTime});
        Status s = new Status(0, UIPlugin.getDefault().getName(), 0, status, null);
        UIPlugin.getDefault().log((IStatus)s);
    }

    public synchronized void cleanUp() {
        long deltaTime = (System.currentTimeMillis() - this.startTime) / 1000L;
        if (deltaTime == 0L) {
            deltaTime = 1L;
        }
        String status = MessageFormat.format((String)TraceWizardMessages.LIVE_PROGRESS, (Object[])new String[]{"" + this.getProcessedFragments(), "" + (long)this.getProcessedFragments() / deltaTime, "" + deltaTime, "" + this.totalBytesRead, "" + this.totalBytesRead / deltaTime});
        Status s = new Status(0, UIPlugin.getDefault().getName(), 0, status, null);
        UIPlugin.getDefault().log((IStatus)s);
        Display d = Display.getDefault();
        if (d == null || d.isDisposed()) {
            return;
        }
        if (this.getAgentProxy() != null && this.getAgentProxy().isCollectionData()) {
            this.getAgentProxy().setCollectionData(false);
        }
        d.asyncExec(new Runnable(){

            public void run() {
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource(XMLTraceDataProcessor.this.getAgentProxy());
                event.setType(1024);
                UIPlugin.getDefault().notifyProfileEventListener(event);
                if (ModelDebugger.INSTANCE.debug) {
                    LoadersUtils.log((String)"Live connection refresh thread - set STOP_COLLECTING ");
                }
            }
        });
        super.cleanUp();
    }

    public void loadEvent(byte[] buffer, int offset, int length, boolean loadToModel, boolean toProfileFile) throws InvalidXMLException {
        if (toProfileFile) {
            this.totalBytesRead += (long)length;
        }
        super.loadEvent(buffer, offset, length, loadToModel, toProfileFile);
    }

    public void loadEvent(byte[] buffer, int offset, int length, boolean loadToModel) throws InvalidXMLException {
        this.totalBytesRead += (long)length;
        super.loadEvent(buffer, offset, length, loadToModel);
    }

    class RefreshUI
    extends Thread {
        int collectingState;
        int prevProcessedFragments = 0;
        long prevTime;

        public RefreshUI() {
            super("Profile UI");
        }

        public void updateStatusBar() {
            Display d = Display.getDefault();
            if (d == null || d.isDisposed()) {
                return;
            }
            d.asyncExec(new Runnable(this){
                private long t;
                private long t1;
                final /* synthetic */ RefreshUI this$1;
                {
                    this.this$1 = refreshUI;
                }

                public void run() {
                    INavigator navigator = HyadesUtil.getActiveNavigator();
                    if (navigator == null) {
                        return;
                    }
                    if (HyadesUtil.getMofObject() != XMLTraceDataProcessor.access$0(RefreshUI.access$0(this.this$1))) {
                        return;
                    }
                    this.t = System.currentTimeMillis();
                    this.t1 = (this.t - this.this$1.prevTime) / 1000L;
                    this.this$1.prevTime = this.t;
                    this.t = (this.t - RefreshUI.access$0((RefreshUI)this.this$1).startTime) / 1000L;
                    if (this.t == 0L) {
                        this.t = 1L;
                    }
                    if (this.t1 == 0L) {
                        this.t1 = 1L;
                    }
                    int deltaEvents = RefreshUI.access$0(this.this$1).getProcessedFragments() - this.this$1.prevProcessedFragments;
                    this.this$1.prevProcessedFragments = RefreshUI.access$0(this.this$1).getProcessedFragments();
                    String statusBarMessage = MessageFormat.format((String)TraceWizardMessages.LIVE_PROGRESS, (Object[])new String[]{"" + this.this$1.prevProcessedFragments, "" + (long)deltaEvents / this.t1, "" + this.t, "" + RefreshUI.access$0((RefreshUI)this.this$1).totalBytesRead, "" + (RefreshUI.access$0((RefreshUI)this.this$1).totalBytesRead - RefreshUI.access$0((RefreshUI)this.this$1).prevTotalBytesRead) / this.t1});
                    IStatusLineManager statusLineManager = navigator.getViewSite().getActionBars().getStatusLineManager();
                    statusLineManager.setMessage(statusBarMessage);
                    if (ModelDebugger.INSTANCE.debug) {
                        LoadersUtils.log((String)"Live connection refresh thread - update status bar");
                    }
                }
            });
        }

        public void run() {
            Display d;
            this.prevTime = XMLTraceDataProcessor.this.startTime = System.currentTimeMillis();
            while (XMLTraceDataProcessor.this.scanner != null) {
                try {
                    this.updateStatusBar();
                    if (XMLTraceDataProcessor.this.getAgentProxy() != null) {
                        if (XMLTraceDataProcessor.this.prevTotalBytesRead == XMLTraceDataProcessor.this.totalBytesRead) {
                            if (this.collectingState != 1) {
                                if (XMLTraceDataProcessor.this.getAgentProxy().isCollectionData()) {
                                    XMLTraceDataProcessor.this.getAgentProxy().setCollectionData(false);
                                }
                                if ((d = Display.getDefault()) == null || d.isDisposed()) {
                                    return;
                                }
                                d.asyncExec(new Runnable(this){
                                    final /* synthetic */ RefreshUI this$1;
                                    {
                                        this.this$1 = refreshUI;
                                    }

                                    public void run() {
                                        ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                                        event.setSource(XMLTraceDataProcessor.access$0(RefreshUI.access$0(this.this$1)));
                                        event.setType(1024);
                                        UIPlugin.getDefault().notifyProfileEventListener(event);
                                        if (ModelDebugger.INSTANCE.debug) {
                                            LoadersUtils.log((String)"Live connection refresh thread - set STOP_COLLECTING ");
                                        }
                                    }
                                });
                                this.collectingState = 1;
                            }
                        } else if (XMLTraceDataProcessor.this.totalBytesRead > XMLTraceDataProcessor.this.prevTotalBytesRead && this.collectingState != 2) {
                            if (!XMLTraceDataProcessor.this.getAgentProxy().isCollectionData()) {
                                XMLTraceDataProcessor.this.getAgentProxy().setCollectionData(true);
                            }
                            if ((d = Display.getDefault()) == null || d.isDisposed()) {
                                return;
                            }
                            d.asyncExec(new Runnable(this){
                                final /* synthetic */ RefreshUI this$1;
                                {
                                    this.this$1 = refreshUI;
                                }

                                public void run() {
                                    ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                                    event.setSource(XMLTraceDataProcessor.access$0(RefreshUI.access$0(this.this$1)));
                                    event.setType(512);
                                    UIPlugin.getDefault().notifyProfileEventListener(event);
                                    if (ModelDebugger.INSTANCE.debug) {
                                        LoadersUtils.log((String)"Live connection refresh thread - set COLLECTING ");
                                    }
                                }
                            });
                            this.collectingState = 2;
                        }
                    }
                    XMLTraceDataProcessor.this.prevTotalBytesRead = XMLTraceDataProcessor.this.totalBytesRead;
                    RefreshUI.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            d = Display.getDefault();
            if (d != null && !d.isDisposed()) {
                d.syncExec(new Runnable(this){
                    final /* synthetic */ RefreshUI this$1;
                    {
                        this.this$1 = refreshUI;
                    }

                    public void run() {
                        try {
                            INavigator navigator = HyadesUtil.getActiveNavigator();
                            if (navigator == null) {
                                return;
                            }
                            String statusBarMessage = "";
                            IStatusLineManager statusLineManager = navigator.getViewSite().getActionBars().getStatusLineManager();
                            statusLineManager.setMessage(statusBarMessage);
                        }
                        catch (Exception exception) {}
                    }
                });
            }
        }

        static /* synthetic */ XMLTraceDataProcessor access$0(RefreshUI refreshUI) {
            return refreshUI.XMLTraceDataProcessor.this;
        }
    }
}

