/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.preferences;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.context.ContextMappingPreference;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.ContextOpenSourceHandlerManager;
import org.eclipse.hyades.ui.provisional.context.IContextHandler;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.hyades.ui.provisional.context.IContextOpenSourceHandler;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ContextMappingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    private Table contextLanguagesTable;
    private Table contextProvidersTable;
    private Table contextOpenSourceProvidersTable;
    private ContextMappingPreference contextMappingPreference;

    public ContextMappingPreferencePage() {
        this.noDefaultAndApplyButton();
        this.contextMappingPreference = new ContextMappingPreference(this.getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.contextMappingPreference.populateMappingByContext();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(UIPlugin.getPluginId()) + ".tbpp0007");
        Composite pageComponent = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        pageComponent.setLayout((Layout)gridLayout);
        pageComponent.setLayoutData((Object)GridDataUtil.createFill());
        this.contextLanguagesTable = this.createSelectionTable(pageComponent, TraceMessages._10, 8);
        Group group = this.createGroup(pageComponent);
        this.contextProvidersTable = this.createSelectionTable((Composite)group, TraceMessages._11, 5);
        Label spacer = new Label((Composite)group, 16384);
        GridData data = new GridData();
        data.heightHint = 1;
        spacer.setLayoutData((Object)data);
        this.contextOpenSourceProvidersTable = this.createSelectionTable((Composite)group, TraceMessages._12, 5);
        this.populateLanguagesTable();
        this.populateProviderTables();
        return pageComponent;
    }

    private Table createSelectionTable(Composite parent, String labelText, int rows) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        Table selectionTable = new Table(parent, 67588);
        GridData gridData = new GridData(768);
        gridData.heightHint = parent.getFont().getFontData()[0].getHeight() * rows;
        selectionTable.setLayoutData((Object)gridData);
        selectionTable.addSelectionListener((SelectionListener)this);
        return selectionTable;
    }

    private Group createGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(TraceMessages._13);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)GridUtil.createFill());
        return group;
    }

    public boolean performOk() {
        boolean result = this.contextMappingPreference.writeMappingToPreferenceStore();
        if (result && this.contextMappingPreference.changed()) {
            ProfileEvent event = UIPlugin.getDefault().getContextHandlerSelectionChangedEvent((Object)this);
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
        return result;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return HyadesUIPlugin.getInstance().getPreferenceStore();
    }

    private void populateLanguagesTable() {
        IContextLanguage[] languages = ContextManager.getContextLanguages();
        Arrays.sort(languages, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 != null && o2 != null) {
                    String name1 = ((IContextLanguage)o1).name();
                    String name2 = ((IContextLanguage)o2).name();
                    if (name1 != null && name2 != null) {
                        return name1.compareTo(name2);
                    }
                    return o1.hashCode() - o2.hashCode();
                }
                return 0;
            }
        });
        this.contextLanguagesTable.removeAll();
        int i = 0;
        int maxi = languages.length;
        while (i < maxi) {
            TableItem item = new TableItem(this.contextLanguagesTable, 0);
            item.setData((Object)languages[i]);
            ImageDescriptor imageDescriptor = languages[i].icon();
            if (imageDescriptor != null) {
                item.setImage(imageDescriptor.createImage());
            }
            item.setText(languages[i].name());
            ++i;
        }
        this.contextLanguagesTable.select(0);
    }

    private void populateContextProviderTable() {
        IContextLanguage language = (IContextLanguage)this.contextLanguagesTable.getSelection()[0].getData();
        IContextHandler[] chs = ContextManager.getContextHandlers((String)language.contextKey());
        Arrays.sort(chs, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 != null && o2 != null) {
                    String name1 = ((IContextHandler)o1).getContextProvider().getName();
                    String name2 = ((IContextHandler)o2).getContextProvider().getName();
                    if (name1 != null && name2 != null) {
                        return name1.compareTo(name2);
                    }
                    return o1.hashCode() - o2.hashCode();
                }
                return 0;
            }
        });
        this.contextProvidersTable.removeAll();
        String selectedContextProviderId = this.contextMappingPreference.getContextProviderId(language.contextKey());
        int selectedIndex = -1;
        int i = 0;
        int maxi = chs.length;
        while (i < maxi) {
            TableItem item = new TableItem(this.contextProvidersTable, 0);
            item.setData((Object)chs[i]);
            if (chs[i].getContextProvider().getName() != null) {
                item.setText(chs[i].getContextProvider().getName());
            } else {
                item.setText(chs[i].id());
            }
            if (chs[i].id().equals(selectedContextProviderId)) {
                selectedIndex = i;
            }
            ++i;
        }
        if (selectedIndex >= 0) {
            this.contextProvidersTable.select(selectedIndex);
        }
    }

    private void populateContextOpenSourceProviderTable() {
        IContextLanguage language = (IContextLanguage)this.contextLanguagesTable.getSelection()[0].getData();
        IContextOpenSourceHandler[] coshs = ContextOpenSourceHandlerManager.getContextOpenSourceHandlers((String)language.contextKey());
        Arrays.sort(coshs, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 != null && o2 != null) {
                    String name1 = ((IContextOpenSourceHandler)o1).getContextOpenSourceProvider().getName();
                    String name2 = ((IContextOpenSourceHandler)o2).getContextOpenSourceProvider().getName();
                    if (name1 != null && name2 != null) {
                        return name1.compareTo(name2);
                    }
                    return o1.hashCode() - o2.hashCode();
                }
                return 0;
            }
        });
        this.contextOpenSourceProvidersTable.removeAll();
        String selectedContextOpenSourceProviderId = this.contextMappingPreference.getContextOpenSourceProviderId(language.contextKey());
        int selectedIndex = -1;
        int i = 0;
        int maxi = coshs.length;
        while (i < maxi) {
            TableItem item = new TableItem(this.contextOpenSourceProvidersTable, 0);
            item.setData((Object)coshs[i]);
            if (coshs[i].getContextOpenSourceProvider().getName() != null) {
                item.setText(coshs[i].getContextOpenSourceProvider().getName());
            } else {
                item.setText(coshs[i].id());
            }
            if (coshs[i].id().equals(selectedContextOpenSourceProviderId)) {
                selectedIndex = i;
            }
            ++i;
        }
        if (selectedIndex >= 0) {
            this.contextOpenSourceProvidersTable.select(selectedIndex);
        }
    }

    private void populateProviderTables() {
        this.populateContextProviderTable();
        this.populateContextOpenSourceProviderTable();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.contextLanguagesTable) {
            if (this.contextLanguagesTable.getSelection().length > 0) {
                this.populateProviderTables();
            }
        } else if (e.widget == this.contextProvidersTable) {
            if (this.contextProvidersTable.getSelection().length > 0) {
                this.contextMappingPreference.setContextProviderId(((IContextLanguage)this.contextLanguagesTable.getSelection()[0].getData()).contextKey(), ((IContextHandler)this.contextProvidersTable.getSelection()[0].getData()).id());
            }
        } else if (e.widget == this.contextOpenSourceProvidersTable && this.contextOpenSourceProvidersTable.getSelection().length > 0) {
            this.contextMappingPreference.setContextOpenSourceProviderId(((IContextLanguage)this.contextLanguagesTable.getSelection()[0].getData()).contextKey(), ((IContextOpenSourceHandler)this.contextOpenSourceProvidersTable.getSelection()[0].getData()).id());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        super.dispose();
    }
}

