/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.preference.AssociationMappingPreferencePage;

public class TraceViewMappingPreferencePage
extends AssociationMappingPreferencePage {
    private IAssociationMappingRegistry registry = (AssociationMappingRegistry)TraceAssociationManager.getTraceViewMappingRegistry();

    public TraceViewMappingPreferencePage() {
        super(String.valueOf(UIPlugin.getPluginId()) + ".tprp0001");
    }

    protected void beforeIsPresented() {
        this.registry.checkpoint();
    }

    public void dispose() {
        this.registry.clearCheckpoint();
        this.registry = null;
        super.dispose();
    }

    protected IAssociationMapping getSelectionAssociationMapping() {
        return this.registry.getAssociationMapping("typeDescriptions");
    }

    public IAssociationMapping[] getDetailMappings() {
        ArrayList<IAssociationMapping> arrayList = new ArrayList<IAssociationMapping>(Arrays.asList(this.registry.getAssociationMappings()));
        arrayList.remove(this.getSelectionAssociationMapping());
        return arrayList.toArray(new IAssociationMapping[arrayList.size()]);
    }

    public String getSelectionLabel() {
        return UIPlugin.getResourceString("traceSelectionLabel");
    }

    protected String getLabel(IAssociationMapping associationMapping) {
        if ("typeDescriptions".equals(associationMapping.getExtensionPoint())) {
            return UIPlugin.getResourceString(TraceMessages.TRACE_TYPES);
        }
        if ("analyzerExtensions".equals(associationMapping.getExtensionPoint())) {
            return UIPlugin.getResourceString(TraceMessages.TRACE_VIEWS);
        }
        return null;
    }

    public boolean performCancel() {
        return this.registry.rollback();
    }

    public boolean performOk() {
        if (!this.registry.commit()) {
            return false;
        }
        UIPlugin.getDefault().savePluginPreferences();
        return true;
    }
}

