/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.reports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.internal.ui.PDLabelProvider;
import org.eclipse.hyades.trace.ui.internal.reports.HTMLTraceReportWizard;
import org.eclipse.hyades.trace.ui.internal.reports.TraceReportMessages;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;

public class CSVTraceReportWizard
extends HTMLTraceReportWizard {
    public CSVTraceReportWizard() {
        this.setWindowTitle(TraceMessages._18);
        this.FILE_EXTENSION = "csv";
    }

    protected boolean export(Object selection, String fileName) {
        OutputStreamWriter writer = null;
        try {
            File file = new File(fileName);
            FileOutputStream outputStream = new FileOutputStream(file.toString(), false);
            writer = new OutputStreamWriter((OutputStream)outputStream, "UTF8");
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        List agentList = this.getSelectionAgents(selection);
        this.generateAgentStatistics(agentList, buffer);
        try {
            writer.write(buffer.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    protected void generateAgentStatistics(List agentList, StringBuffer buffer) {
        PDLabelProvider label = new PDLabelProvider();
        int idx = 0;
        while (idx < agentList.size()) {
            TRCAgentProxy agent = (TRCAgentProxy)agentList.get(idx);
            buffer.append(newLine);
            buffer.append(this.getCSVFormat(label.getText(agent)));
            if (PerftraceUtil.getTotalSize((EObject)agent) > 0L) {
                this.generateMemoryStatistics(agent, buffer);
            }
            if (PerftraceUtil.getMaximumCumulativeTime((EObject)agent) > 0.0) {
                this.generateExecutionStatistics(agent, buffer);
            }
            ++idx;
        }
    }

    protected void generateExecutionStatistics(TRCAgentProxy agent, StringBuffer buffer) {
        Object[] packages = PerftraceUtil.getAllPackages((EObject)agent);
        HashMap<String, TRCPackage> map = new HashMap<String, TRCPackage>();
        int idx = 0;
        while (idx < packages.length) {
            TRCPackage pack = (TRCPackage)packages[idx];
            if (pack.getCalls() != 0) {
                map.put(PerftraceUtil.formatTimeValue(pack.getBaseTime()), pack);
            }
            ++idx;
        }
        Object[] keys = map.keySet().toArray();
        double[] time = new double[keys.length];
        int idx2 = 0;
        while (idx2 < keys.length) {
            time[idx2] = Double.parseDouble(keys[idx2].toString());
            ++idx2;
        }
        Arrays.sort(time);
        buffer.append(newLine).append(this.getCSVFormat(TraceReportMessages._11));
        buffer.append(newLine).append(this.getCSVFormat(TraceReportMessages._1)).append(",").append(">").append(TraceReportMessages._4).append(",").append(TraceReportMessages._5).append(",").append(TraceReportMessages._7);
        idx2 = time.length - 1;
        while (idx2 >= 0) {
            String timeVal = PerftraceUtil.formatTimeValue(time[idx2]);
            TRCPackage pack = (TRCPackage)map.get(timeVal);
            buffer.append(newLine).append(this.getCSVFormat(PerftraceUtil.getPackageName(pack, agent)));
            buffer.append(",").append(this.getCSVFormat(timeVal));
            buffer.append(",").append(this.getCSVFormat(PerftraceUtil.formatTimeValue(pack.getCumulativeTime())));
            buffer.append(",").append(pack.getCalls());
            this.generateClassExecutionStatistics(pack, buffer);
            --idx2;
        }
    }

    protected void generateClassExecutionStatistics(TRCPackage pack, StringBuffer buffer) {
        Iterator classes = pack.getClasses().iterator();
        HashMap<String, TRCClass> map = new HashMap<String, TRCClass>();
        while (classes.hasNext()) {
            TRCClass cls = (TRCClass)classes.next();
            if (cls.getCalls() == 0) continue;
            map.put(PerftraceUtil.formatTimeValue(cls.getBaseTime()), cls);
        }
        Object[] keys = map.keySet().toArray();
        double[] time = new double[keys.length];
        int idx = 0;
        while (idx < keys.length) {
            time[idx] = Double.parseDouble(keys[idx].toString());
            ++idx;
        }
        Arrays.sort(time);
        idx = time.length - 1;
        while (idx >= 0) {
            String timeVal = PerftraceUtil.formatTimeValue(time[idx]);
            TRCClass cls = (TRCClass)map.get(timeVal);
            buffer.append(newLine).append("    ").append(this.getCSVFormat(cls.getName()));
            buffer.append(",").append(this.getCSVFormat(timeVal));
            buffer.append(",").append(this.getCSVFormat(PerftraceUtil.formatTimeValue(cls.getCumulativeTime())));
            buffer.append(",").append(cls.getCalls());
            this.generateMethodExecutionStatistics(cls, buffer);
            --idx;
        }
    }

    protected void generateMethodExecutionStatistics(TRCClass cls, StringBuffer buffer) {
        Iterator methods = cls.getMethods().iterator();
        HashMap<String, TRCMethod> map = new HashMap<String, TRCMethod>();
        while (methods.hasNext()) {
            TRCMethod meth = (TRCMethod)methods.next();
            if (meth.getCalls() == 0) continue;
            map.put(PerftraceUtil.formatTimeValue(meth.getBaseTime()), meth);
        }
        Object[] keys = map.keySet().toArray();
        double[] time = new double[keys.length];
        int idx = 0;
        while (idx < keys.length) {
            time[idx] = Double.parseDouble(keys[idx].toString());
            ++idx;
        }
        Arrays.sort(time);
        idx = time.length - 1;
        while (idx >= 0) {
            String timeVal = PerftraceUtil.formatTimeValue(time[idx]);
            TRCMethod meth = (TRCMethod)map.get(timeVal);
            buffer.append(newLine).append("         ").append(this.getCSVFormat(String.valueOf(meth.getName()) + meth.getSignature()));
            buffer.append(",").append(this.getCSVFormat(timeVal));
            buffer.append(",").append(this.getCSVFormat(PerftraceUtil.formatTimeValue(meth.getCumulativeTime())));
            buffer.append(",").append(meth.getCalls());
            --idx;
        }
    }

    protected void generateMemoryStatistics(TRCAgentProxy agent, StringBuffer buffer) {
        Object[] packages = PerftraceUtil.getAllPackages((EObject)agent);
        HashMap<String, TRCPackage> map = new HashMap<String, TRCPackage>();
        int idx = 0;
        while (idx < packages.length) {
            TRCPackage pack = (TRCPackage)packages[idx];
            if (pack.getTotalInstances() != 0) {
                map.put(String.valueOf(pack.getTotalSize()), pack);
            }
            ++idx;
        }
        Object[] keys = map.keySet().toArray();
        int[] size = new int[keys.length];
        int idx2 = 0;
        while (idx2 < keys.length) {
            size[idx2] = Integer.parseInt(keys[idx2].toString());
            ++idx2;
        }
        Arrays.sort(size);
        buffer.append(newLine).append(this.getCSVFormat(TraceReportMessages._8)).append(newLine);
        buffer.append(TraceReportMessages._1);
        buffer.append(",").append(TraceReportMessages._2);
        buffer.append(",").append(TraceReportMessages._9);
        buffer.append(",").append(">").append(TraceReportMessages._6);
        buffer.append(",").append(TraceReportMessages._10);
        buffer.append(",").append(TraceReportMessages._3);
        idx2 = size.length - 1;
        while (idx2 >= 0) {
            TRCPackage pack = (TRCPackage)map.get(String.valueOf(size[idx2]));
            buffer.append(newLine).append(this.getCSVFormat(PerftraceUtil.getPackageName(pack, agent)));
            buffer.append(",").append(pack.getTotalInstances());
            buffer.append(",").append(pack.getTotalInstances() - pack.getCollectedInstances());
            buffer.append(",").append(size[idx2]);
            buffer.append(",").append(pack.getTotalSize() - pack.getCollectedSize());
            buffer.append(",").append(pack.getCollectedInstances());
            this.generateClassMemoryStatistics(pack, buffer);
            --idx2;
        }
    }

    protected void generateClassMemoryStatistics(TRCPackage pack, StringBuffer buffer) {
        Iterator classes = pack.getClasses().iterator();
        HashMap<String, TRCClass> map = new HashMap<String, TRCClass>();
        while (classes.hasNext()) {
            TRCClass clas = (TRCClass)classes.next();
            if (clas.getTotalInstances() == 0) continue;
            map.put(String.valueOf(clas.getTotalSize()), clas);
        }
        Object[] keys = map.keySet().toArray();
        int[] size = new int[keys.length];
        int idx = 0;
        while (idx < keys.length) {
            size[idx] = Integer.parseInt(keys[idx].toString());
            ++idx;
        }
        Arrays.sort(size);
        idx = size.length - 1;
        while (idx >= 0) {
            TRCClass clas = (TRCClass)map.get(String.valueOf(size[idx]));
            buffer.append(newLine).append("    ").append(this.getCSVFormat(clas.getName()));
            buffer.append(",").append(clas.getTotalInstances());
            buffer.append(",").append(clas.getTotalInstances() - clas.getCollectedInstances());
            buffer.append(",").append(size[idx]);
            buffer.append(",").append(clas.getTotalSize() - clas.getCollectedSize());
            buffer.append(",").append(clas.getCollectedInstances());
            --idx;
        }
    }
}

