/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.reports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.internal.ui.PDLabelProvider;
import org.eclipse.hyades.trace.ui.internal.reports.HTMLTraceStatReportWizard;
import org.eclipse.hyades.trace.ui.internal.reports.TraceReportMessages;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class HTMLTraceReportWizard
extends HTMLTraceStatReportWizard {
    public HTMLTraceReportWizard() {
        this.setWindowTitle(TraceMessages._16);
    }

    public boolean isAvailable(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object object = ((StructuredSelection)selection).getFirstElement();
        if (object == null) {
            return false;
        }
        if (object instanceof TRCMonitor) {
            TRCMonitor mon = (TRCMonitor)object;
            Iterator nodes = mon.getNodes().iterator();
            while (nodes.hasNext()) {
                TRCNode node = (TRCNode)nodes.next();
                Iterator processes = node.getProcessProxies().iterator();
                while (processes.hasNext()) {
                    TRCProcessProxy proces = (TRCProcessProxy)processes.next();
                    Iterator agents = proces.getAgentProxies().iterator();
                    while (agents.hasNext()) {
                        TRCAgentProxy ag = (TRCAgentProxy)agents.next();
                        if (ag.getType() == null || !ag.getType().equals("Profiler")) continue;
                        return true;
                    }
                }
            }
        } else if (object instanceof TRCNode) {
            TRCNode node = (TRCNode)object;
            Iterator processes = node.getProcessProxies().iterator();
            while (processes.hasNext()) {
                TRCProcessProxy proces = (TRCProcessProxy)processes.next();
                Iterator agents = proces.getAgentProxies().iterator();
                while (agents.hasNext()) {
                    TRCAgentProxy ag = (TRCAgentProxy)agents.next();
                    if (ag.getType() == null || !ag.getType().equals("Profiler")) continue;
                    return true;
                }
            }
        } else if (object instanceof TRCProcessProxy) {
            TRCProcessProxy proces = (TRCProcessProxy)object;
            Iterator agents = proces.getAgentProxies().iterator();
            while (agents.hasNext()) {
                TRCAgentProxy ag = (TRCAgentProxy)agents.next();
                if (ag.getType() == null || !ag.getType().equals("Profiler")) continue;
                return true;
            }
        } else {
            Object parent;
            if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType() != null && ((TRCAgentProxy)object).getType().equals("Profiler")) {
                return true;
            }
            if (object instanceof INavigatorItem && (parent = ((INavigatorItem)object).getParent()) != null && parent instanceof TRCAgentProxy && ((TRCAgentProxy)parent).getType() != null && ((TRCAgentProxy)parent).getType().equals("Profiler")) {
                return true;
            }
        }
        return false;
    }

    public IFile generate(IProgressMonitor monitor) throws Exception {
        Object sel = this.getSelection().getFirstElement();
        monitor.beginTask("", 4);
        IFile reportFile = this.getReportFile();
        monitor.worked(1);
        this.export(sel, reportFile.getLocation().toOSString());
        monitor.worked(1);
        reportFile.getProject().refreshLocal(2, null);
        monitor.done();
        return reportFile;
    }

    protected boolean export(Object selection, String fileName) {
        OutputStreamWriter writer = null;
        try {
            File file = new File(fileName);
            FileOutputStream outputStream = new FileOutputStream(file.toString(), false);
            writer = new OutputStreamWriter((OutputStream)outputStream, "UTF8");
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.printHeader());
        buffer.append(this.printTitle(new PDLabelProvider().getText(selection)));
        List agentList = this.getSelectionAgents(selection);
        this.generateAgentStatistics(agentList, buffer);
        buffer.append(this.printFooter());
        try {
            writer.write(buffer.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    protected void generateAgentStatistics(List agentList, StringBuffer buffer) {
        PDLabelProvider label = new PDLabelProvider();
        int idx = 0;
        while (idx < agentList.size()) {
            TRCAgentProxy agent = (TRCAgentProxy)agentList.get(idx);
            this.printTitle(label.getText(agent));
            if (PerftraceUtil.getTotalSize((EObject)agent) > 0L) {
                this.generateMemoryStatistics(agent, buffer);
            }
            if (PerftraceUtil.getMaximumCumulativeTime((EObject)agent) > 0.0) {
                this.generateExecutionStatistics(agent, buffer);
            }
            ++idx;
        }
    }

    protected void generateExecutionStatistics(TRCAgentProxy agent, StringBuffer buffer) {
        Object[] packages = PerftraceUtil.getAllPackages((EObject)agent);
        HashMap<String, TRCPackage> map = new HashMap<String, TRCPackage>();
        int idx = 0;
        while (idx < packages.length) {
            TRCPackage pack = (TRCPackage)packages[idx];
            if (pack.getCalls() != 0) {
                map.put(PerftraceUtil.formatTimeValue(pack.getBaseTime()), pack);
            }
            ++idx;
        }
        Object[] keys = map.keySet().toArray();
        double[] time = new double[keys.length];
        int idx2 = 0;
        while (idx2 < keys.length) {
            time[idx2] = Double.parseDouble(keys[idx2].toString());
            ++idx2;
        }
        Arrays.sort(time);
        buffer.append("<p>").append(this.printTitle(TraceReportMessages._11)).append("<p>");
        buffer.append("<table border=0 cellspacing=2 cellpadding=2 WIDTH=\"100%\">").append(newLine);
        buffer.append("<tr width=\"10\">").append(newLine);
        buffer.append("<th align=").append(this.getAlign()).append(">").append(TraceReportMessages._1).append("</th>").append(newLine);
        buffer.append("<th align=").append(this.getAlign()).append(">").append("&lt;").append(TraceReportMessages._4).append("</th>").append(newLine);
        buffer.append("<th align=").append(this.getAlign()).append(">").append(TraceReportMessages._5).append("</th>").append(newLine);
        buffer.append("<th align=").append(this.getAlign()).append(">").append(TraceReportMessages._7).append("</th>").append(newLine);
        buffer.append("</tr>").append(newLine);
        boolean color = true;
        int idx3 = time.length - 1;
        while (idx3 >= 0) {
            String timeVal = PerftraceUtil.formatTimeValue(time[idx3]);
            TRCPackage pack = (TRCPackage)map.get(timeVal);
            if (color) {
                buffer.append("<tr BGCOLOR=\"#ffffbb\">").append(newLine);
            } else {
                buffer.append("<tr>" + newLine);
            }
            buffer.append("<td align=").append(this.getAlign()).append(">").append(PerftraceUtil.getPackageName(pack, agent)).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append(timeVal).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append(PerftraceUtil.formatTimeValue(pack.getCumulativeTime())).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append(pack.getCalls()).append("</td>");
            buffer.append(newLine);
            color = !color;
            buffer.append("</tr>").append(newLine);
            this.generateClassExecutionStatistics(pack, buffer, color);
            --idx3;
        }
        buffer.append("</table>").append(newLine);
    }

    protected void generateClassExecutionStatistics(TRCPackage pack, StringBuffer buffer, boolean color) {
        Iterator classes = pack.getClasses().iterator();
        HashMap<String, TRCClass> map = new HashMap<String, TRCClass>();
        while (classes.hasNext()) {
            TRCClass cls = (TRCClass)classes.next();
            if (cls.getCalls() == 0) continue;
            map.put(PerftraceUtil.formatTimeValue(cls.getBaseTime()), cls);
        }
        Object[] keys = map.keySet().toArray();
        double[] time = new double[keys.length];
        int idx = 0;
        while (idx < keys.length) {
            time[idx] = Double.parseDouble(keys[idx].toString());
            ++idx;
        }
        Arrays.sort(time);
        idx = time.length - 1;
        while (idx >= 0) {
            String timeVal = PerftraceUtil.formatTimeValue(time[idx]);
            TRCClass cls = (TRCClass)map.get(timeVal);
            if (color) {
                buffer.append("<tr BGCOLOR=\"#ffffbb\">").append(newLine);
            } else {
                buffer.append("<tr>" + newLine);
            }
            buffer.append("<td align=").append(this.getAlign()).append(">").append("&nbsp;&nbsp;&nbsp;&nbsp;").append(cls.getName()).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append("&nbsp;&nbsp;&nbsp;&nbsp;").append(timeVal).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append("&nbsp;&nbsp;&nbsp;&nbsp;").append(PerftraceUtil.formatTimeValue(cls.getCumulativeTime())).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append("&nbsp;&nbsp;&nbsp;&nbsp;").append(cls.getCalls()).append("</td>");
            buffer.append(newLine);
            color = !color;
            buffer.append("</tr>").append(newLine);
            this.generateMethodExecutionStatistics(cls, buffer, color);
            --idx;
        }
    }

    protected void generateMethodExecutionStatistics(TRCClass cls, StringBuffer buffer, boolean color) {
        Iterator methods = cls.getMethods().iterator();
        HashMap<String, TRCMethod> map = new HashMap<String, TRCMethod>();
        while (methods.hasNext()) {
            TRCMethod meth = (TRCMethod)methods.next();
            if (meth.getCalls() == 0) continue;
            map.put(PerftraceUtil.formatTimeValue(meth.getBaseTime()), meth);
        }
        Object[] keys = map.keySet().toArray();
        double[] time = new double[keys.length];
        int idx = 0;
        while (idx < keys.length) {
            time[idx] = Double.parseDouble(keys[idx].toString());
            ++idx;
        }
        Arrays.sort(time);
        idx = time.length - 1;
        while (idx >= 0) {
            String timeVal = PerftraceUtil.formatTimeValue(time[idx]);
            TRCMethod meth = (TRCMethod)map.get(timeVal);
            if (color) {
                buffer.append("<tr BGCOLOR=\"#ffffbb\">").append(newLine);
            } else {
                buffer.append("<tr>" + newLine);
            }
            buffer.append("<td align=").append(this.getAlign()).append(">").append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(meth.getName()).append(meth.getSignature()).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(timeVal).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(PerftraceUtil.formatTimeValue(meth.getCumulativeTime())).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(meth.getCalls()).append("</td>");
            buffer.append(newLine);
            color = !color;
            buffer.append("</tr>").append(newLine);
            --idx;
        }
    }

    protected List getSelectionAgents(Object object) {
        Object parent;
        ArrayList<Object> agentList = new ArrayList<Object>();
        if (object instanceof TRCMonitor) {
            TRCMonitor mon = (TRCMonitor)object;
            Iterator nodes = mon.getNodes().iterator();
            while (nodes.hasNext()) {
                TRCNode node = (TRCNode)nodes.next();
                Iterator processes = node.getProcessProxies().iterator();
                while (processes.hasNext()) {
                    TRCProcessProxy proces = (TRCProcessProxy)processes.next();
                    Iterator agents = proces.getAgentProxies().iterator();
                    while (agents.hasNext()) {
                        TRCAgentProxy ag = (TRCAgentProxy)agents.next();
                        if (ag.getType() == null || !ag.getType().equals("Profiler")) continue;
                        agentList.add(ag);
                    }
                }
            }
        } else if (object instanceof TRCNode) {
            TRCNode node = (TRCNode)object;
            Iterator processes = node.getProcessProxies().iterator();
            while (processes.hasNext()) {
                TRCProcessProxy proces = (TRCProcessProxy)processes.next();
                Iterator agents = proces.getAgentProxies().iterator();
                while (agents.hasNext()) {
                    TRCAgentProxy ag = (TRCAgentProxy)agents.next();
                    if (ag.getType() == null || !ag.getType().equals("Profiler")) continue;
                    agentList.add(ag);
                }
            }
        } else if (object instanceof TRCProcessProxy) {
            TRCProcessProxy proces = (TRCProcessProxy)object;
            Iterator agents = proces.getAgentProxies().iterator();
            while (agents.hasNext()) {
                TRCAgentProxy ag = (TRCAgentProxy)agents.next();
                if (ag.getType() == null || !ag.getType().equals("Profiler")) continue;
                agentList.add(ag);
            }
        } else if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType() != null && ((TRCAgentProxy)object).getType().equals("Profiler")) {
            agentList.add(object);
        } else if (object instanceof INavigatorItem && (parent = ((INavigatorItem)object).getParent()) != null && parent instanceof TRCAgentProxy && ((TRCAgentProxy)parent).getType() != null && ((TRCAgentProxy)parent).getType().equals("Profiler")) {
            agentList.add(parent);
        }
        return agentList;
    }

    protected void generateMemoryStatistics(TRCAgentProxy agent, StringBuffer buffer) {
        Object[] packages = PerftraceUtil.getAllPackages((EObject)agent);
        HashMap<String, TRCPackage> map = new HashMap<String, TRCPackage>();
        int idx = 0;
        while (idx < packages.length) {
            TRCPackage pack = (TRCPackage)packages[idx];
            if (pack.getTotalInstances() != 0) {
                map.put(String.valueOf(pack.getTotalSize()), pack);
            }
            ++idx;
        }
        Object[] keys = map.keySet().toArray();
        int[] size = new int[keys.length];
        int idx2 = 0;
        while (idx2 < keys.length) {
            size[idx2] = Integer.parseInt(keys[idx2].toString());
            ++idx2;
        }
        Arrays.sort(size);
        buffer.append("<p>").append(this.printTitle(TraceReportMessages._8)).append("<p>");
        buffer.append("<table border=0 cellspacing=2 cellpadding=2 WIDTH=\"100%\">").append(newLine);
        buffer.append("<tr width=\"10\">").append(newLine);
        buffer.append("<th align=").append(this.getAlign()).append(">").append(TraceReportMessages._1).append("</th>").append(newLine);
        buffer.append("<th align=").append(this.getAlign()).append(">").append(TraceReportMessages._2).append("</th>").append(newLine);
        buffer.append("<th align=").append(this.getAlign()).append(">").append(TraceReportMessages._9).append("</th>").append(newLine);
        buffer.append("<th align=").append(this.getAlign()).append(">").append("&lt;").append(TraceReportMessages._6).append("</th>").append(newLine);
        buffer.append("<th align=").append(this.getAlign()).append(">").append(TraceReportMessages._10).append("</th>").append(newLine);
        buffer.append("<th align=").append(this.getAlign()).append(">").append(TraceReportMessages._3).append("</th>").append(newLine);
        buffer.append("</tr>").append(newLine);
        boolean color = true;
        int idx3 = size.length - 1;
        while (idx3 >= 0) {
            TRCPackage pack = (TRCPackage)map.get(String.valueOf(size[idx3]));
            if (color) {
                buffer.append("<tr BGCOLOR=\"#ffffbb\">").append(newLine);
            } else {
                buffer.append("<tr>" + newLine);
            }
            buffer.append("<td align=").append(this.getAlign()).append(">").append(PerftraceUtil.getPackageName(pack, agent)).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append(pack.getTotalInstances()).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append(pack.getTotalInstances() - pack.getCollectedInstances()).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append(size[idx3]).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append(pack.getTotalSize() - pack.getCollectedSize()).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append(pack.getCollectedInstances()).append("</td>");
            buffer.append(newLine);
            color = !color;
            buffer.append("</tr>").append(newLine);
            this.generateClassMemoryStatitics(pack, buffer, color);
            --idx3;
        }
        buffer.append("</table>").append(newLine);
    }

    protected void generateClassMemoryStatitics(TRCPackage pack, StringBuffer buffer, boolean color) {
        Iterator classes = pack.getClasses().iterator();
        HashMap<String, TRCClass> map = new HashMap<String, TRCClass>();
        while (classes.hasNext()) {
            TRCClass clas = (TRCClass)classes.next();
            if (clas.getTotalInstances() == 0) continue;
            map.put(String.valueOf(clas.getTotalSize()), clas);
        }
        Object[] keys = map.keySet().toArray();
        int[] size = new int[keys.length];
        int idx = 0;
        while (idx < keys.length) {
            size[idx] = Integer.parseInt(keys[idx].toString());
            ++idx;
        }
        Arrays.sort(size);
        idx = size.length - 1;
        while (idx >= 0) {
            TRCClass clas = (TRCClass)map.get(String.valueOf(size[idx]));
            if (color) {
                buffer.append("<tr BGCOLOR=\"#ffffbb\">").append(newLine);
            } else {
                buffer.append("<tr>" + newLine);
            }
            buffer.append("<td align=").append(this.getAlign()).append(">").append("&nbsp;&nbsp;&nbsp;&nbsp;").append(clas.getName()).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append("&nbsp;&nbsp;&nbsp;&nbsp;").append(clas.getTotalInstances()).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append("&nbsp;&nbsp;&nbsp;&nbsp;").append(clas.getTotalInstances() - clas.getCollectedInstances()).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append("&nbsp;&nbsp;&nbsp;&nbsp;").append(size[idx]).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append("&nbsp;&nbsp;&nbsp;&nbsp;").append(clas.getTotalSize() - clas.getCollectedSize()).append("</td>");
            buffer.append("<td align=").append(this.getAlign()).append(">").append("&nbsp;&nbsp;&nbsp;&nbsp;").append(clas.getCollectedInstances()).append("</td>");
            buffer.append(newLine);
            color = !color;
            buffer.append("</tr>").append(newLine);
            --idx;
        }
    }
}

