/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.reports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.extension.IExportViewer;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.hyades.ui.internal.wizard.LocationPage;
import org.eclipse.hyades.ui.report.ReportGeneratorWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class HTMLTraceStatReportWizard
extends ReportGeneratorWizard {
    protected static final String newLine = System.getProperties().getProperty("line.separator");
    protected String FILE_EXTENSION = "html";
    protected LocationPage locationPage;

    public HTMLTraceStatReportWizard() {
        this.setWindowTitle(TraceMessages._16);
    }

    public boolean isAvailable(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object sel = ((StructuredSelection)selection).getFirstElement();
        if (!(sel instanceof IExportViewer)) {
            return false;
        }
        Object[] controls = ((IExportViewer)sel).getViewerControls();
        if (controls == null) {
            return false;
        }
        int idx = 0;
        while (idx < controls.length) {
            if (controls[idx] instanceof Tree) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    protected void initPages() {
        this.locationPage = new LocationPage("location", this.adjustLocation());
        this.locationPage.setTitle(TraceMessages._14);
        this.locationPage.setDescription(TraceMessages._15);
        this.locationPage.setFileExtension(this.FILE_EXTENSION);
    }

    protected IStructuredSelection adjustLocation() {
        IResource res;
        IContainer parent;
        IStructuredSelection structuredSelection = this.getSelection();
        Object selection = structuredSelection.getFirstElement();
        if (selection instanceof IResource && (parent = (res = (IResource)selection).getParent()) != null && parent.exists()) {
            structuredSelection = new StructuredSelection((Object)parent);
        }
        return structuredSelection;
    }

    public IFile generate(IProgressMonitor monitor) throws Exception {
        Object sel = this.getSelection().getFirstElement();
        if (sel == null || !(sel instanceof IExportViewer)) {
            return null;
        }
        monitor.beginTask("", 4);
        IFile reportFile = this.getReportFile();
        monitor.worked(1);
        this.export((IExportViewer)sel, reportFile.getLocation().toOSString());
        monitor.worked(1);
        reportFile.getProject().refreshLocal(2, null);
        monitor.done();
        return reportFile;
    }

    protected IFile getReportFile() {
        IFile file = null;
        IPath path = this.locationPage.getContainerFullPath();
        IContainer res = this.createContainer(path);
        path = new Path(this.locationPage.getFileName());
        file = res.getFile(path);
        this.locationPage.allowOverwrite();
        return file;
    }

    protected void addReportPages() throws Exception {
        this.addPage((IWizardPage)this.locationPage);
    }

    public boolean canFinish() {
        return this.locationPage.getItemName().length() > 0 && this.locationPage.getContainerFullPath() != null;
    }

    private IContainer createContainer(IPath path) {
        IFolder container = null;
        IWorkspace workbench = ResourcesPlugin.getWorkspace();
        int segCount = path.segmentCount();
        int idx = 0;
        while (idx < segCount) {
            if (idx == 0) {
                IProject project = workbench.getRoot().getProject(path.uptoSegment(idx + 1).toString());
                if (project == null || !project.exists()) {
                    try {
                        project.create(null);
                    }
                    catch (Exception e) {
                        UIPlugin.getDefault().log(e);
                        e.printStackTrace();
                    }
                }
                try {
                    project.open(null);
                }
                catch (Exception exception) {}
                container = project;
            } else {
                IFolder folder = workbench.getRoot().getFolder(path.uptoSegment(idx + 1));
                if (folder == null || !folder.exists()) {
                    try {
                        folder.create(false, true, null);
                    }
                    catch (Exception e) {
                        UIPlugin.getDefault().log(e);
                        e.printStackTrace();
                    }
                }
                container = folder;
            }
            ++idx;
        }
        try {
            container.getProject().refreshLocal(2, null);
        }
        catch (CoreException exc) {
            UIPlugin.getDefault().log(exc);
            exc.printStackTrace();
        }
        return container;
    }

    protected boolean export(IExportViewer viewer, String fileName) {
        if (fileName == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)TraceMessages.TRC_MSGT, (String)TraceMessages._6);
            return false;
        }
        OutputStreamWriter writer = null;
        try {
            File file = new File(fileName);
            if (file.isDirectory()) {
                MessageDialog.openError((Shell)this.getShell(), (String)TraceMessages.TRC_MSGT, (String)TraceMessages._7);
                return false;
            }
            FileOutputStream outputStream = new FileOutputStream(file.toString(), false);
            writer = new OutputStreamWriter((OutputStream)outputStream, "UTF8");
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.printHeader());
        buffer.append(this.printTitle(viewer.getViewerTitle()));
        int idx = 0;
        while (idx < viewer.getViewerControls().length) {
            if (viewer.getViewerControls()[idx] instanceof Tree) {
                buffer.append(this.printColumns((Tree)viewer.getViewerControls()[idx]));
            }
            ++idx;
        }
        buffer.append(this.printFooter());
        try {
            writer.write(buffer.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    protected String printHeader() {
        String newLine = System.getProperties().getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html").append(this.getDirection()).append(">").append(newLine);
        buffer.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">").append(newLine).append("<head>").append(newLine).append("<STYLE TYPE=\"text/css\">").append(newLine).append("p, table, td, th {  font-family: arial, helvetica, geneva; font-size: 10pt}").append(newLine).append("body {  font-family: arial, helvetica, geneva; font-size: 10pt; clip:   rect(   ); margin-top: 5mm; margin-left: 3mm}").append(newLine).append("</STYLE>").append(newLine).append("</head>").append(newLine);
        buffer.append("<body text=\"#000000\" bgcolor=\"#ffffff\">").append(newLine);
        return buffer.toString();
    }

    protected String printTitle(String title) {
        String newLine = System.getProperties().getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<caption align=top><B>").append(newLine);
        buffer.append(this.replaceEntities(title)).append(newLine);
        buffer.append("</B></caption>").append(newLine);
        return buffer.toString();
    }

    protected String printFooter() {
        String newLine = System.getProperties().getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("</body>").append(newLine);
        buffer.append("</html>").append(newLine);
        return buffer.toString();
    }

    protected String printColumns(Tree tree) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<table border=0 cellspacing=2 cellpadding=2 WIDTH=\"100%\">").append(newLine);
        buffer.append("<tr>").append(newLine);
        int idx = 0;
        while (idx < tree.getColumnCount()) {
            String columnText = tree.getColumn(idx).getText();
            if (columnText.indexOf("<") == 0) {
                columnText = "&lt;" + columnText.substring(1);
            } else if (columnText.indexOf(">") == 0) {
                columnText = "&gt;" + columnText.substring(1);
            }
            buffer.append("<th align=").append(this.getAlign()).append(">").append(columnText).append("</th>").append(newLine);
            ++idx;
        }
        buffer.append("</tr>").append(newLine);
        this.printTreeItems(tree.getItems(), 0, true, buffer, tree.getColumnCount());
        buffer.append("</table>").append(newLine);
        return buffer.toString();
    }

    protected boolean printTreeItems(TreeItem[] treeItems, int level, boolean color, StringBuffer buffer, int columnCount) {
        int kdx = 0;
        while (kdx < treeItems.length) {
            if (color) {
                buffer.append("<tr BGCOLOR=\"#ffffbb\">").append(newLine);
            } else {
                buffer.append("<tr>").append(newLine);
            }
            int ndx = 0;
            while (ndx < columnCount) {
                buffer.append("<td align=").append(this.getAlign()).append(">").append(ndx == 0 ? this.getFirstColumnIndentString(treeItems[kdx], level) : "").append(treeItems[kdx].getText(ndx)).append("</td>").append(newLine);
                ++ndx;
            }
            buffer.append("</tr>").append(newLine);
            boolean bl = color = !color;
            if (treeItems[kdx].getExpanded()) {
                color = this.printTreeItems(treeItems[kdx].getItems(), level + 1, color, buffer, columnCount);
            }
            ++kdx;
        }
        return color;
    }

    protected String getFirstColumnIndentString(TreeItem item, int level) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < level) {
            buffer.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            ++i;
        }
        if (item.getItemCount() > 0) {
            if (item.getExpanded()) {
                buffer.append("[-]&nbsp;");
            } else {
                buffer.append("[+]&nbsp;");
            }
        } else {
            buffer.append("&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        return buffer.toString();
    }

    protected String getDirection() {
        if (Window.getDefaultOrientation() == 0x4000000) {
            return " dir=\"rtl\"";
        }
        return "";
    }

    protected String getAlign() {
        if (Window.getDefaultOrientation() == 0x4000000) {
            return "right";
        }
        return "left";
    }

    protected String getCSVFormat(String text) {
        if (text == null) {
            return text;
        }
        if (text.indexOf(",") == -1 && text.indexOf("\"") == -1) {
            return text;
        }
        text = text.replaceAll("\"", "\"\"");
        return "\"" + text + "\"";
    }

    public boolean performFinish() {
        IFile reportFile = this.getReportFile();
        if (reportFile.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)UIMessages._158, (String)UIMessages._159)) {
            return false;
        }
        return super.performFinish();
    }

    public String replaceEntities(String original) {
        String result = original;
        result = result.replaceAll("\\&", "&amp;");
        result = result.replaceAll("\\<", "&lt;");
        result = result.replaceAll("\\>", "&gt;");
        result = result.replaceAll("\\'", "&apos;");
        result = result.replaceAll("\\\"", "&guot;");
        return result;
    }
}

