/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.reports;

import org.eclipse.hyades.trace.ui.internal.reports.HTMLTraceStatReportWizard;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class XMLTraceStatReportWizard
extends HTMLTraceStatReportWizard {
    public XMLTraceStatReportWizard() {
        this.setWindowTitle(TraceMessages._19);
        this.FILE_EXTENSION = "xml";
    }

    protected String printHeader() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(newLine).append("<View");
        return buffer.toString();
    }

    protected String printTitle(String title) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" name=\"").append(this.replaceEntities(title)).append("\">").append(newLine);
        return buffer.toString();
    }

    protected String printFooter() {
        String newLine = System.getProperties().getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("</View>").append(newLine);
        return buffer.toString();
    }

    protected String printColumns(Tree tree) {
        StringBuffer buffer = new StringBuffer();
        String[] names = new String[tree.getColumnCount()];
        int idx = 0;
        while (idx < tree.getColumnCount()) {
            String columnText = tree.getColumn(idx).getText();
            if (columnText.indexOf("<") == 0 || columnText.indexOf(">") == 0) {
                columnText = columnText.substring(1);
            }
            names[idx] = this.getValidAttributeName(columnText);
            ++idx;
        }
        TreeItem[] items = tree.getItems();
        this.printTreeColumns(names, items, 0, buffer);
        return buffer.toString();
    }

    protected void printTreeColumns(String[] names, TreeItem[] items, int level, StringBuffer buffer) {
        int idx = 0;
        while (idx < items.length) {
            int j = 0;
            while (j < level) {
                buffer.append("  ");
                ++j;
            }
            buffer.append("<data");
            int i = 0;
            while (i < names.length) {
                if (names[i] != null && names[i].length() != 0) {
                    buffer.append(" ").append(this.replaceEntities(names[i])).append("=\"").append(this.replaceEntities(items[idx].getText(i))).append("\"");
                }
                ++i;
            }
            if (items[idx].getExpanded()) {
                buffer.append(">").append(newLine);
                this.printTreeColumns(names, items[idx].getItems(), level + 1, buffer);
                j = 0;
                while (j < level) {
                    buffer.append("  ");
                    ++j;
                }
                buffer.append("</data>").append(newLine);
            } else {
                buffer.append("/>").append(newLine);
            }
            ++idx;
        }
    }

    private String getValidAttributeName(String columnText) {
        if (columnText == null) {
            return null;
        }
        columnText = columnText.replace(' ', '_');
        columnText = columnText.replace(')', '.');
        columnText = columnText.replace('(', '.');
        return columnText;
    }
}

