/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.DeferredProcessAdapter;
import org.eclipse.hyades.trace.ui.internal.launcher.ProcessWrapperRunnable;
import org.eclipse.hyades.trace.ui.internal.util.ErrorItem;
import org.eclipse.hyades.trace.ui.internal.util.ProcessTreeItem;
import org.eclipse.hyades.trace.ui.internal.util.ProfilingAgentList;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.WorkbenchJob;

public class CTree {
    private Label _label;
    private Tree _tree;
    private Listener _uiListener;
    private Composite groupWidget;
    private TreeViewer _viewer;
    private CTreeContentProvider _contentProvider;
    private CTreeLabelProvider _labelProvider;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private ProfilingAgentList _agentList;

    public CTree(Composite parent, String text) {
        this.groupWidget = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.groupWidget.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        data.heightHint = 200;
        data.widthHint = 250;
        this.groupWidget.setLayoutData((Object)data);
        this._label = new Label(this.groupWidget, 0);
        this._label.setText(text);
        this._tree = new Tree(this.groupWidget, 2818);
        this._viewer = new TreeViewer(this._tree);
        this._viewer.setContentProvider(this.getContentProvider());
        this._viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this._tree.setLayoutData((Object)GridUtil.createFill());
        this._agentList = null;
    }

    protected IContentProvider getContentProvider() {
        if (this._contentProvider == null) {
            this._contentProvider = new CTreeContentProvider();
        }
        return this._contentProvider;
    }

    protected ILabelProvider getLabelProvider() {
        if (this._labelProvider == null) {
            this._labelProvider = new CTreeLabelProvider();
        }
        return this._labelProvider;
    }

    protected TreeViewer getTreeViewer() {
        return this._viewer;
    }

    public void initializeTree(ILaunchConfiguration conf) {
        this._contentProvider.setLaunchConfiguration(conf);
        this._agentList = null;
        this.getTreeViewer().setInput((Object)new ProcessTreeItem(null, null));
    }

    public void resetTree(ProfilingAgentList agentList) {
        this._agentList = agentList;
        this.getTreeViewer().setInput((Object)agentList);
    }

    private Tree getTree() {
        return this.getTreeViewer().getTree();
    }

    public void setRedraw(boolean redraw) {
        this.getTree().setRedraw(redraw);
    }

    public void enable(boolean enable) {
        this.getTree().setEnabled(enable);
        this._label.setEnabled(enable);
    }

    public Object[] getSelectedItems() {
        Vector<Object> selectedItemsV = new Vector<Object>();
        ISelection iSelection = this.getTreeViewer().getSelection();
        if (!(iSelection instanceof StructuredSelection)) {
            return new Object[0];
        }
        Object[] selection = ((StructuredSelection)iSelection).toArray();
        Object[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof ProcessTreeItem && this.isItemSelected((ProcessTreeItem)items[i], selection)) {
                selectedItemsV.addElement(items[i]);
            }
            ++i;
        }
        return selectedItemsV.toArray();
    }

    private boolean isItemSelected(ProcessTreeItem pti, Object[] selection) {
        int i = 0;
        while (i < selection.length) {
            if (pti == selection[i]) {
                return true;
            }
            if (pti.getParent() == selection[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object[] getItems() {
        TreeItem[] items = this.getTree().getItems();
        Vector<Object> itemsV = new Vector<Object>();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() instanceof ProcessTreeItem) {
                if (((ProcessTreeItem)items[i].getData()).getData() instanceof Process) {
                    Object[] agentItems = this.getChildrenInTree((ProcessTreeItem)items[i].getData());
                    int j = 0;
                    while (j < agentItems.length) {
                        itemsV.addElement(agentItems[j]);
                        ++j;
                    }
                } else if (((ProcessTreeItem)items[i].getData()).getData() instanceof ErrorItem) {
                    itemsV.addElement(items[i].getData());
                }
            } else {
                itemsV.addElement(items[i].getData());
            }
            ++i;
        }
        return itemsV.toArray();
    }

    public void clearSelection() {
        this.getTree().deselectAll();
    }

    public void setSelectionFromData(Object[] data) {
        StructuredSelection sSelection = new StructuredSelection(data);
        this.getTreeViewer().setSelection((ISelection)sSelection);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.getTree().addSelectionListener(listener);
    }

    public void addPaintListener(PaintListener listener) {
        this.getTree().addPaintListener(listener);
    }

    public boolean hasWidget(Widget widget) {
        return this.getTree() == widget;
    }

    public int getItemCount() {
        return this.getItems().length;
    }

    public void setUIListener(Listener uiListener) {
        this._uiListener = uiListener;
    }

    private Object[] getChildrenInTree(ProcessTreeItem parent) {
        if (this._agentList == null) {
            return parent.getChildren();
        }
        Vector<ProcessTreeItem> childrenV = new Vector<ProcessTreeItem>();
        ProcessTreeItem[] ptiItems = parent.getChildren();
        int i = 0;
        while (i < ptiItems.length) {
            if (this._agentList.agentInList(ptiItems[i])) {
                childrenV.addElement(ptiItems[i]);
            }
            ++i;
        }
        return childrenV.toArray();
    }

    static /* synthetic */ Listener access$3(CTree cTree) {
        return cTree._uiListener;
    }

    public class CTreeContentProvider
    implements ITreeContentProvider {
        private ILaunchConfiguration _conf;
        private DeferredTreeContentManager tManager;

        public void setLaunchConfiguration(ILaunchConfiguration conf) {
            this._conf = conf;
        }

        public ILaunchConfiguration getLaunchConfiguration() {
            return this._conf;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ProcessTreeItem) {
                ProcessTreeItem pti = (ProcessTreeItem)parentElement;
                if (pti.getData() instanceof Process && CTree.this._agentList != null) {
                    return CTree.this.getChildrenInTree(pti);
                }
                if (this.tManager != null) {
                    pti.setAdapter(new DeferredProcessAdapter(this, pti, CTree.this.getTreeViewer()));
                    Object[] children = this.tManager.getChildren((Object)pti);
                    if (children != null) {
                        return children;
                    }
                }
                return this.fetchChildren(pti);
            }
            if (parentElement instanceof ProfilingAgentList) {
                return ((ProfilingAgentList)parentElement).getProcessList();
            }
            return EMPTY_ARRAY;
        }

        public Object getParent(Object element) {
            if (element instanceof ProcessTreeItem) {
                return ((ProcessTreeItem)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ProcessTreeItem) {
                ProcessTreeItem pti = (ProcessTreeItem)element;
                return pti.getData() == null || pti.getData() instanceof Process;
            }
            if (element instanceof ProfilingAgentList) {
                return ((ProfilingAgentList)element).getAgentCount() > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (viewer instanceof AbstractTreeViewer) {
                this.tManager = new DeferredTreeContentManager((ITreeContentProvider)this, (AbstractTreeViewer)viewer);
            }
        }

        public Object[] fetchChildren(Object parent) {
            IWorkbenchWindow context = UIPlugin.getActiveWorkbenchWindow();
            ProcessWrapperRunnable runnable = new ProcessWrapperRunnable(parent, this._conf);
            try {
                context.run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return EMPTY_ARRAY;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return EMPTY_ARRAY;
            }
            return runnable.getChildren();
        }

        public void updateTrees() {
            WorkbenchJob clearJob = new WorkbenchJob(this, "CTree.updateTrees"){
                final /* synthetic */ CTreeContentProvider this$1;
                {
                    this.this$1 = cTreeContentProvider;
                }

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    CTree.access$3(CTreeContentProvider.access$0(this.this$1)).handleEvent(null);
                    return Status.OK_STATUS;
                }
            };
            clearJob.setSystem(true);
            clearJob.schedule();
        }

        static /* synthetic */ CTree access$0(CTreeContentProvider cTreeContentProvider) {
            return cTreeContentProvider.CTree.this;
        }
    }

    public class CTreeLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof ProcessTreeItem) {
                return ((ProcessTreeItem)element).getLabelText();
            }
            if (this.isPendingUpdate(element)) {
                return TraceMessages.PENDI;
            }
            return "";
        }

        private boolean isPendingUpdate(Object element) {
            return element instanceof IWorkbenchAdapter;
        }

        public Image getImage(Object element) {
            if (element instanceof ProcessTreeItem) {
                return ((ProcessTreeItem)element).getImage();
            }
            return super.getImage(element);
        }
    }
}

