/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.hyades.log.ui.internal.LogMessages;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CorrelationUI
implements SelectionListener {
    private IExtension[] extensions;
    private Table correlationNames;
    private Text correlationDescription;
    private Text logTypesArea;
    private IConfigurationElement correlation;
    private String sHelpContext;
    private List listeners = new Vector();

    public CorrelationUI(IExtension[] ext, String helpContext) {
        this.extensions = ext;
        this.sHelpContext = helpContext;
    }

    public Control createControl(Composite parent) {
        int indent = 3;
        Composite mainGroup = new Composite(parent, 16);
        GridData data = GridUtil.createFill();
        data.widthHint = 370;
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        mainGroup.setLayout((Layout)layout);
        mainGroup.setLayoutData((Object)data);
        Label dialogLabel = new Label(mainGroup, 0);
        dialogLabel.setText(TraceMessages.CHCOR);
        Composite schemaGroup = new Composite(mainGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        schemaGroup.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.horizontalIndent = indent;
        schemaGroup.setLayoutData((Object)gd);
        Label namesLabel = new Label(schemaGroup, 0);
        namesLabel.setText(TraceMessages.COR_SCH);
        gd = new GridData(1808);
        this.correlationNames = new Table(schemaGroup, 2836);
        this.correlationNames.setLayoutData((Object)gd);
        this.correlationNames.addSelectionListener((SelectionListener)this);
        Label logTypesLabel = new Label(schemaGroup, 0);
        logTypesLabel.setText(TraceMessages.LG_TP);
        gd = new GridData(1808);
        this.logTypesArea = new Text(schemaGroup, 2842);
        this.logTypesArea.setLayoutData((Object)gd);
        Composite describtionGroup = new Composite(mainGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 5;
        describtionGroup.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalIndent = indent;
        describtionGroup.setLayoutData((Object)gd);
        Label descriptionLabel = new Label(describtionGroup, 0);
        descriptionLabel.setText(TraceMessages.CORD);
        descriptionLabel.setLayoutData((Object)new GridData(34));
        this.correlationDescription = new Text(describtionGroup, 74);
        GridData d = GridUtil.createHorizontalFill();
        this.correlationDescription.setLayoutData((Object)d);
        this.initializeCorrelations();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainGroup, this.sHelpContext);
        return mainGroup;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.correlationNames) {
            this.selectCorrelation(this.correlationNames.getSelectionIndex());
        }
        this.setCorrelation(this.getSelectedCorrelation());
        this.notifyListeners(e);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public IConfigurationElement getSelectedCorrelation() {
        return (IConfigurationElement)this.correlationNames.getItem(this.correlationNames.getSelectionIndex()).getData();
    }

    private void initializeCorrelations() {
        TreeMap<String, IConfigurationElement> map = new TreeMap<String, IConfigurationElement>();
        int i = 0;
        while (i < this.extensions.length) {
            IConfigurationElement[] elements = this.extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement elem = elements[j];
                if ("view".equals(elem.getName())) {
                    map.put(elem.getAttribute("name"), elem);
                }
                ++j;
            }
            ++i;
        }
        Iterator i2 = map.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry e = i2.next();
            TableItem item = new TableItem(this.correlationNames, 0);
            item.setText(e.getKey().toString());
            item.setData(e.getValue());
        }
        int setIndex = map.size() - map.tailMap(LogMessages.COR_NM).size();
        this.correlationNames.setSelection(setIndex);
        this.selectCorrelation(setIndex);
        this.setCorrelation(this.getSelectedCorrelation());
    }

    public void selectCorrelation(int index) {
        String logtypes = "";
        if (index < 0 || index >= this.correlationNames.getItemCount()) {
            return;
        }
        this.logTypesArea.setText("");
        IConfigurationElement elem = (IConfigurationElement)this.correlationNames.getItem(index).getData();
        if (elem != null) {
            StringTokenizer tokenizer = new StringTokenizer(elem.getAttribute("log_types"), ",", false);
            this.logTypesArea.setText("");
            logtypes = "";
            while (tokenizer.hasMoreTokens()) {
                logtypes = String.valueOf(logtypes) + tokenizer.nextToken() + "\n";
            }
            this.logTypesArea.setText(logtypes);
        }
        this.correlationDescription.setText(elem.getAttribute("description"));
    }

    public IConfigurationElement getCorrelation() {
        return this.correlation;
    }

    public Text getCorrelationDescription() {
        return this.correlationDescription;
    }

    public Table getCorrelationNames() {
        return this.correlationNames;
    }

    public void setCorrelation(IConfigurationElement element) {
        this.correlation = element;
    }

    public void addSelectionListnener(SelectionListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    protected void notifyListeners(SelectionEvent e) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            SelectionListener element = (SelectionListener)iter.next();
            element.widgetSelected(e);
        }
    }
}

