/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class FilterElementModifier
implements ICellModifier {
    protected CheckboxTableViewer fViewer;

    public FilterElementModifier(CheckboxTableViewer viewer) {
        this.fViewer = viewer;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        if (property.equals("string")) {
            return ((FilterTableElement)element).getText();
        }
        if (property.equals("method")) {
            return ((FilterTableElement)element).getMethod();
        }
        if (property.equals("combo")) {
            return new Integer(((FilterTableElement)element).getVisibilityState());
        }
        return element;
    }

    public void modify(Object element, String property, Object value) {
        try {
            Object data;
            if (element instanceof TableItem && (data = ((TableItem)element).getData()) != null && data instanceof FilterTableElement) {
                FilterTableElement e = (FilterTableElement)data;
                if ("string".equals(property)) {
                    if (value != null && !e.getText().equals(value.toString().trim())) {
                        e.setText(value.toString().trim());
                    }
                } else if ("method".equals(property)) {
                    if (value != null && !e.getMethod().equals(value.toString().trim())) {
                        e.setMethod(value.toString().trim());
                    }
                } else if ("combo".equals(property) && value != null && Integer.parseInt(value.toString()) != e.getVisibilityState()) {
                    e.setVisibility(Integer.parseInt(value.toString()));
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

