/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class HyperlinkText
extends StyledText {
    private ArrayList detailsHyperlinkRanges = new ArrayList();
    private ArrayList actionRanges = new ArrayList();
    private IPropertyChangeListener colorListener;
    private String linkStart1 = "http://";
    private String linkStart2 = "https://";
    int[][] detailsRanges;
    private Cursor handCursor;
    private Cursor busyCursor;
    private boolean mouseDown = false;
    private boolean dragEvent = false;

    public HyperlinkText(Composite parent, int style) {
        super(parent, style);
        final Display display = parent.getDisplay();
        this.handCursor = new Cursor((Device)display, 21);
        this.busyCursor = new Cursor((Device)display, 1);
        this.colorListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("HYPERLINK_COLOR")) {
                    Color fg = JFaceColors.getHyperlinkText((Display)display);
                    Iterator links = HyperlinkText.this.detailsHyperlinkRanges.iterator();
                    while (links.hasNext()) {
                        StyleRange range = (StyleRange)links.next();
                        range.foreground = fg;
                    }
                }
            }
        };
        Color background = JFaceColors.getBannerBackground((Display)display);
        Color foreground = JFaceColors.getBannerForeground((Display)display);
        JFaceColors.setColors((Control)this, (Color)foreground, (Color)background);
        this.addListeners();
    }

    protected void addListeners() {
        if (!SWT.getPlatform().equals("win32")) {
            return;
        }
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                HyperlinkText.this.mouseDown = true;
            }

            public void mouseUp(MouseEvent e) {
                HyperlinkText.this.mouseDown = false;
                StyledText text = (StyledText)e.widget;
                int offset = text.getCaretOffset();
                if (HyperlinkText.this.dragEvent) {
                    HyperlinkText.this.dragEvent = false;
                    if (HyperlinkText.this.isLinkAt(offset)) {
                        text.setCursor(HyperlinkText.this.handCursor);
                    }
                } else if (HyperlinkText.this.isLinkAt(offset)) {
                    text.setCursor(HyperlinkText.this.busyCursor);
                    if (e.button == 1) {
                        HyperlinkText.this.triggerLinkAt(offset);
                        StyleRange selectionRange = HyperlinkText.this.getCurrentLink();
                        text.setSelectionRange(selectionRange.start, selectionRange.length);
                        text.setCursor(null);
                    }
                }
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (HyperlinkText.this.mouseDown) {
                    if (!HyperlinkText.this.dragEvent) {
                        StyledText text = (StyledText)e.widget;
                        text.setCursor(null);
                    }
                    HyperlinkText.this.dragEvent = true;
                    return;
                }
                StyledText text = (StyledText)e.widget;
                int offset = -1;
                try {
                    offset = text.getOffsetAtLocation(new Point(e.x, e.y));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (offset == -1) {
                    text.setCursor(null);
                } else if (HyperlinkText.this.isLinkAt(offset)) {
                    text.setCursor(HyperlinkText.this.handCursor);
                } else {
                    text.setCursor(null);
                }
            }
        });
    }

    private boolean isLinkAt(int offset) {
        if (this.detailsRanges == null) {
            return false;
        }
        int i = 0;
        while (i < this.detailsRanges.length) {
            if (offset >= this.detailsRanges[i][0] && offset < this.detailsRanges[i][0] + this.detailsRanges[i][1]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void openBrowser(String url) {
        if (url == null || "".equals(url)) {
            return;
        }
        if (SWT.getPlatform().equals("win32")) {
            Program.launch((String)url);
        }
    }

    protected StyleRange getCurrentLink() {
        StyleRange[] ranges = this.getStyleRanges();
        int currentSelectionEnd = this.getSelection().y;
        int currentSelectionStart = this.getSelection().x;
        int i = 0;
        while (i < ranges.length) {
            if (currentSelectionStart >= ranges[i].start && currentSelectionEnd <= ranges[i].start + ranges[i].length) {
                return ranges[i];
            }
            ++i;
        }
        return null;
    }

    protected void triggerLinkAt(int offset) {
        if (this.detailsRanges == null) {
            return;
        }
        int i = 0;
        while (i < this.detailsRanges.length) {
            if (offset >= this.detailsRanges[i][0] && offset < this.detailsRanges[i][0] + this.detailsRanges[i][1]) {
                this.openBrowser(this.getText().substring(this.detailsRanges[i][0], this.detailsRanges[i][0] + this.detailsRanges[i][1]));
                return;
            }
            ++i;
        }
    }

    public void dispose() {
        if (this.busyCursor != null) {
            this.busyCursor.dispose();
        }
        if (this.handCursor != null) {
            this.handCursor.dispose();
        }
        if (this.colorListener != null && JFacePreferences.getPreferenceStore() != null) {
            JFacePreferences.getPreferenceStore().removePropertyChangeListener(this.colorListener);
        }
        this.colorListener = null;
    }

    private void setLinkRanges(String text) {
        this.actionRanges.clear();
        this.detailsHyperlinkRanges.clear();
        if (text == null || text.length() == 0) {
            return;
        }
        this.findLinks(text, this.linkStart1);
        this.findLinks(text, this.linkStart2);
        Color fg = JFaceColors.getHyperlinkText((Display)this.getShell().getDisplay());
        this.detailsRanges = (int[][])this.actionRanges.toArray((T[])new int[this.actionRanges.size()][2]);
        int i = 0;
        while (i < this.detailsRanges.length) {
            StyleRange r = new StyleRange(this.detailsRanges[i][0], this.detailsRanges[i][1], fg, null, 0);
            this.setStyleRange(r);
            this.detailsHyperlinkRanges.add(r);
            ++i;
        }
    }

    protected void findLinks(String text, String linkStart) {
        int idx = text.indexOf(linkStart);
        int offset = 0;
        while (idx != -1) {
            String tmpText = text.substring(offset + idx);
            int tmpIdx = tmpText.indexOf(" ");
            if (tmpIdx == -1) {
                tmpIdx = tmpText.indexOf("\n");
            }
            if (tmpIdx == -1) {
                this.actionRanges.add(new int[]{idx + offset, tmpText.length() - idx});
                text = "";
            } else {
                this.actionRanges.add(new int[]{idx + offset, tmpIdx});
                tmpText = tmpText.substring(tmpIdx + 1);
                offset += tmpIdx + 1;
            }
            offset += idx;
            idx = tmpText.indexOf(linkStart);
        }
    }

    public void setText(String text) {
        super.setText(text);
        this.setLinkRanges(text);
    }
}

