/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.trace.ui.internal.util.IOProxy;

public class ProcessAdapter
implements IProcess {
    private Map _attributes = new HashMap();
    private boolean _isAlive = false;
    private String _label = null;
    private Process _process;
    private IOProxy _proxy;
    private ILaunch _launch;
    protected int launchMode = 1;
    static /* synthetic */ Class class$0;

    public ProcessAdapter(Process process, ILaunch launch, boolean isAlive, int pLaunchMode) {
        this(process, launch, isAlive);
        this.launchMode = pLaunchMode;
    }

    public ProcessAdapter(Process process, ILaunch launch) {
        DateFormat format = DateFormat.getDateTimeInstance((int)1, (int)2, (Locale)Locale.getDefault());
        this._label = String.valueOf(process.getExecutable()) + " (" + format.format(new Date(System.currentTimeMillis())) + ")";
        this._process = process;
        this._launch = launch;
        this._process.addProcessListener(new ProcessListener(){

            public void processLaunched(Process p) {
                ProcessAdapter.this._isAlive = true;
            }

            public void processExited(Process p) {
                ProcessAdapter.this._isAlive = false;
            }
        });
    }

    public ProcessAdapter(Process process, ILaunch launch, boolean isAlive) {
        this(process, launch);
        this._isAlive = isAlive;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.local.common.DataProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this._proxy;
        }
        return null;
    }

    public String getAttribute(String key) {
        return (String)this._attributes.get(key);
    }

    public void setAttribute(String key, String value) {
        this._attributes.put(key, value);
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    public String getLabel() {
        return this._label;
    }

    public ILaunch getLaunch() {
        return this._launch;
    }

    public IStreamsProxy getStreamsProxy() {
        if (this._proxy == null) {
            this._proxy = new IOProxy(this._process);
        }
        return this._proxy;
    }

    public boolean canTerminate() {
        return this._isAlive && this.getLaunchMode() != 0;
    }

    public boolean isTerminated() {
        return !this._isAlive;
    }

    public void terminate() throws DebugException {
        if (this.canTerminate()) {
            try {
                this._process.kill(0L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this._isAlive = false;
        }
    }

    public int getLaunchMode() {
        return this.launchMode;
    }

    public void setLaunchMode(int launchMode) {
        this.launchMode = launchMode;
    }
}

