/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SaveUtil {
    public static void save(Collection c, IProgressMonitor monitor, String navigatorID) {
        UniqueEList sel = new UniqueEList();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof CorrelationContainerProxy)) continue;
            sel.addAll(((CorrelationContainerProxy)element).getCorrelatedAgents());
        }
        sel.addAll(c);
        Collection items = SaveUtil.findItems((Collection)sel, navigatorID);
        if (monitor != null) {
            monitor.beginTask(UIPlugin.getResourceString(TraceMessages.SAVE), items.size());
        }
        if (SaveUtil.isValid(items)) {
            Iterator i = items.iterator();
            while (i.hasNext()) {
                SaveUtil.saveItem(i.next(), monitor);
                if (monitor != null && monitor.isCanceled()) break;
            }
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    public static void saveItem(Object obj, IProgressMonitor monitor) {
        if (obj instanceof EObject) {
            CorrelationContainerProxy proxy;
            EObject eobj = (EObject)obj;
            if (obj instanceof TRCMonitor) {
                try {
                    org.eclipse.hyades.models.hierarchy.util.SaveUtil.saveResource((IProgressMonitor)monitor, (Resource)eobj.eResource());
                }
                catch (Exception exception) {
                    SaveUtil.handleSaveException(TraceMessages.SMON_TXT, ((TRCMonitor)obj).getName(), eobj);
                }
            } else if (obj instanceof TRCNode) {
                try {
                    org.eclipse.hyades.models.hierarchy.util.SaveUtil.saveResource((IProgressMonitor)monitor, (Resource)eobj.eResource());
                }
                catch (Exception exception) {
                    SaveUtil.handleSaveException(TraceMessages.SNOD_TXT, ((TRCNode)obj).getName(), eobj);
                }
            } else if (obj instanceof TRCProcessProxy) {
                try {
                    org.eclipse.hyades.models.hierarchy.util.SaveUtil.saveResource((IProgressMonitor)monitor, (Resource)eobj.eResource());
                }
                catch (Exception exception) {
                    SaveUtil.handleSaveException(TraceMessages.SPRC_TXT, ((TRCProcessProxy)obj).getName(), eobj);
                }
            } else if (obj instanceof TRCAgentProxy) {
                TRCAgentProxy agent = (TRCAgentProxy)obj;
                if (agent.getAgent() != null) {
                    try {
                        org.eclipse.hyades.models.hierarchy.util.SaveUtil.saveResource((IProgressMonitor)monitor, (Resource)agent.getAgent().eResource());
                    }
                    catch (Exception exception) {
                        SaveUtil.handleSaveException(TraceMessages.SAG_TXT, agent.getName(), (EObject)agent);
                    }
                }
            } else if (obj instanceof CorrelationContainerProxy && (proxy = (CorrelationContainerProxy)obj).getCorrelationContainer() != null) {
                try {
                    if (proxy.getCorrelationContainer().eResource() == null || !proxy.getCorrelationContainer().eResource().getURI().toString().endsWith(".corrdb")) {
                        org.eclipse.hyades.models.hierarchy.util.SaveUtil.saveResource((IProgressMonitor)monitor, (Resource)proxy.getCorrelationContainer().eResource());
                    }
                }
                catch (Exception exception) {
                    SaveUtil.handleSaveException(TraceMessages.SCOR_TXT, proxy.getName(), eobj);
                }
            }
        } else if (obj instanceof INavigatorItem) {
            INavigatorItem item;
            if (monitor != null) {
                monitor.setTaskName(((INavigatorItem)obj).getText());
                monitor.worked(1);
            }
            if ((item = (INavigatorItem)obj).isSaveEnabled()) {
                item.save(true);
            }
        }
    }

    private static Collection findItems(Collection selection, String navigatorID) {
        HashSet c = new HashSet();
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            SaveUtil.findItems(i.next(), c, true, true, navigatorID);
        }
        return c;
    }

    private static void findItems(Object obj, Collection c, boolean findAncestors, boolean findDescendants, String navigatorID) {
        if (obj != null && !c.contains(obj)) {
            if (!(obj instanceof IContainer)) {
                c.add(obj);
            }
            if (findAncestors) {
                SaveUtil.findItems(SaveUtil.getParent(obj), c, true, false, navigatorID);
            }
            if (findDescendants) {
                Iterator i = SaveUtil.getChildren(obj, navigatorID).iterator();
                while (i.hasNext()) {
                    SaveUtil.findItems(i.next(), c, false, true, navigatorID);
                }
            }
        }
    }

    private static Object getParent(Object obj) {
        if (obj instanceof TRCNode) {
            return ((TRCNode)obj).getMonitor();
        }
        if (obj instanceof TRCProcessProxy) {
            return ((TRCProcessProxy)obj).getNode();
        }
        if (obj instanceof TRCAgentProxy) {
            return ((TRCAgentProxy)obj).getProcessProxy();
        }
        if (obj instanceof CorrelationContainerProxy) {
            return ((CorrelationContainerProxy)obj).getMonitor();
        }
        if (obj instanceof INavigatorItem) {
            return ((INavigatorItem)obj).getParent();
        }
        return null;
    }

    private static Collection getChildren(Object obj, String navigatorID) {
        HashSet<IResource> c = new HashSet<IResource>();
        if (obj instanceof IContainer) {
            IContainer container = (IContainer)obj;
            try {
                IResource[] members = container.members();
                int i = 0;
                while (i < members.length) {
                    if (members[i] instanceof IContainer) {
                        c.add(members[i]);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            c.addAll(PDContentProvider.getMonitors(container));
        } else if (obj instanceof TRCMonitor) {
            c.addAll((Collection<IResource>)((TRCMonitor)obj).getNodes());
        } else if (obj instanceof TRCNode) {
            c.addAll((Collection<IResource>)((TRCNode)obj).getProcessProxies());
        } else if (obj instanceof TRCProcessProxy) {
            c.addAll((Collection<IResource>)((TRCProcessProxy)obj).getAgentProxies());
        } else if (obj instanceof CorrelationContainerProxy) {
            c.addAll((Collection<IResource>)((CorrelationContainerProxy)obj).getCorrelatedAgents());
        }
        c.addAll(NavigatorExtensionUtil.getAllChildren((Object)obj, (String)navigatorID));
        return c;
    }

    private static boolean isValid(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (SaveUtil.isValid(i.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean isValid(Object obj) {
        if (obj instanceof EObject) {
            CorrelationContainerProxy proxy;
            if (obj instanceof TRCMonitor) {
                TRCMonitor mon = (TRCMonitor)obj;
                if (SaveUtil.isReadOnly(mon.eResource())) {
                    SaveUtil.handleSaveReadOnlyException(mon.getName(), (EObject)mon);
                    return false;
                }
            } else if (obj instanceof TRCNode) {
                TRCNode node = (TRCNode)obj;
                if (!node.eIsProxy() && SaveUtil.isReadOnly(node.eResource())) {
                    SaveUtil.handleSaveReadOnlyException(node.getName(), (EObject)node);
                    return false;
                }
            } else if (obj instanceof TRCProcessProxy) {
                TRCProcessProxy p = (TRCProcessProxy)obj;
                if (!p.eIsProxy() && SaveUtil.isReadOnly(p.eResource())) {
                    SaveUtil.handleSaveReadOnlyException(p.getName(), (EObject)p);
                    return false;
                }
            } else if (obj instanceof TRCAgentProxy) {
                TRCAgentProxy a = (TRCAgentProxy)obj;
                if (!a.eIsProxy()) {
                    if (SaveUtil.isReadOnly(a.getAgent().eResource())) {
                        SaveUtil.handleSaveReadOnlyException(a.getName(), (EObject)a);
                        return false;
                    }
                    if (a.isCollectionData()) {
                        SaveUtil.handleAgentCollectingWhenSave(a);
                        return false;
                    }
                }
            } else if (obj instanceof CorrelationContainerProxy && SaveUtil.isReadOnly((proxy = (CorrelationContainerProxy)obj).getCorrelationContainer().eResource())) {
                SaveUtil.handleSaveReadOnlyException(proxy.getName(), (EObject)proxy);
                return false;
            }
        }
        return true;
    }

    private static boolean isReadOnly(Resource rsc) {
        Path path = new Path(rsc.getURI().toString());
        IResource foundrsc = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        if (foundrsc != null && foundrsc.isAccessible()) {
            return foundrsc.getResourceAttributes().isReadOnly();
        }
        return false;
    }

    private static void handleAgentCollectingWhenSave(TRCAgentProxy a) {
        if (a.getAgent() == null) {
            return;
        }
        final String text = NLS.bind((String)TraceMessages.SAGC_ERROR_, (Object)a.getName());
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = UIPlugin.getActiveWorkbenchShell();
                if (shell != null) {
                    Status err = new Status(2, "org.eclipse.core.resources", 566, text, null);
                    ErrorDialog.openError((Shell)shell, (String)TraceMessages.TRC_MSGT, (String)TraceMessages.SFLT_ERROR_, (IStatus)err);
                }
            }
        });
    }

    private static void handleSaveException(String objectType, String objectName, EObject obj) {
        Resource res = obj.eResource();
        String text = res != null ? NLS.bind((String)TraceMessages.SFL_ERROR_, (Object[])new Object[]{objectType, res.getURI().toString()}) : NLS.bind((String)TraceMessages.SFL_ERROR_, (Object[])new Object[]{objectType, objectName});
        final String finalText = text;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = UIPlugin.getActiveWorkbenchShell();
                if (shell != null) {
                    Status err = new Status(2, "org.eclipse.core.resources", 566, finalText, null);
                    ErrorDialog.openError((Shell)shell, (String)UIPlugin.getResourceString(TraceMessages.TRC_MSGT), (String)UIPlugin.getResourceString(TraceMessages.SFLT_ERROR_), (IStatus)err);
                }
            }
        });
    }

    private static void handleSaveReadOnlyException(String objectName, EObject obj) {
        Resource res = obj.eResource();
        String text = "";
        if (res != null) {
            text = NLS.bind((String)TraceMessages.SROF_ERROR_, (Object[])new Object[]{objectName, res.getURI().toString()});
        }
        if (objectName != null) {
            text = NLS.bind((String)TraceMessages.SROF_ERROR_, (Object[])new Object[]{objectName, objectName});
        }
        final String finalText = text;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = UIPlugin.getActiveWorkbenchShell();
                if (shell != null) {
                    Status err = new Status(2, "org.eclipse.core.resources", 566, finalText, null);
                    ErrorDialog.openError((Shell)shell, (String)UIPlugin.getResourceString(TraceMessages.TRC_MSGT), (String)UIPlugin.getResourceString(TraceMessages.SFLT_ERROR_), (IStatus)err);
                }
            }
        });
    }
}

