/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.trace.impl.TracePackageImpl;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.ui.internal.filters.ModelUtils;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FiltersStandardTabTraceViewsUI
extends FiltersStandardTabUI {
    public static EAttribute ATTRIBUTE_PACKAGE_NAME = TracePackageImpl.init().getTRCPackage_Name();
    public static EAttribute ATTRIBUTE_CLASS_NAME = TracePackageImpl.init().getTRCClass_Name();
    public static EAttribute ATTRIBUTE_METHOD_NAME = TracePackageImpl.init().getTRCMethod_Name();
    public static RelationalOperators OPERATOR_LIKE = RelationalOperators.get((int)6);
    private boolean _showMethodLevel;
    private Text _filterText;
    private Button _packageLevel;
    private Button _classLevel;
    private Button _methodLevel;
    private Button _caseControl;
    private IContextLabelFormatProvider _packageLabelProvider;
    private IContextLabelFormatProvider _classLabelProvider;
    private IContextLabelFormatProvider _methodLabelProvider;

    public FiltersStandardTabTraceViewsUI(boolean showMethodLevel) {
        this._showMethodLevel = showMethodLevel;
    }

    private void updateLabelProvider() {
        String contextKey = UIPlugin.getDefault().getPreferenceStore().getString("trace_import_filter_context");
        this._packageLabelProvider = ContextManager.getContextLabelFormatProvider((String)contextKey, (String)"package.name", (int)3);
        this._classLabelProvider = ContextManager.getContextLabelFormatProvider((String)contextKey, (String)"class.name", (int)3);
        this._methodLabelProvider = ContextManager.getContextLabelFormatProvider((String)contextKey, (String)"method.name", (int)3);
    }

    public Control createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout());
        Composite filterContainer = new Composite(content, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        filterContainer.setLayout((Layout)layout);
        GridData data = GridUtil.createHorizontalFill();
        filterContainer.setLayoutData((Object)data);
        Label filter = new Label(filterContainer, 0);
        filter.setText(TraceMessages.ST_FILTER);
        Composite filterTextContainer = new Composite(filterContainer, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        filterTextContainer.setLayout((Layout)layout);
        data = GridUtil.createHorizontalFill();
        filterTextContainer.setLayoutData((Object)data);
        this._filterText = new Text(filterTextContainer, 2048);
        this._filterText.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent key) {
            }
        });
        this._caseControl = new Button(filterTextContainer, 32);
        this._caseControl.setLayoutData((Object)new GridData());
        this._caseControl.setText(TraceMessages.ST_CSSNT);
        Composite levelContainer = new Composite(filterContainer, 0);
        layout = new GridLayout();
        levelContainer.setLayout((Layout)layout);
        levelContainer.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label filterByLabel = new Label(levelContainer, 0);
        filterByLabel.setText(TraceMessages.ST_FLTBY);
        Composite buttonLevelContainer = new Composite(levelContainer, 0);
        layout = new GridLayout();
        buttonLevelContainer.setLayout((Layout)layout);
        buttonLevelContainer.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.updateLabelProvider();
        this._packageLevel = new Button(buttonLevelContainer, 16);
        this._packageLevel.setText(this._packageLabelProvider.getDisplayStringFromElement((Object)TraceMessages.ST_FPKN, null, 3));
        this._packageLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this._classLevel = new Button(buttonLevelContainer, 16);
        this._classLevel.setText(this._classLabelProvider.getDisplayStringFromElement((Object)TraceMessages.ST_FPCN, null, 3));
        this._classLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this._methodLevel = null;
        if (this._showMethodLevel) {
            this._methodLevel = new Button(buttonLevelContainer, 16);
            this._methodLevel.setText(this._methodLabelProvider.getDisplayStringFromElement((Object)TraceMessages.ST_FPMN, null, 3));
            this._methodLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                }
            });
        }
        this.createSpacer(content);
        return content;
    }

    protected void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }

    public void initializeFrom(SimpleSearchQuery filter) {
        this._filterText.setText("");
        this._caseControl.setSelection(true);
        boolean levelSet = false;
        if (filter.getWhereExpression() != null && filter.getWhereExpression() instanceof LogicalExpression) {
            LogicalExpression logicalExpression = (LogicalExpression)filter.getWhereExpression();
            EList filterElements = logicalExpression.getArguments();
            int i = 0;
            while (i < filterElements.size()) {
                BinaryExpression be = (BinaryExpression)filterElements.get(i);
                EStructuralFeature feature = ((SimpleOperand)be.getLeftOperand()).getFeature();
                if (feature != null) {
                    boolean validFeature = false;
                    String filterText = "";
                    if (feature.equals(ATTRIBUTE_PACKAGE_NAME)) {
                        filterText = this._packageLabelProvider.convertModelValueToDisplayString(String.valueOf(((SimpleOperand)be.getRightOperands().get(0)).getRawValue()));
                        this._packageLevel.setSelection(true);
                        validFeature = true;
                    } else if (feature.equals(ATTRIBUTE_CLASS_NAME)) {
                        filterText = this._classLabelProvider.convertModelValueToDisplayString(String.valueOf(((SimpleOperand)be.getRightOperands().get(0)).getRawValue()));
                        this._classLevel.setSelection(true);
                        validFeature = true;
                    } else if (feature.equals(ATTRIBUTE_METHOD_NAME)) {
                        filterText = this._methodLabelProvider.convertModelValueToDisplayString(String.valueOf(((SimpleOperand)be.getRightOperands().get(0)).getRawValue()));
                        this._methodLevel.setSelection(true);
                        validFeature = true;
                    }
                    if (validFeature) {
                        this._filterText.setText(filterText);
                        this._caseControl.setSelection(!be.isCaseInsensitive());
                        levelSet = true;
                    }
                }
                ++i;
            }
        }
        if (!levelSet) {
            this._packageLevel.setSelection(true);
        }
    }

    public SimpleSearchQuery performApply() {
        SimpleSearchQuery filter = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
        EList arguments = logicalExpression.getArguments();
        if (this._filterText.getText().trim().length() > 0) {
            if (this._packageLevel.getSelection()) {
                arguments.add((Object)ModelUtils.createBinaryExpression((EStructuralFeature)ATTRIBUTE_PACKAGE_NAME, (RelationalOperators)OPERATOR_LIKE, (String)this._packageLabelProvider.convertDisplayStringToModelValue(this._filterText.getText().trim()), (!this._caseControl.getSelection() ? 1 : 0) != 0));
            } else if (this._classLevel.getSelection()) {
                arguments.add((Object)ModelUtils.createBinaryExpression((EStructuralFeature)ATTRIBUTE_CLASS_NAME, (RelationalOperators)OPERATOR_LIKE, (String)this._classLabelProvider.convertDisplayStringToModelValue(this._filterText.getText().trim()), (!this._caseControl.getSelection() ? 1 : 0) != 0));
            } else if (this._methodLevel != null && this._methodLevel.getSelection()) {
                arguments.add((Object)ModelUtils.createBinaryExpression((EStructuralFeature)ATTRIBUTE_METHOD_NAME, (RelationalOperators)OPERATOR_LIKE, (String)this._methodLabelProvider.convertDisplayStringToModelValue(this._filterText.getText().trim()), (!this._caseControl.getSelection() ? 1 : 0) != 0));
            }
        }
        filter.setWhereExpression((WhereExpression)logicalExpression);
        return filter;
    }
}

