/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.hyades.execution.local.CommunicationDebug;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.util.ModelDebugger;
import org.eclipse.hyades.models.hierarchy.util.MonitoredInputStream;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.PDProjectViewer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.internal.wizard.ImportTraceFilterUI;
import org.eclipse.hyades.trace.ui.internal.wizard.ImportTracePage1;
import org.eclipse.hyades.trace.ui.internal.wizard.ImportTraceRangeUI;
import org.eclipse.hyades.trace.ui.internal.wizard.MyBufferedInputStream;
import org.eclipse.hyades.trace.ui.internal.wizard.TraceWizardMessages;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardDataTransferPage;

public class ImportTracePage1
extends WizardDataTransferPage
implements Listener,
ModifyListener,
SelectionListener,
IRunnableWithProgress {
    protected Button sourceBrowseButton;
    protected String fError;
    protected String fInputLog = "";
    protected TRCMonitor fMonitor;
    protected Text sourceNameField;
    protected TraceLocationUI _location;
    protected double fStartPercentage;
    protected double fStopPercentage;
    private Shell shell;
    private long logLength;
    private int collectionMode = 0;
    protected TabFolder details;
    protected TabItem rangeTab;
    protected ImportTraceRangeUI rangeUI;
    protected TabItem filterTab;
    protected ImportTraceFilterUI filterUI;
    private boolean rootElementRequired;

    public ImportTracePage1(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("xmlTraceFileImportPage1");
        this.setTitle(TraceMessages.IMP_XMLPT);
        this.setDescription(TraceMessages.IMP_XMLPD);
        this.setImageDescriptor(PDPluginImages.getImageDescriptor("import_profilefile_wiz.gif"));
        this.shell = aWorkbench.getActiveWorkbenchWindow().getShell();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createSourceGroup(composite);
        this.createSpacer(composite);
        this.createBoldLabel(composite, TraceMessages.IMP_XML_SRC);
        this._location = new TraceLocationUI();
        this._location.createControl(composite);
        this._location.getLocationLabel().setText(TraceMessages.IMP_FLD);
        this.createSpacer(composite);
        this.details = new TabFolder(composite, 0);
        GridData data = GridUtil.createFill();
        this.details.setLayoutData((Object)data);
        this.details.addSelectionListener((SelectionListener)this);
        this.rangeTab = new TabItem(this.details, 0);
        this.rangeTab.setText(TraceMessages.IM_TRRAN);
        this.rangeUI = new ImportTraceRangeUI((WizardPage)this);
        this.rangeTab.setControl((Control)this.rangeUI.createControl((Composite)this.details));
        this.filterTab = new TabItem(this.details, 0);
        this.filterTab.setText(TraceMessages.IM_TRFIL);
        this.filterUI = new ImportTraceFilterUI(this.getFilterScope());
        this.filterTab.setControl((Control)this.filterUI.createControl((Composite)this.details));
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setControl((Control)composite);
        PDProjectExplorer projectExplorer = null;
        PDProjectViewer projectViewer = null;
        IWorkbenchPage page = UIPlugin.getActiveWorkbenchWindow().getActivePage();
        if (page != null && page.getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) {
            projectExplorer = UIPlugin.getDefault().getViewer();
        }
        IProject selectionProject = null;
        TRCMonitor selectionMonitor = null;
        if (projectExplorer != null) {
            projectViewer = (PDProjectViewer)projectExplorer.getViewer();
        }
        if (projectViewer != null) {
            selectionProject = projectViewer.getSelectionProject();
            selectionMonitor = projectViewer.getSelectionMonitor();
        }
        this._location.getLocation().addModifyListener((ModifyListener)this);
        this._location.getMonitor().addModifyListener((ModifyListener)this);
        this.sourceNameField.addModifyListener((ModifyListener)this);
        if (selectionProject != null) {
            this._location.setLocation(selectionProject.getName());
        }
        if (selectionMonitor != null) {
            this._location.setMonitor(selectionMonitor.getName());
        }
        this.rangeUI.getshowHeapStatistic().addSelectionListener((SelectionListener)this);
        this.rangeUI.getshowExecStatistic().addSelectionListener((SelectionListener)this);
        this.rangeUI.getshowExecFlow().addSelectionListener((SelectionListener)this);
        this.rangeUI.getWholeFileBtn().addSelectionListener((SelectionListener)this);
        this.rangeUI.getInRangeBtn().addSelectionListener((SelectionListener)this);
        this.rangeUI.getstartText().addModifyListener((ModifyListener)this);
        this.rangeUI.getstopText().addModifyListener((ModifyListener)this);
    }

    private String getFilterScope() {
        return "ImportTraceScope";
    }

    public boolean finish() {
        this.fInputLog = this.sourceNameField.getText().trim();
        File log = new File(this.sourceNameField.getText().trim());
        if (!log.exists()) {
            this.fError = NLS.bind((String)TraceMessages.ERR_XMLNF, (Object)this.fInputLog);
            Status err1 = new Status(2, "org.eclipse.core.resources", 566, this.fError, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)TraceMessages.TRC_MSGT, (String)TraceMessages.ERR_LXML, (IStatus)err1);
            return false;
        }
        if (!log.canRead()) {
            this.fError = NLS.bind((String)TraceMessages.ERR_XMLRD, (Object)this.fInputLog);
            Status err1 = new Status(2, "org.eclipse.core.resources", 566, this.fError, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)TraceMessages.TRC_MSGT, (String)TraceMessages.ERR_LXML, (IStatus)err1);
            return false;
        }
        this.fError = null;
        if (this.rangeUI.getInRangeSelection()) {
            this.fStartPercentage = this.rangeUI.getStartRange();
            this.fStopPercentage = this.rangeUI.getStopRange();
        } else {
            this.fStartPercentage = 0.0;
            this.fStopPercentage = 100.0;
        }
        return this.loadXMLTrace();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        }
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.determinePageCompletion());
    }

    public void run(IProgressMonitor mon) {
        Display d = Display.getDefault();
        d.syncExec(new Runnable(){

            public void run() {
                if (ImportTracePage1.this.rangeUI.getshowHeapStatistic().getSelection()) {
                    ImportTracePage1.this.collectionMode = 0;
                } else if (ImportTracePage1.this.rangeUI.getshowExecStatistic().getSelection()) {
                    ImportTracePage1.this.collectionMode = 3;
                } else if (ImportTracePage1.this.rangeUI.getshowExecFlow().getSelection()) {
                    ImportTracePage1.this.collectionMode = 2;
                }
            }
        });
        try {
            File log = new File(this.fInputLog);
            if (!PDCoreUtil.isZipFile(this.fInputLog)) {
                BufferedInputStream readStream = new BufferedInputStream(new FileInputStream(log));
                this.logLength = log.length();
                XMLLoader processor = this.getNewProcessor();
                processor.setCollectionMode(this.collectionMode);
                this.importFile(mon, processor, log, readStream, log.getAbsolutePath());
            } else {
                ZipFile zf = new ZipFile(log);
                Enumeration<? extends ZipEntry> entries = zf.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    this.logLength = zipEntry.getSize();
                    if (this.logLength < log.length()) {
                        this.logLength = Long.MAX_VALUE;
                    }
                    XMLLoader processor = this.getNewProcessor();
                    processor.setCollectionMode(this.collectionMode);
                    this.importFile(mon, processor, log, zf.getInputStream(zipEntry), zipEntry.getName());
                    if (!CommunicationDebug.INSTANCE.debugUseEventMode) continue;
                    processor.cleanUp();
                }
            }
        }
        catch (IOException e) {
            this.fError = NLS.bind((String)TraceMessages.IMP_IOEXC, (Object)e.getMessage());
        }
    }

    private XMLLoader getNewProcessor() {
        XMLLoader processor = new XMLLoader(this.fMonitor);
        if (this.filterUI.getSelectedFilter() != null) {
            processor.getContext().setImportFilter(this.filterUI.getSelectedFilter());
            processor.getContext().getFilterEngine().init();
        }
        return processor;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.setPageComplete(this.determinePageCompletion());
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        GridData data = new GridData(256);
        data.widthHint = this.convertHorizontalDLUsToPixels(63);
        button.setLayoutData((Object)data);
        button.setData((Object)new Integer(id));
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        button.setFont(parent.getFont());
        return button;
    }

    protected void createSourceGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        new Label(sourceContainerGroup, 0).setText(TraceMessages.IMP_XML_SR);
        this.sourceNameField = new Text(sourceContainerGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceBrowseButton = new Button(sourceContainerGroup, 8);
        this.sourceBrowseButton.setText(TraceMessages.BROWSE3);
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.sourceNameField.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(UIPlugin.getPluginId()) + ".xmli0000");
    }

    protected boolean determinePageCompletion() {
        boolean complete;
        boolean bl = complete = this.validateSourceGroup() && this.validateDestinationGroup() && this.validateOptionsGroup();
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    protected void handleSourceBrowseButtonPressed() {
        String currentSource = this.sourceNameField.getText();
        FileDialog dlg = new FileDialog(this.sourceNameField.getShell());
        dlg.setFilterPath(currentSource);
        dlg.setFilterExtensions(new String[]{"*.trcxml", "*.*"});
        dlg.open();
        String fileName = dlg.getFileName();
        if (fileName != null && !fileName.equals("")) {
            this.sourceNameField.setText(String.valueOf(dlg.getFilterPath()) + File.separator + fileName);
        }
    }

    protected void updateWidgetEnablements() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
        super.updateWidgetEnablements();
    }

    protected boolean validateOptionsGroup() {
        return !this._location.getLocation().getText().trim().equals("") && !this._location.getMonitor().getText().trim().equals("") && (this.rangeUI.getWholeFileSelection() || this.rangeUI.getInRangeSelection() && this.rangeUI.checkRegionValue() == null);
    }

    protected boolean validateSourceGroup() {
        return !this.sourceNameField.getText().trim().equals("");
    }

    private String createModel(TRCMonitor monitor, String inputLog) {
        this.fMonitor = monitor;
        this.fInputLog = inputLog;
        try {
            this.getWizard().getContainer().run(true, true, (IRunnableWithProgress)this);
        }
        catch (InterruptedException interruptedException) {
            return "";
        }
        catch (InvocationTargetException e) {
            return e.getTargetException().getMessage();
        }
        return this.fError;
    }

    private void handleOutOfMemoryError() {
        String text = TraceMessages.IOUTMEM_ERRT;
        if (this.shell != null) {
            final Status err = new Status(2, "org.eclipse.core.resources", 566, text, null);
            this.shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)ImportTracePage1.this.shell, (String)TraceMessages.TRC_MSGT, (String)TraceMessages.OUTMEM_ERRT, (IStatus)err);
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importFile(IProgressMonitor mon, final XMLLoader processor, File log, InputStream readStream, final String entryName) throws OutOfMemoryError {
        block51: {
            block47: {
                block50: {
                    block43: {
                        block49: {
                            block44: {
                                block40: {
                                    block41: {
                                        try {
                                            if (!CommunicationDebug.INSTANCE.debugUseEventMode) {
                                                final MyBufferedInputStream inputStream = new MyBufferedInputStream(readStream, 16384);
                                                inputStream.mark(100);
                                                byte[] rootElement = new byte[100];
                                                this.rootElementRequired = false;
                                                try {
                                                    int readBytes = inputStream.read(rootElement);
                                                    String root = new String(rootElement, 0, readBytes);
                                                    root = root.toUpperCase();
                                                    this.rootElementRequired = root.indexOf("<TRACE>") == -1 && root.indexOf("<COMMONBASEEVENTS>") == -1;
                                                    inputStream.reset();
                                                }
                                                catch (IOException e1) {
                                                    e1.printStackTrace();
                                                }
                                                if (this.rootElementRequired) {
                                                    inputStream.addRootTRACEElement();
                                                }
                                                final String jobName = MessageFormat.format((String)TraceWizardMessages.IMPORT_FILE, (Object[])new String[]{"" + log.length(), log.getAbsolutePath()});
                                                final long entryLength = this.logLength == Long.MAX_VALUE ? log.length() * 10L : this.logLength;
                                                Job job = new Job(jobName){
                                                    MonitoredInputStream monitoredInputStream = null;
                                                    long prevTotalBytesRead = 0L;
                                                    long totalBytesRead = 0L;
                                                    int prevProcessedFragments = 0;
                                                    long prevTime;
                                                    long unitSize;
                                                    int processedUnits;
                                                    int progress;
                                                    long startTime;
                                                    long deltaTime;
                                                    long partDeltaTime;
                                                    String taskName;
                                                    int collectingState;
                                                    {
                                                        this.unitSize = l / 100L;
                                                        this.processedUnits = 0;
                                                        this.progress = 0;
                                                    }

                                                    protected IStatus run(IProgressMonitor monitor) {
                                                        block8: {
                                                            Timer refresh = new Timer(false);
                                                            refresh.scheduleAtFixedRate(new TimerTask(this, monitor, processor){
                                                                final /* synthetic */ 3 this$1;
                                                                private final /* synthetic */ IProgressMonitor val$monitor;
                                                                private final /* synthetic */ XMLLoader val$processor;
                                                                {
                                                                    this.this$1 = var1_1;
                                                                    this.val$monitor = iProgressMonitor;
                                                                    this.val$processor = xMLLoader;
                                                                }

                                                                public void run() {
                                                                    if (this.this$1.unitSize <= 0L || this.val$monitor.isCanceled()) {
                                                                        if (ModelDebugger.INSTANCE.debug) {
                                                                            LoadersUtils.log((String)"Import refresh thread canceled!");
                                                                        }
                                                                        this.cancel();
                                                                        return;
                                                                    }
                                                                    if (this.val$processor.getContext().getAgentProxy() != null) {
                                                                        this.updateMonitor(this.val$monitor);
                                                                        this.updateCollecting();
                                                                    }
                                                                }

                                                                void updateMonitor(IProgressMonitor monitor) {
                                                                    Display d;
                                                                    this.this$1.deltaTime = System.currentTimeMillis();
                                                                    this.this$1.partDeltaTime = (this.this$1.deltaTime - this.this$1.prevTime) / 1000L;
                                                                    this.this$1.prevTime = this.this$1.deltaTime;
                                                                    this.this$1.deltaTime = (this.this$1.deltaTime - this.this$1.startTime) / 1000L;
                                                                    if (this.this$1.deltaTime == 0L) {
                                                                        this.this$1.deltaTime = 1L;
                                                                    }
                                                                    if (this.this$1.partDeltaTime == 0L) {
                                                                        this.this$1.partDeltaTime = 1L;
                                                                    }
                                                                    int deltaEvents = this.val$processor.getProcessedFragments() - this.this$1.prevProcessedFragments;
                                                                    this.this$1.prevProcessedFragments = this.val$processor.getProcessedFragments();
                                                                    if (this.this$1.unitSize != 0L) {
                                                                        int temp = this.this$1.processedUnits;
                                                                        this.this$1.processedUnits = (int)(this.this$1.totalBytesRead / this.this$1.unitSize);
                                                                        monitor.worked(this.this$1.processedUnits - temp);
                                                                        this.this$1.progress += this.this$1.processedUnits - temp;
                                                                        this.this$1.taskName = MessageFormat.format((String)TraceWizardMessages.IMPORT_PROGRESS, (Object[])new String[]{"" + this.this$1.progress, "" + this.this$1.prevProcessedFragments, "" + (long)deltaEvents / this.this$1.partDeltaTime, "" + this.this$1.deltaTime, "" + this.this$1.totalBytesRead, "" + (this.this$1.totalBytesRead - this.this$1.prevTotalBytesRead) / this.this$1.partDeltaTime});
                                                                        monitor.subTask(this.this$1.taskName);
                                                                    }
                                                                    if ((d = Display.getDefault()) == null || d.isDisposed()) {
                                                                        return;
                                                                    }
                                                                    d.syncExec(new Runnable(this, this.val$processor, deltaEvents){
                                                                        final /* synthetic */ 4 this$2;
                                                                        private final /* synthetic */ XMLLoader val$processor;
                                                                        private final /* synthetic */ int val$deltaEvents;
                                                                        {
                                                                            this.this$2 = var1_1;
                                                                            this.val$processor = xMLLoader;
                                                                            this.val$deltaEvents = n;
                                                                        }

                                                                        public void run() {
                                                                            INavigator navigator = HyadesUtil.getActiveNavigator();
                                                                            if (navigator == null) {
                                                                                return;
                                                                            }
                                                                            if (HyadesUtil.getMofObject() != this.val$processor.getContext().getAgentProxy()) {
                                                                                return;
                                                                            }
                                                                            String statusBarMessage = "";
                                                                            if (4.access$0(this.this$2).unitSize > 0L) {
                                                                                statusBarMessage = MessageFormat.format((String)TraceWizardMessages.IMPORT_PROGRESS, (Object[])new String[]{"" + 4.access$0(this.this$2).progress, "" + 4.access$0(this.this$2).prevProcessedFragments, "" + (long)this.val$deltaEvents / 4.access$0(this.this$2).partDeltaTime, "" + 4.access$0(this.this$2).deltaTime, "" + 4.access$0(this.this$2).totalBytesRead, "" + (4.access$0(this.this$2).totalBytesRead - 4.access$0(this.this$2).prevTotalBytesRead) / 4.access$0(this.this$2).partDeltaTime});
                                                                            }
                                                                            IStatusLineManager statusLineManager = navigator.getViewSite().getActionBars().getStatusLineManager();
                                                                            statusLineManager.setMessage(statusBarMessage);
                                                                            if (ModelDebugger.INSTANCE.debug) {
                                                                                LoadersUtils.log((String)"Import refresh thread - update status bar");
                                                                            }
                                                                        }
                                                                    });
                                                                }

                                                                void updateCollecting() {
                                                                    try {
                                                                        if (this.this$1.prevTotalBytesRead == this.this$1.totalBytesRead) {
                                                                            if (this.this$1.collectingState != 1) {
                                                                                Display d;
                                                                                if (this.val$processor.getContext().getAgentProxy().isCollectionData()) {
                                                                                    this.val$processor.getContext().getAgentProxy().setCollectionData(false);
                                                                                }
                                                                                if ((d = Display.getDefault()) == null || d.isDisposed()) {
                                                                                    return;
                                                                                }
                                                                                d.syncExec(new Runnable(this, this.val$processor){
                                                                                    final /* synthetic */ 4 this$2;
                                                                                    private final /* synthetic */ XMLLoader val$processor;
                                                                                    {
                                                                                        this.this$2 = var1_1;
                                                                                        this.val$processor = xMLLoader;
                                                                                    }

                                                                                    public void run() {
                                                                                        ProfileEvent event;
                                                                                        if (4.access$0(this.this$2).collectingState == 0) {
                                                                                            event = UIPlugin.getDefault().getProfileEvent();
                                                                                            event.setSource(this.val$processor.getContext().getAgentProxy());
                                                                                            event.setType(5120);
                                                                                            UIPlugin.getDefault().notifyProfileEventListener(event);
                                                                                            event = UIPlugin.getDefault().getProfileEvent();
                                                                                            event.setSource(this.val$processor.getContext().getAgentProxy());
                                                                                            event.setType(1);
                                                                                            UIPlugin.getDefault().notifyProfileEventListener(event);
                                                                                        }
                                                                                        event = UIPlugin.getDefault().getProfileEvent();
                                                                                        event.setSource(this.val$processor.getContext().getAgentProxy());
                                                                                        event.setType(1024);
                                                                                        UIPlugin.getDefault().notifyProfileEventListener(event);
                                                                                        if (ModelDebugger.INSTANCE.debug) {
                                                                                            LoadersUtils.log((String)("Import refresh thread - set STOP_COLLECTING " + this.val$processor.getContext().getAgentProxy()));
                                                                                        }
                                                                                    }
                                                                                });
                                                                                this.this$1.collectingState = 1;
                                                                            }
                                                                        } else if (this.this$1.totalBytesRead > this.this$1.prevTotalBytesRead) {
                                                                            if (this.this$1.collectingState != 2) {
                                                                                Display d;
                                                                                if (!this.val$processor.getContext().getAgentProxy().isCollectionData()) {
                                                                                    this.val$processor.getContext().getAgentProxy().setCollectionData(true);
                                                                                }
                                                                                if ((d = Display.getDefault()) == null || d.isDisposed()) {
                                                                                    return;
                                                                                }
                                                                                d.syncExec(new Runnable(this, this.val$processor){
                                                                                    final /* synthetic */ 4 this$2;
                                                                                    private final /* synthetic */ XMLLoader val$processor;
                                                                                    {
                                                                                        this.this$2 = var1_1;
                                                                                        this.val$processor = xMLLoader;
                                                                                    }

                                                                                    public void run() {
                                                                                        ProfileEvent event;
                                                                                        if (4.access$0(this.this$2).collectingState == 0) {
                                                                                            event = UIPlugin.getDefault().getProfileEvent();
                                                                                            event.setSource(null);
                                                                                            event.setType(5120);
                                                                                            UIPlugin.getDefault().notifyProfileEventListener(event);
                                                                                            event = UIPlugin.getDefault().getProfileEvent();
                                                                                            event.setSource(this.val$processor.getContext().getAgentProxy());
                                                                                            event.setType(1);
                                                                                            UIPlugin.getDefault().notifyProfileEventListener(event);
                                                                                        }
                                                                                        event = UIPlugin.getDefault().getProfileEvent();
                                                                                        event.setSource(this.val$processor.getContext().getAgentProxy());
                                                                                        event.setType(512);
                                                                                        UIPlugin.getDefault().notifyProfileEventListener(event);
                                                                                        if (ModelDebugger.INSTANCE.debug) {
                                                                                            LoadersUtils.log((String)("Import refresh thread - set COLLECTING " + this.val$processor.getContext().getAgentProxy()));
                                                                                        }
                                                                                    }
                                                                                });
                                                                                this.this$1.collectingState = 2;
                                                                            }
                                                                            this.this$1.prevTotalBytesRead = this.this$1.totalBytesRead;
                                                                        }
                                                                    }
                                                                    catch (RuntimeException e) {
                                                                        e.printStackTrace();
                                                                    }
                                                                }

                                                                public boolean cancel() {
                                                                    this.this$1.notifyStopCollecting();
                                                                    Display d = Display.getDefault();
                                                                    if (d != null && !d.isDisposed()) {
                                                                        d.syncExec(new Runnable(this, this.val$processor){
                                                                            final /* synthetic */ 4 this$2;
                                                                            private final /* synthetic */ XMLLoader val$processor;
                                                                            {
                                                                                this.this$2 = var1_1;
                                                                                this.val$processor = xMLLoader;
                                                                            }

                                                                            public void run() {
                                                                                INavigator navigator = HyadesUtil.getActiveNavigator();
                                                                                if (navigator == null) {
                                                                                    return;
                                                                                }
                                                                                if (HyadesUtil.getMofObject() != this.val$processor.getContext().getAgentProxy()) {
                                                                                    return;
                                                                                }
                                                                                String statusBarMessage = "";
                                                                                IStatusLineManager statusLineManager = navigator.getViewSite().getActionBars().getStatusLineManager();
                                                                                statusLineManager.setMessage(statusBarMessage);
                                                                            }
                                                                        });
                                                                    }
                                                                    return super.cancel();
                                                                }

                                                                static /* synthetic */ 3 access$0(4 var0) {
                                                                    return var0.this$1;
                                                                }
                                                            }, 0L, 1000L);
                                                            if (ImportTracePage1.this.fStartPercentage == 0.0 && ImportTracePage1.this.fStopPercentage == 100.0) {
                                                                this.monitoredInputStream = new MonitoredInputStream(this, inputStream, monitor){
                                                                    final /* synthetic */ 3 this$1;
                                                                    private final /* synthetic */ IProgressMonitor val$monitor;
                                                                    {
                                                                        this.this$1 = var1_1;
                                                                        this.val$monitor = iProgressMonitor;
                                                                    }

                                                                    protected int afterRead(int readBytes) {
                                                                        this.this$1.totalBytesRead += (long)readBytes;
                                                                        return readBytes;
                                                                    }

                                                                    protected boolean isCanceled() {
                                                                        if (this.val$monitor.isCanceled()) {
                                                                            this.this$1.unitSize = 0L;
                                                                            this.this$1.notifyStopCollecting();
                                                                            return true;
                                                                        }
                                                                        return false;
                                                                    }

                                                                    public void close() throws IOException {
                                                                        super.close();
                                                                        this.this$1.unitSize = -1L;
                                                                    }
                                                                };
                                                            } else {
                                                                long startPos = (long)((double)entryLength * (ImportTracePage1.this.fStartPercentage / 100.0));
                                                                long endPos = (long)((double)entryLength * (ImportTracePage1.this.fStopPercentage / 100.0));
                                                                if (startPos > 0L) {
                                                                    processor.getContext().setLoadToModel(false);
                                                                }
                                                                this.monitoredInputStream = new MonitoredInputStream(this, inputStream, startPos, processor, endPos, monitor){
                                                                    int state;
                                                                    final /* synthetic */ 3 this$1;
                                                                    private final /* synthetic */ long val$startPos;
                                                                    private final /* synthetic */ XMLLoader val$processor;
                                                                    private final /* synthetic */ long val$endPos;
                                                                    private final /* synthetic */ IProgressMonitor val$monitor;
                                                                    {
                                                                        this.this$1 = var1_1;
                                                                        this.val$startPos = l;
                                                                        this.val$processor = xMLLoader;
                                                                        this.val$endPos = l2;
                                                                        this.val$monitor = iProgressMonitor;
                                                                        this.state = 0;
                                                                    }

                                                                    protected int afterRead(int readBytes) {
                                                                        if (this.state == 2) {
                                                                            return -1;
                                                                        }
                                                                        this.this$1.totalBytesRead += (long)readBytes;
                                                                        return readBytes;
                                                                    }

                                                                    protected int beforeRead(int maxBytesToRead) {
                                                                        if (this.state == 2) {
                                                                            return 0;
                                                                        }
                                                                        switch (this.state) {
                                                                            case 0: {
                                                                                if (this.this$1.totalBytesRead == this.val$startPos) {
                                                                                    this.val$processor.getContext().setLoadToModel(true);
                                                                                    ++this.state;
                                                                                    break;
                                                                                }
                                                                                if (this.this$1.totalBytesRead + (long)maxBytesToRead <= this.val$startPos) break;
                                                                                maxBytesToRead = (int)(this.val$startPos - this.this$1.totalBytesRead);
                                                                                break;
                                                                            }
                                                                            case 1: {
                                                                                if (this.this$1.totalBytesRead == this.val$endPos) {
                                                                                    this.val$processor.getContext().setLoadToModel(false);
                                                                                    this.this$1.unitSize = -1L;
                                                                                    maxBytesToRead = 0;
                                                                                    ++this.state;
                                                                                    break;
                                                                                }
                                                                                if (this.this$1.totalBytesRead + (long)maxBytesToRead <= this.val$endPos) break;
                                                                                maxBytesToRead = (int)(this.val$endPos - this.this$1.totalBytesRead);
                                                                                break;
                                                                            }
                                                                        }
                                                                        return maxBytesToRead;
                                                                    }

                                                                    protected boolean isCanceled() {
                                                                        if (this.val$monitor.isCanceled()) {
                                                                            this.this$1.unitSize = 0L;
                                                                            this.this$1.notifyStopCollecting();
                                                                            return true;
                                                                        }
                                                                        return false;
                                                                    }

                                                                    public void close() throws IOException {
                                                                        super.close();
                                                                        this.this$1.unitSize = -1L;
                                                                    }
                                                                };
                                                            }
                                                            this.prevTime = this.startTime = System.currentTimeMillis();
                                                            this.taskName = String.valueOf(entryName) + " " + MessageFormat.format((String)TraceWizardMessages.IMPORT_ENTRY, (Object[])new String[]{"" + entryLength});
                                                            monitor.beginTask(this.taskName, 100);
                                                            this.taskName = MessageFormat.format((String)TraceWizardMessages.IMPORT_PROGRESS, (Object[])new String[]{"0", "0", "0", "0", "0", "0"});
                                                            monitor.subTask(this.taskName);
                                                            try {
                                                                processor.loadEvents((InputStream)this.monitoredInputStream, 0L, -1L);
                                                            }
                                                            catch (Exception e) {
                                                                this.notifyStopCollecting();
                                                                if (monitor.isCanceled() || this.unitSize == -1L) break block8;
                                                                this.unitSize = -1L;
                                                                long deltaTime = (System.currentTimeMillis() - this.startTime) / 1000L;
                                                                if (deltaTime == 0L) {
                                                                    deltaTime = 1L;
                                                                }
                                                                this.progress = (int)(this.totalBytesRead * 100L / entryLength);
                                                                this.taskName = String.valueOf(entryName) + " " + MessageFormat.format((String)TraceWizardMessages.IMPORT_ENTRY, (Object[])new String[]{"" + entryLength});
                                                                this.taskName = String.valueOf(this.taskName) + " " + MessageFormat.format((String)TraceWizardMessages.IMPORT_PROGRESS, (Object[])new String[]{"" + this.progress, "" + processor.getProcessedFragments(), "" + (long)processor.getProcessedFragments() / deltaTime, "" + deltaTime, "" + this.totalBytesRead, "" + this.totalBytesRead / deltaTime});
                                                                processor.cleanUp();
                                                                return new Status(4, UIPlugin.getDefault().getName(), 4, "[" + TraceWizardMessages.IMPORT_ERROR + "] " + jobName + " - " + this.taskName, (Throwable)e);
                                                            }
                                                        }
                                                        monitor.done();
                                                        long deltaTime = (System.currentTimeMillis() - this.startTime) / 1000L;
                                                        if (deltaTime == 0L) {
                                                            deltaTime = 1L;
                                                        }
                                                        this.progress = (int)(this.totalBytesRead * 100L / entryLength);
                                                        this.taskName = String.valueOf(entryName) + " " + MessageFormat.format((String)TraceWizardMessages.IMPORT_ENTRY, (Object[])new String[]{"" + entryLength});
                                                        this.taskName = String.valueOf(this.taskName) + " " + MessageFormat.format((String)TraceWizardMessages.IMPORT_PROGRESS, (Object[])new String[]{"" + this.progress, "" + processor.getProcessedFragments(), "" + (long)processor.getProcessedFragments() / deltaTime, "" + deltaTime, "" + this.totalBytesRead, "" + this.totalBytesRead / deltaTime});
                                                        if (this.unitSize == 0L) {
                                                            this.unitSize = -1L;
                                                            Status s = new Status(8, UIPlugin.getDefault().getName(), 8, "[" + TraceWizardMessages.IMPORT_CANCELED + "] " + jobName + " - " + this.taskName, null);
                                                            UIPlugin.getDefault().log((IStatus)s);
                                                            this.notifyStopCollecting();
                                                            processor.cleanUp();
                                                            return s;
                                                        }
                                                        this.unitSize = -1L;
                                                        Status s = new Status(0, UIPlugin.getDefault().getName(), 0, "[" + TraceWizardMessages.IMPORT_DONE + "] " + jobName + " - " + this.taskName, null);
                                                        UIPlugin.getDefault().log((IStatus)s);
                                                        this.notifyStopCollecting();
                                                        processor.cleanUp();
                                                        return s;
                                                    }

                                                    protected void notifyStopCollecting() {
                                                        Display d = Display.getDefault();
                                                        if (d != null && !d.isDisposed()) {
                                                            d.syncExec(new Runnable(this, processor){
                                                                final /* synthetic */ 3 this$1;
                                                                private final /* synthetic */ XMLLoader val$processor;
                                                                {
                                                                    this.this$1 = var1_1;
                                                                    this.val$processor = xMLLoader;
                                                                }

                                                                public void run() {
                                                                    if (this.val$processor.getContext().getAgentProxy() != null && this.val$processor.getContext().getAgentProxy().isCollectionData()) {
                                                                        this.val$processor.getContext().getAgentProxy().setCollectionData(false);
                                                                    }
                                                                    ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                                                                    if (this.this$1.unitSize == -1L) {
                                                                        event.setSource(null);
                                                                        event.setType(5120);
                                                                        UIPlugin.getDefault().notifyProfileEventListener(event);
                                                                        if (this.this$1.collectingState == 0) {
                                                                            event = UIPlugin.getDefault().getProfileEvent();
                                                                            event.setSource(this.val$processor.getContext().getAgentProxy());
                                                                            event.setType(1);
                                                                            UIPlugin.getDefault().notifyProfileEventListener(event);
                                                                        }
                                                                        event = UIPlugin.getDefault().getProfileEvent();
                                                                    }
                                                                    event.setSource(this.val$processor.getContext().getAgentProxy());
                                                                    event.setType(1024);
                                                                    UIPlugin.getDefault().notifyProfileEventListener(event);
                                                                    if (ModelDebugger.INSTANCE.debug) {
                                                                        LoadersUtils.log((String)("Import refresh thread - set STOP_COLLECTING " + this.val$processor.getContext().getAgentProxy()));
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    }
                                                };
                                                mon.done();
                                                job.schedule();
                                                Object var23_21 = null;
                                                if (!CommunicationDebug.INSTANCE.debugUseEventMode || readStream == null) break block40;
                                                break block41;
                                            }
                                            boolean cancelOperation = false;
                                            int l = 1;
                                            int lastValidLine = 1;
                                            try {
                                                int bSize;
                                                int bufferSize = bSize = 65536;
                                                byte[] buffer = new byte[bufferSize];
                                                byte[] forwardBuffer = new byte[bufferSize];
                                                long position = 0L;
                                                int bytesRead = 0;
                                                double startLength = this.logLength / 100L;
                                                startLength *= this.fStartPercentage;
                                                double endLength = this.logLength;
                                                if (this.fStopPercentage != 100.0) {
                                                    endLength /= 100.0;
                                                    endLength *= this.fStopPercentage;
                                                }
                                                mon.beginTask(this.fInputLog, (int)(endLength - startLength));
                                                int forwardOffset = 0;
                                                int offset = 0;
                                                block27: while (true) {
                                                    if (bytesRead <= -1) {
                                                        if (lastValidLine == l) break;
                                                        readStream.close();
                                                        this.fError = NLS.bind((String)TraceMessages.EOFR_ERR, (Object[])new Object[]{this.fInputLog, String.valueOf(lastValidLine)});
                                                        break block43;
                                                    }
                                                    if (mon.isCanceled()) {
                                                        readStream.close();
                                                        cancelOperation = true;
                                                        throw new OperationCanceledException();
                                                    }
                                                    offset = 0;
                                                    bytesRead = readStream.read(buffer);
                                                    while (true) {
                                                        if (offset >= bytesRead) {
                                                            this.fError = null;
                                                            continue block27;
                                                        }
                                                        forwardBuffer[forwardOffset++] = buffer[offset];
                                                        if (forwardOffset == bufferSize) {
                                                            byte[] tempForwardBuffer = forwardBuffer;
                                                            forwardBuffer = new byte[bufferSize += bSize];
                                                            System.arraycopy(tempForwardBuffer, 0, forwardBuffer, 0, forwardOffset);
                                                            continue;
                                                        }
                                                        if (buffer[offset++] != 10) continue;
                                                        ++l;
                                                        if (forwardBuffer[1] != 63) {
                                                            try {
                                                                position += (long)forwardOffset;
                                                                if ((double)position > endLength && endLength != (double)log.length()) {
                                                                    byte[] end = new String("</TRACE>").getBytes();
                                                                    processor.loadEvent(end, 8, true);
                                                                    mon.done();
                                                                    readStream.close();
                                                                    break block44;
                                                                }
                                                                boolean loadToModel = this.loadLine(l, position, startLength, endLength);
                                                                processor.loadEvent(forwardBuffer, forwardOffset, loadToModel);
                                                            }
                                                            catch (InvalidXMLException e) {
                                                                this.fError = NLS.bind((String)TraceMessages.INVXML_ER, (Object)e.getEnclosedException().getMessage());
                                                                mon.done();
                                                                readStream.close();
                                                                Object var23_23 = null;
                                                                if (CommunicationDebug.INSTANCE.debugUseEventMode && readStream != null) {
                                                                    try {
                                                                        processor.cleanUp();
                                                                    }
                                                                    catch (Exception exception) {}
                                                                    try {
                                                                        readStream.close();
                                                                        readStream = null;
                                                                    }
                                                                    catch (IOException iOException) {}
                                                                }
                                                                mon.done();
                                                                return;
                                                            }
                                                            catch (OutOfMemoryError me) {
                                                                readStream.close();
                                                                this.handleOutOfMemoryError();
                                                                throw me;
                                                            }
                                                        }
                                                        lastValidLine = l;
                                                        mon.worked(forwardOffset);
                                                        forwardOffset = 0;
                                                    }
                                                    break;
                                                }
                                            }
                                            catch (IOException e) {
                                                this.fError = NLS.bind((String)TraceMessages.IMP_IOEXC, (Object)e.getMessage());
                                            }
                                            catch (Exception e) {
                                                this.fError = cancelOperation ? "" : TraceMessages.IMP_EXCERR;
                                                this.fError = NLS.bind((String)this.fError, (Object[])new Object[]{this.fInputLog, String.valueOf(lastValidLine), e.getMessage()});
                                            }
                                            if (readStream != null) {
                                                try {
                                                    readStream.close();
                                                    readStream = null;
                                                }
                                                catch (IOException iOException) {}
                                            }
                                            mon.done();
                                            break block47;
                                        }
                                        catch (Throwable throwable) {
                                            block48: {
                                                Object var23_25 = null;
                                                if (!CommunicationDebug.INSTANCE.debugUseEventMode || readStream == null) break block48;
                                                try {}
                                                catch (Exception exception) {}
                                                processor.cleanUp();
                                                try {}
                                                catch (IOException iOException) {}
                                                readStream.close();
                                                readStream = null;
                                            }
                                            mon.done();
                                            throw throwable;
                                        }
                                    }
                                    try {}
                                    catch (Exception exception) {}
                                    processor.cleanUp();
                                    try {}
                                    catch (IOException iOException) {}
                                    readStream.close();
                                    readStream = null;
                                }
                                mon.done();
                                return;
                            }
                            Object var23_22 = null;
                            if (!CommunicationDebug.INSTANCE.debugUseEventMode || readStream == null) break block49;
                            try {}
                            catch (Exception exception) {}
                            processor.cleanUp();
                            try {}
                            catch (IOException iOException) {}
                            readStream.close();
                            readStream = null;
                        }
                        mon.done();
                        return;
                    }
                    Object var23_24 = null;
                    if (!CommunicationDebug.INSTANCE.debugUseEventMode || readStream == null) break block50;
                    try {}
                    catch (Exception exception) {}
                    processor.cleanUp();
                    try {}
                    catch (IOException iOException) {}
                    readStream.close();
                    readStream = null;
                }
                mon.done();
                return;
            }
            Object var23_26 = null;
            if (!CommunicationDebug.INSTANCE.debugUseEventMode || readStream == null) break block51;
            try {}
            catch (Exception exception) {}
            processor.cleanUp();
            try {}
            catch (IOException iOException) {}
            readStream.close();
            readStream = null;
        }
        mon.done();
    }

    private boolean loadLine(int line, double position, double startLength, double endLength) {
        if (line <= 7) {
            return true;
        }
        return position >= startLength && position <= endLength;
    }

    private boolean loadXMLTrace() {
        IContainer res;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        boolean shouldSwitch = HyadesUIPlugin.getInstance().openPerspectiveSwitchDialog(window.getShell(), "org.eclipse.hyades.trace.internal.ui.tracePerspective", UIPlugin.getDefault().getPreferenceStore(), "switch_to_perspective", TraceWizardMessages.CONFIRM_PSWITCH);
        if (shouldSwitch) {
            UIPlugin.getActivePage();
        }
        if ("org.eclipse.hyades.trace.internal.ui.tracePerspective".equals(window.getActivePage().getPerspective().getId())) {
            try {
                PDProjectExplorer nav = (PDProjectExplorer)UIPlugin.getActivePage().showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
                nav.getViewer().refresh();
            }
            catch (Exception e) {
                HyadesUIPlugin.logError((Throwable)e);
            }
        }
        if ((res = PDCoreUtil.createContainer((IPath)new Path(this._location.getLocation().getText().trim()))) == null) {
            return false;
        }
        TRCMonitor mon = PDCoreUtil.createMonitor(res, this._location.getMonitor().getText().trim());
        this.fError = this.createModel(mon, this.sourceNameField.getText().trim());
        ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
        event.setSource(null);
        event.setType(128);
        UIPlugin.getDefault().notifyProfileEventListener(event);
        if (this.fError != null) {
            if (!this.fError.equals("")) {
                Status err1 = new Status(2, "org.eclipse.core.resources", 566, this.fError, null);
                ErrorDialog.openError((Shell)this.getShell(), (String)TraceMessages.TRC_MSGT, (String)TraceMessages.ERR_LXML, (IStatus)err1);
            }
            return false;
        }
        return true;
    }

    public void setTraceFile(String fullPath) {
        this.sourceNameField.setText(fullPath);
    }

    static final class FileInfo {
        InputStream inputStream;
        long fileLength;

        FileInfo() {
        }
    }
}

