/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImportTraceRangeUI
implements SelectionListener,
ModifyListener {
    Label _regionLabel;
    Button _wholeFileBtn;
    Button _inRangeBtn;
    Label _startLabel;
    Text _startText;
    Label _ofFileLabel1;
    Label _ofFileLabel2;
    Label _stopLabel;
    Text _stopText;
    double startValue = 0.0;
    double stopValue = 100.0;
    WizardPage _wizardPage;
    private Button _showExecFlow;
    private Button _showExecStatistic;
    private Button _showHeapStatistic;
    private Label _description;

    public ImportTraceRangeUI(WizardPage wp) {
        this._wizardPage = wp;
    }

    public Composite createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gd = GridUtil.createFill();
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(TraceMessages.IMP_OPT);
        this.addRangeOption(composite);
        this.addStatisticOption(composite);
        this.createSpacer(composite);
        this.initData();
        return composite;
    }

    private void addRangeOption(Composite parent) {
        Composite optionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 7;
        layout.verticalSpacing = 5;
        optionGroup.setLayout((Layout)layout);
        this._wholeFileBtn = new Button(optionGroup, 16);
        GridData gd = new GridData();
        gd.horizontalSpan = 7;
        this._wholeFileBtn.setLayoutData((Object)gd);
        this._wholeFileBtn.setText(TraceMessages.IMP_COMP);
        this._inRangeBtn = new Button(optionGroup, 16);
        this._inRangeBtn.setText(TraceMessages.IMP_PART);
        this._startLabel = new Label(optionGroup, 0);
        this._startLabel.setText(TraceMessages.FROM_STR);
        this._startText = new Text(optionGroup, 2048);
        gd = new GridData();
        gd.widthHint = 30;
        this._startText.setLayoutData((Object)gd);
        this._ofFileLabel1 = new Label(optionGroup, 0);
        this._ofFileLabel1.setText(TraceMessages.FPERC);
        this._stopLabel = new Label(optionGroup, 0);
        this._stopLabel.setText(TraceMessages.TO_STR);
        this._stopText = new Text(optionGroup, 2048);
        gd = new GridData();
        gd.widthHint = 30;
        this._stopText.setLayoutData((Object)gd);
        this._ofFileLabel2 = new Label(optionGroup, 0);
        this._ofFileLabel2.setText(TraceMessages.FPERC);
        this._wholeFileBtn.addSelectionListener((SelectionListener)this);
        this._inRangeBtn.addSelectionListener((SelectionListener)this);
        this._startText.addModifyListener((ModifyListener)this);
        this._stopText.addModifyListener((ModifyListener)this);
    }

    private void addStatisticOption(Composite parent) {
        Group _showExecGroup = new Group(parent, 0);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        _showExecGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        _showExecGroup.setLayout((Layout)layout);
        this._showHeapStatistic = new Button((Composite)_showExecGroup, 16);
        this._showHeapStatistic.setText(TraceMessages.HEAP_STAT);
        this._showExecStatistic = new Button((Composite)_showExecGroup, 16);
        this._showExecStatistic.setText(TraceMessages.EXEC_STAT);
        this._showExecFlow = new Button((Composite)_showExecGroup, 16);
        this._showExecFlow.setText(TraceMessages.FULL_DATA);
        this._description = new Label(parent, 64);
        this._description.setText(TraceMessages.ANHEAP);
        data = GridUtil.createFill();
        data.horizontalIndent = 20;
        data.widthHint = 50;
        data.heightHint = 80;
        this._description.setLayoutData((Object)data);
        this._showHeapStatistic.setSelection(true);
        this._showHeapStatistic.addSelectionListener((SelectionListener)this);
        this._showExecStatistic.addSelectionListener((SelectionListener)this);
        this._showExecFlow.addSelectionListener((SelectionListener)this);
    }

    protected void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }

    private void initData() {
        this._wholeFileBtn.setSelection(true);
        this._startText.setText(String.valueOf(this.startValue));
        this._stopText.setText(String.valueOf(this.stopValue));
        this.setRangeInputEnable(false);
    }

    public Button getWholeFileBtn() {
        return this._wholeFileBtn;
    }

    public Button getInRangeBtn() {
        return this._inRangeBtn;
    }

    public boolean getWholeFileSelection() {
        return this._wholeFileBtn.getSelection();
    }

    public boolean getInRangeSelection() {
        return this._inRangeBtn.getSelection();
    }

    public double getStartRange() {
        return this.startValue;
    }

    public double getStopRange() {
        return this.stopValue;
    }

    public String checkRegionValue() {
        if (this._startText.getText().trim().equals("") || this._stopText.getText().trim().equals("")) {
            return TraceMessages.CANT_EMPTV;
        }
        try {
            this.startValue = Double.parseDouble(this._startText.getText().trim());
            this.stopValue = Double.parseDouble(this._stopText.getText().trim());
            if (this.startValue > this.stopValue) {
                return TraceMessages.STRT_LS;
            }
            if (this.startValue == this.stopValue) {
                return TraceMessages.CNT_SAME;
            }
            if (this.startValue < 0.0 || this.startValue > 100.0 || this.stopValue < 0.0 || this.stopValue > 100.0) {
                return TraceMessages.INV_IMPR;
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return TraceMessages.INV_IMPS;
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this._startText || e.widget == this._stopText) {
            this._wizardPage.setErrorMessage(this.checkRegionValue());
        }
    }

    public void setRangeInputEnable(boolean enable) {
        this._startLabel.setEnabled(enable);
        this._startText.setEnabled(enable);
        this._ofFileLabel1.setEnabled(enable);
        this._stopLabel.setEnabled(enable);
        this._stopText.setEnabled(enable);
        this._ofFileLabel2.setEnabled(enable);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this._wholeFileBtn) {
            this.setRangeInputEnable(false);
            this.startValue = 0.0;
            this.stopValue = 100.0;
            this._wizardPage.setErrorMessage(null);
        } else if (e.widget == this._inRangeBtn) {
            this.setRangeInputEnable(true);
            this._wizardPage.setErrorMessage(this.checkRegionValue());
        } else if (e.widget == this._showExecStatistic) {
            this._description.setText(TraceMessages.AN_EXTM);
        } else if (e.widget == this._showHeapStatistic) {
            this._description.setText(TraceMessages.ANHEAP);
        } else if (e.widget == this._showExecFlow) {
            this._description.setText(TraceMessages.AN_EXTMF);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Button getshowExecFlow() {
        return this._showExecFlow;
    }

    public Button getshowExecStatistic() {
        return this._showExecStatistic;
    }

    public Button getshowHeapStatistic() {
        return this._showHeapStatistic;
    }

    public Label getdescription() {
        return this._description;
    }

    public Text getstartText() {
        return this._startText;
    }

    public Text getstopText() {
        return this._stopText;
    }
}

