/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceFileUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentWizard;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class OpenProfAgentFolderPage
extends WizardPage
implements ModifyListener,
SelectionListener {
    protected PDProjectExplorer fViewer;
    private String location;
    private String monitor;
    private TraceFileUI _fileUI;
    private TraceLocationUI _locationUI;

    public OpenProfAgentFolderPage(String name, PDProjectExplorer viewer) {
        super(name);
        this.setTitle(TraceMessages.DEST_MONP);
        this.setDescription(TraceMessages.DEST_MOND);
        this.fViewer = viewer;
    }

    public String getFile() {
        return this._fileUI.getSelection() ? this._fileUI.getFile() : "";
    }

    public String getMonitor() {
        return this.monitor;
    }

    public String getProject() {
        return this.location;
    }

    public void createControl(Composite parent) {
        Composite btnGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        btnGroup.setLayout((Layout)layout);
        btnGroup.setLayoutData((Object)GridUtil.createFill());
        this._locationUI = new TraceLocationUI();
        this._locationUI.createControl(btnGroup);
        this._locationUI.setEnabled(false);
        this._fileUI = new TraceFileUI();
        this._fileUI.createControl(btnGroup);
        this._fileUI.getExternalBox().addSelectionListener((SelectionListener)this);
        this._fileUI.getFileText().addModifyListener((ModifyListener)this);
        TRCAgentProxy agent = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (agent == null || !agent.isActive() || agent.isActive() && agent.isAttached()) {
            this._fileUI.setEnabled(false);
            this._fileUI.getExternalBox().setEnabled(false);
        }
        this.setControl((Control)btnGroup);
        this.populateData();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(UIPlugin.getPluginId()) + ".opaf0000");
    }

    public boolean finish() {
        XMLTraceDataProcessor processor;
        TRCAgentProxy agent = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (agent == null || !agent.isActive()) {
            return true;
        }
        if (this._fileUI.getExternalBox().getSelection()) {
            agent.setProfileFile(this._fileUI.getFile());
        } else {
            agent.setProfileFile(null);
        }
        if (agent.isMonitored() && agent.isToProfileFile() && (processor = (XMLTraceDataProcessor)LoadersUtils.locateDataProcessor((TRCAgentProxy)agent)) != null) {
            File testFile;
            String processorProfileFileName = processor.getProfileFileName();
            File processorProfilingFile = new File(processorProfileFileName);
            boolean newFile = true;
            if (agent.getProfileFile() != null && (testFile = new File(agent.getProfileFile())).exists()) {
                newFile = false;
            }
            if (processorProfilingFile == null && agent.getProfileFile() != null) {
                processor.setProfileFileName(agent.getProfileFile());
                processor.createWriter();
                newFile = processor.isNewProfileFile();
                if (newFile) {
                    processor.writeXMLVersion(processor.getWriter());
                    processor.startTrace(processor.getWriter());
                }
            } else if (!(processorProfileFileName == null || processorProfileFileName.equals(agent.getProfileFile()) && processorProfilingFile.exists())) {
                if (processorProfilingFile.exists()) {
                    processor.endTrace(processor.getWriter());
                }
                processor.setProfileFileName(agent.getProfileFile());
                processor.createWriter();
                newFile = processor.isNewProfileFile();
                if (newFile) {
                    processor.writeXMLVersion(processor.getWriter());
                    processor.startTrace(processor.getWriter());
                }
            }
        }
        return true;
    }

    public void modifyText(ModifyEvent event) {
        this.checkPageComplete();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.checkPageComplete();
    }

    protected void populateData() {
        TRCAgentProxy agent;
        IResource sel = HyadesUtil.getSelectionFolder((INavigator)this.fViewer);
        if (sel != null) {
            this._locationUI.setLocation(sel.getFullPath().toOSString());
        }
        if ((agent = ((OpenProfAgentWizard)this.getWizard()).getAgent()) == null) {
            return;
        }
        this._locationUI.setMonitor(agent.getProcessProxy().getNode().getMonitor().getName());
        if (agent.isToProfileFile()) {
            this._fileUI.getExternalBox().setSelection(true);
            this._fileUI.setEnabled(true);
            this._fileUI.setFile(agent.getProfileFile());
        }
        if (!agent.isActive() || agent.isActive() && agent.isAttached()) {
            this._fileUI.setEnabled(false);
            this._fileUI.getExternalBox().setEnabled(false);
        }
    }

    private void checkPageComplete() {
        this.setPageComplete(!this._locationUI.getLocation().getText().trim().equals("") && !this._locationUI.getMonitor().getText().trim().equals("") && (!this._fileUI.getSelection() || !this._fileUI.getFile().equals("")));
    }
}

