/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.internal.util;

import com.ibm.icu.text.DateFormat;
import java.security.Key;
import java.security.cert.X509Certificate;
import org.eclipse.hyades.security.internal.util.SecurityMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CertificateProperties
extends Dialog {
    private String alias;
    private Object cert;

    public CertificateProperties(Shell parentShell) {
        super(parentShell);
    }

    public void init(String alias, Object cert) {
        this.alias = alias;
        this.cert = cert;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(SecurityMessages._17);
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData data = GridUtil.createFill();
        data.widthHint = 450;
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)data);
        Label lblAlias = new Label(content, 0);
        lblAlias.setText(SecurityMessages._25);
        data = new GridData();
        data.horizontalIndent = 5;
        lblAlias.setLayoutData((Object)data);
        Label lblAliasValue = new Label(content, 0);
        lblAliasValue.setText(this.alias);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblAliasValue.setLayoutData((Object)data);
        Label lblVersion = new Label(content, 0);
        lblVersion.setText(SecurityMessages._18);
        data = new GridData();
        data.horizontalIndent = 5;
        lblVersion.setLayoutData((Object)data);
        Label lblVersionValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblVersionValue.setLayoutData((Object)data);
        Label lblIssuedTo = new Label(content, 0);
        lblIssuedTo.setText(SecurityMessages._26);
        data = new GridData();
        data.verticalAlignment = 1;
        data.horizontalIndent = 5;
        lblIssuedTo.setLayoutData((Object)data);
        Text lblIssuedToValue = new Text(content, 2120);
        data = new GridData(768);
        data.heightHint = 60;
        data.horizontalIndent = 5;
        lblIssuedToValue.setLayoutData((Object)data);
        Label lblIssuedBy = new Label(content, 0);
        lblIssuedBy.setText(SecurityMessages._27);
        data = new GridData();
        data.horizontalIndent = 5;
        data.verticalAlignment = 1;
        lblIssuedBy.setLayoutData((Object)data);
        Text lblIssuedByValue = new Text(content, 2120);
        data = new GridData(768);
        data.horizontalIndent = 5;
        data.heightHint = 60;
        lblIssuedByValue.setLayoutData((Object)data);
        Label lblValidity = new Label(content, 0);
        lblValidity.setText(SecurityMessages._28);
        data = new GridData();
        data.horizontalIndent = 5;
        lblValidity.setLayoutData((Object)data);
        Label lblValidityValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblValidityValue.setLayoutData((Object)data);
        Label lblAlgorithm = new Label(content, 0);
        lblAlgorithm.setText(SecurityMessages._29);
        data = new GridData();
        data.horizontalIndent = 5;
        lblAlgorithm.setLayoutData((Object)data);
        Label lblAlgorithmValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblAlgorithmValue.setLayoutData((Object)data);
        if (this.cert instanceof X509Certificate) {
            lblVersionValue.setText(String.valueOf(((X509Certificate)this.cert).getType()) + " V." + ((X509Certificate)this.cert).getVersion());
            lblIssuedToValue.setText(((X509Certificate)this.cert).getSubjectDN().getName());
            lblIssuedByValue.setText(((X509Certificate)this.cert).getIssuerDN().getName());
            DateFormat df = DateFormat.getDateInstance((int)1);
            String validity = NLS.bind((String)SecurityMessages._30, (Object[])new Object[]{df.format(((X509Certificate)this.cert).getNotBefore()), df.format(((X509Certificate)this.cert).getNotAfter())});
            lblValidityValue.setText(validity);
            lblAlgorithmValue.setText(((X509Certificate)this.cert).getSigAlgName());
        } else if (this.cert instanceof Key) {
            lblVersionValue.setText(((Key)this.cert).getFormat());
            lblAlgorithmValue.setText(((Key)this.cert).getAlgorithm());
        }
        return content;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

