/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.internal.util;

import com.ibm.icu.text.DateFormat;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.TrustManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.security.ISecureClientParameters;
import org.eclipse.hyades.execution.security.KeystoreHelper;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.security.DuplicateUserException;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;
import org.eclipse.hyades.internal.execution.security.User;
import org.eclipse.hyades.internal.execution.security.UserFactory;
import org.eclipse.hyades.security.internal.util.ConnectivityDialog;
import org.eclipse.hyades.security.internal.util.SecurityMessages;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ConnectUtil {
    public static final int CONNECTION_SUCCESS = 0;
    public static final int CONNECTION_CONTROLLER_ERROR = 1;
    public static final int CONNECTION_HOST_ERROR = 2;
    public static final int CONNECTION_PORT_ERROR = 3;
    public static final int CONNECTION_SECURITY_NOT_SUPPORTED = 4;
    private Application _app;
    private String _port;
    private String _hostName;
    private InetAddress _hostAddr;
    private String _userId;
    private Node _node;
    private ConnectErrorMsg _connectErrorMessage;
    private ConnectivityDialog dlg;
    private int btnPressed = 0;
    private boolean okPressed = false;

    public ConnectUtil(String hostName, String port, Application app) {
        this(hostName, port, null, app);
    }

    public ConnectUtil(String hostName, String port, String userId, Application app) {
        this._hostName = hostName;
        this._port = port;
        this._userId = userId;
        this._app = app;
        this._connectErrorMessage = null;
    }

    public ConnectUtil(InetAddress hostAddr, String port, Application app) {
        this(hostAddr, port, null, app);
    }

    public ConnectUtil(InetAddress hostAddr, String port, String userId, Application app) {
        this._hostAddr = hostAddr;
        this._hostName = this._hostAddr.getHostName();
        this._port = port;
        this._userId = userId;
        this._app = app;
    }

    private ISecureClientParameters getClientParms() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(HyadesUIPlugin.getID(), "JSSESecurityProviders");
        int idx = 0;
        while (idx < config.length) {
            IConfigurationElement elem = config[idx];
            String classAttr = elem.getAttribute("class");
            if (classAttr != null) {
                try {
                    Object realization = elem.createExecutableExtension("class");
                    if (realization instanceof ISecureClientParameters) {
                        ISecureClientParameters parms = (ISecureClientParameters)realization;
                        Security.addProvider(parms.getSecurityProvider());
                        parms.getKeystoreManager().setProvider(parms.getSecurityProvider());
                        return (ISecureClientParameters)realization;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++idx;
        }
        return null;
    }

    public void showErrorDialogForConnect() {
        if (this._connectErrorMessage != null) {
            this.openErrorDialog(SecurityMessages._41, this._connectErrorMessage.getErrorMessage(), this._connectErrorMessage.getErrorStatus());
        }
    }

    public final int connect() {
        return this.connect(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int connect(String password, boolean showErrorMsgs) {
        X509Certificate cert;
        block20: {
            this._connectErrorMessage = null;
            try {
                if (this._hostName.equals("localhost") && this._port.equals("-1")) {
                    this._hostAddr = InetAddress.getLocalHost();
                    break block20;
                }
                if (this._hostAddr == null) {
                    this._hostAddr = InetAddress.getByName(this._hostName);
                }
            }
            catch (UnknownHostException exc) {
                this.resetConnection();
                Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._43, (Object)this._hostName), (Throwable)exc);
                this._connectErrorMessage = new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err);
                if (!showErrorMsgs) return 2;
                this.showErrorDialogForConnect();
                return 2;
            }
        }
        try {
            if (this._node == null) {
                this._node = NodeFactory.createNode((InetAddress)this._hostAddr, (Principal)this._app);
                this._node.setUser(null);
                this._node.setSecurityParameters(null);
            }
            this._node.connect(Integer.parseInt(this._port));
            return 0;
        }
        catch (UnknownHostException exc) {
            this.resetConnection();
            Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._43, (Object)this._hostName), (Throwable)exc);
            this._connectErrorMessage = new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err);
            if (!showErrorMsgs) return 2;
            this.showErrorDialogForConnect();
            return 2;
        }
        catch (SecureConnectionRequiredException exc) {
            return this.connectUnderException((AgentControllerUnavailableException)((Object)exc), password, showErrorMsgs);
        }
        catch (LoginFailedException exc) {
            return this.connectUnderException((AgentControllerUnavailableException)((Object)exc), password, showErrorMsgs);
        }
        catch (UntrustedAgentControllerException exc) {
            TrustManager[] tManagers = this._node.getSecurityParameters().getKeystoreManager().getTrustManagers();
            cert = null;
            try {
                int i = 0;
                while (i < tManagers.length) {
                    Method getReceivedCerts = tManagers[i].getClass().getMethod("getReceivedCerts", null);
                    Object certs = getReceivedCerts.invoke((Object)tManagers[i], null);
                    if (certs != null) {
                        cert = (X509Certificate)((Object[])certs)[0];
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
        catch (AgentControllerUnavailableException exc) {
            this.resetConnection();
            Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._67, (Object)this._hostName), (Throwable)exc);
            this._connectErrorMessage = new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err);
            if (!showErrorMsgs) return 1;
            this.showErrorDialogForConnect();
            return 1;
        }
        catch (NumberFormatException exc) {
            this.resetConnection();
            Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._44, (Object)String.valueOf(this._port)), (Throwable)exc);
            this._connectErrorMessage = new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err);
            if (!showErrorMsgs) return 3;
            this.showErrorDialogForConnect();
            return 3;
        }
        int rc = 0;
        boolean ok = false;
        do {
            String[] btnLabels = new String[]{SecurityMessages._32, SecurityMessages._33, SecurityMessages._34};
            rc = this.openQuestionDialog(SecurityMessages._41, NLS.bind((String)SecurityMessages._70, (Object)this._hostName), btnLabels);
            if (rc == 0) {
                ok = this.openSaveCertificateDialog(cert);
                if (ok) continue;
                ok = this.openQuestionDialog(SecurityMessages._17, SecurityMessages._76, null) == 0;
                continue;
            }
            if (rc == 1) {
                ok = this.openQuestionDialog(SecurityMessages._17, SecurityMessages._76, null) == 0;
                continue;
            }
            this.openCertificateDetailDialog(cert);
        } while (rc == 2);
        if (!ok) {
            this.resetConnection();
            Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._68, (Object)this._hostName), (Throwable)exc);
            this._connectErrorMessage = new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err);
            if (!showErrorMsgs) return 1;
            this.showErrorDialogForConnect();
            return 1;
        }
        ISecureClientParameters params = this._node.getSecurityParameters();
        if (params == null) return this.connect(showErrorMsgs);
        params.disableServerAuthentication();
        return this.connect(showErrorMsgs);
    }

    public final int connect(boolean showErrorMsgs) {
        return this.connect(null, showErrorMsgs);
    }

    public String getUserId() {
        return this._userId;
    }

    public Node getNode() {
        return this._node;
    }

    private void resetConnection() {
        if (this._userId != null) {
            UserFactory.removeUser((Application)this._app, (String)this._userId);
        }
        if (this._node != null) {
            this._node.setSecurityParameters(null);
        }
    }

    private int connectUnderException(AgentControllerUnavailableException exc, String password, boolean showErrorMsgs) {
        try {
            User user = null;
            if (this._userId != null && !this._userId.equals("")) {
                user = UserFactory.getUser((Application)this._app, (String)this._userId);
            }
            if (user == null) {
                if (exc instanceof SecureConnectionRequiredException && ((SecureConnectionRequiredException)((Object)exc)).isPasswordProtected()) {
                    if (this._userId == null || password == null) {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                ConnectUtil.this.dlg = new ConnectivityDialog(ConnectUtil.getValidShell(), ConnectUtil.this._hostName, ConnectUtil.this._userId, ConnectUtil.this._userId == null || ConnectUtil.this._userId.equals(""));
                                ConnectUtil.this.dlg.setDescription(SecurityMessages._51);
                                ConnectUtil.this.dlg.create();
                                ConnectUtil.this.openDialog(ConnectUtil.this.dlg);
                            }
                        });
                        if (this.dlg.getReturnCode() != 0) {
                            this.resetConnection();
                            Status err = new Status(2, "org.eclipse.core.resources", 2, SecurityMessages._51, null);
                            this._connectErrorMessage = new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err);
                            if (showErrorMsgs) {
                                this.showErrorDialogForConnect();
                            }
                            return 2;
                        }
                        this._userId = this.dlg.getUserId();
                    }
                    if (UserFactory.getUser((Application)this._app, (String)this._userId) != null) {
                        UserFactory.removeUser((Application)this._app, (String)this._userId);
                    }
                    user = UserFactory.createUser((Application)this._app, (String)this._userId, (String)(this.dlg == null ? password : this.dlg.getPassword()));
                } else {
                    this._userId = "ignoredUserId";
                    user = UserFactory.createUser((Application)this._app, (String)this._userId, (String)"dummyPass");
                }
            } else if (exc instanceof LoginFailedException) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ConnectUtil.this.dlg = new ConnectivityDialog(ConnectUtil.getValidShell(), ConnectUtil.this._hostName, ConnectUtil.this._userId);
                        ConnectUtil.this.dlg.setDescription(SecurityMessages._52);
                        ConnectUtil.this.dlg.create();
                        ConnectUtil.this.openDialog(ConnectUtil.this.dlg);
                    }
                });
                if (this.dlg.getReturnCode() != 0) {
                    this.resetConnection();
                    Status err = new Status(2, "org.eclipse.core.resources", 2, SecurityMessages._51, null);
                    this._connectErrorMessage = new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err);
                    if (showErrorMsgs) {
                        this.showErrorDialogForConnect();
                    }
                    return 2;
                }
                this._userId = this.dlg.getUserId();
                user = UserFactory.getUser((Application)this._app, (String)this._userId);
                if (user != null) {
                    user.setPassword(this.dlg.getPassword());
                } else {
                    try {
                        user = UserFactory.createUser((Application)this._app, (String)this._userId, (String)this.dlg.getPassword());
                    }
                    catch (DuplicateUserException duplicateUserException) {}
                }
            }
            if (exc instanceof SecureConnectionRequiredException) {
                this._port = new Long(((SecureConnectionRequiredException)((Object)exc)).getSecurePort()).toString();
            } else if (exc instanceof LoginFailedException) {
                this._port = new Long(((LoginFailedException)((Object)exc)).getSecurePort()).toString();
            }
            if (this._node.getSecurityParameters() == null) {
                ISecureClientParameters parms = this.getClientParms();
                if (parms == null) {
                    this.resetConnection();
                    Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._71, (Object)this._hostName), null);
                    this._connectErrorMessage = new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err);
                    if (showErrorMsgs) {
                        this.showErrorDialogForConnect();
                    }
                    return 4;
                }
                this._node.setSecurityParameters(this.getClientParms());
                this._node.getSecurityParameters().getKeystoreManager().loadKeystore(this._node.getSecurityParameters().getKeystoreFileName(), this._node.getSecurityParameters().getKeystoreFilepassword());
            }
            this._node.setUser(user);
            return this.connect(password, showErrorMsgs);
        }
        catch (DuplicateUserException duplicateUserException) {
            this.resetConnection();
        }
        catch (IOException e) {
            try {
                if (this._node.getSecurityParameters() == null) {
                    this.resetConnection();
                    Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._71, (Object)this._hostName), (Throwable)e);
                    this._connectErrorMessage = new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err);
                    if (showErrorMsgs) {
                        this.showErrorDialogForConnect();
                    }
                    return 4;
                }
                KeystoreHelper.createKeyStore((String)HyadesUIPlugin.getKeyStoreLocation(), (String)HyadesUIPlugin.getInstance().getWorkspaceName());
                this._node.setSecurityParameters(this.getClientParms());
                this._node.getSecurityParameters().getKeystoreManager().loadKeystore(this._node.getSecurityParameters().getKeystoreFileName(), this._node.getSecurityParameters().getKeystoreFilepassword());
                this._node.setUser(UserFactory.getUser((Application)this._app, (String)this._userId));
                return this.connect(showErrorMsgs);
            }
            catch (Exception exception) {
                this.resetConnection();
                Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._69, (Object)HyadesUIPlugin.getKeyStoreLocation()), (Throwable)e);
                this._connectErrorMessage = new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err);
                if (showErrorMsgs) {
                    this.showErrorDialogForConnect();
                }
                return 2;
            }
        }
        catch (CertificateException e) {
            this.resetConnection();
            Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._46, (Object)HyadesUIPlugin.getKeyStoreLocation()), (Throwable)e);
            this._connectErrorMessage = new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err);
            if (showErrorMsgs) {
                this.showErrorDialogForConnect();
            }
            return 2;
        }
        catch (KeyManagementException e) {
            this.resetConnection();
            Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._48, (Object)HyadesUIPlugin.getKeyStoreLocation()), (Throwable)e);
            this._connectErrorMessage = new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err);
            if (showErrorMsgs) {
                this.showErrorDialogForConnect();
            }
            return 2;
        }
        catch (KeyStoreException e) {
            this.resetConnection();
            Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._49, (Object)HyadesUIPlugin.getKeyStoreLocation()), (Throwable)e);
            this._connectErrorMessage = new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err);
            if (showErrorMsgs) {
                this.showErrorDialogForConnect();
            }
            return 2;
        }
        catch (NoSuchAlgorithmException e) {
            this.resetConnection();
            Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._47, (Object)HyadesUIPlugin.getKeyStoreLocation()), (Throwable)e);
            this._connectErrorMessage = new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err);
            if (showErrorMsgs) {
                this.showErrorDialogForConnect();
            }
            return 2;
        }
        catch (UnrecoverableKeyException e) {
            this.resetConnection();
            Status err = new Status(2, "org.eclipse.core.resources", 2, NLS.bind((String)SecurityMessages._50, (Object)HyadesUIPlugin.getKeyStoreLocation()), (Throwable)e);
            this._connectErrorMessage = new ConnectErrorMsg(NLS.bind((String)SecurityMessages._42, (Object)this._hostName), err);
            if (showErrorMsgs) {
                this.showErrorDialogForConnect();
            }
            return 2;
        }
        return 0;
    }

    private void openErrorDialog(final String title, final String msg, final Status err) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)ConnectUtil.getValidShell(), (String)title, (String)msg, (IStatus)err);
            }
        });
    }

    private void openDialog(final Dialog dialog) {
        dialog.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    private static Shell getValidShell() {
        Shell shell = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            if (workbench.getActiveWorkbenchWindow() != null && (shell = workbench.getActiveWorkbenchWindow().getShell()) != null && !shell.isDisposed()) {
                return shell;
            }
            if (workbench.getWorkbenchWindows().length > 0 && (shell = workbench.getWorkbenchWindows()[0].getShell()) != null && !shell.isDisposed()) {
                return shell;
            }
        }
        return null;
    }

    private int openQuestionDialog(final String title, final String msg, final String[] btnLabels) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (btnLabels != null) {
                    MessageDialog dialog = new MessageDialog(ConnectUtil.getValidShell(), title, null, msg, 3, btnLabels, 0);
                    ConnectUtil.this.btnPressed = dialog.open();
                } else {
                    ConnectUtil.this.btnPressed = MessageDialog.openQuestion((Shell)ConnectUtil.getValidShell(), (String)title, (String)msg) ? 0 : 1;
                }
            }
        });
        return this.btnPressed;
    }

    private void openCertificateDetailDialog(final X509Certificate certificate) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                CertificateDetails dlg = new CertificateDetails(ConnectUtil.getValidShell());
                dlg.init(certificate);
                dlg.open();
            }
        });
    }

    private boolean openSaveCertificateDialog(final X509Certificate cert) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                SaveCertificate dlg = new SaveCertificate(ConnectUtil.getValidShell());
                dlg.init(cert);
                ConnectUtil.this.okPressed = dlg.open() == 0;
            }
        });
        return this.okPressed;
    }

    private String toHexString(byte[] data) {
        StringBuffer hexString = new StringBuffer();
        int i = 0;
        while (i < data.length - 1) {
            hexString.append(Integer.toHexString(0xFF & data[i] | 0x100).substring(1));
            if ((i + 1) % 16 == 0) {
                hexString.append("\n");
            } else if ((i + 1) % 8 == 0) {
                hexString.append("    ");
            } else {
                hexString.append(" ");
            }
            ++i;
        }
        while (i < data.length) {
            hexString.append(Integer.toHexString(0xFF & data[i] | 0x100).substring(1));
            ++i;
        }
        return hexString.toString().toUpperCase();
    }

    public static boolean isLocalHost(String hostname) {
        String name = "localhost";
        if (name.equals(hostname)) {
            return true;
        }
        try {
            Node fnode = NodeFactory.createNode((String)name);
            name = fnode.getInetAddress().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        return hostname.equals(name);
    }

    private class ConnectErrorMsg {
        private String _errorMessage;
        private Status _status;

        public ConnectErrorMsg(String errorMessage, Status status) {
            this._errorMessage = errorMessage;
            this._status = status;
        }

        public String getErrorMessage() {
            return this._errorMessage;
        }

        public Status getErrorStatus() {
            return this._status;
        }
    }

    class CertificateDetails
    extends Dialog {
        private X509Certificate cert;

        public CertificateDetails(Shell shell) {
            super(shell);
        }

        public void init(X509Certificate cer) {
            this.cert = cer;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(SecurityMessages._17);
            Composite content = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            GridData data = GridUtil.createFill();
            data.widthHint = 450;
            layout.numColumns = 2;
            content.setLayout((Layout)layout);
            content.setLayoutData((Object)data);
            if (this.cert == null) {
                Label errorIcon = new Label(content, 0);
                errorIcon.setImage(Display.getCurrent().getSystemImage(1));
                data = new GridData();
                data.verticalAlignment = 2;
                data.horizontalIndent = 5;
                errorIcon.setLayoutData((Object)data);
                Label lblErrMsg = new Label(content, 0);
                lblErrMsg.setText(SecurityMessages._72);
                data = new GridData();
                data.verticalAlignment = 8;
                data.horizontalIndent = 5;
                lblErrMsg.setLayoutData((Object)data);
                return content;
            }
            Label lblVersion = new Label(content, 0);
            lblVersion.setText(SecurityMessages._18);
            data = new GridData();
            data.horizontalIndent = 5;
            lblVersion.setLayoutData((Object)data);
            Label lblVersionValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblVersionValue.setLayoutData((Object)data);
            Label lblSubject = new Label(content, 0);
            lblSubject.setText(SecurityMessages._19);
            data = new GridData();
            data.horizontalIndent = 5;
            lblSubject.setLayoutData((Object)data);
            Label lblSubjectValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblSubjectValue.setLayoutData((Object)data);
            Label lblSigAlg = new Label(content, 0);
            lblSigAlg.setText(SecurityMessages._20);
            data = new GridData();
            data.horizontalIndent = 5;
            lblSigAlg.setLayoutData((Object)data);
            Label lblSigAlgValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblSigAlgValue.setLayoutData((Object)data);
            Label lblKey = new Label(content, 0);
            lblKey.setText(SecurityMessages._21);
            data = new GridData();
            data.horizontalIndent = 5;
            lblKey.setLayoutData((Object)data);
            Label lblKeyValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblKeyValue.setLayoutData((Object)data);
            Label lblPublicKey = new Label(content, 0);
            lblPublicKey.setText(SecurityMessages._22);
            data = new GridData();
            data.verticalAlignment = 1;
            data.horizontalIndent = 5;
            lblPublicKey.setLayoutData((Object)data);
            Text lblPublicKeyValue = new Text(content, 2632);
            data = new GridData(768);
            data.heightHint = 60;
            data.horizontalIndent = 5;
            lblPublicKeyValue.setLayoutData((Object)data);
            Label lblValidity = new Label(content, 0);
            lblValidity.setText(SecurityMessages._28);
            data = new GridData();
            data.horizontalIndent = 5;
            lblValidity.setLayoutData((Object)data);
            Label lblValidityValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblValidityValue.setLayoutData((Object)data);
            Label lblIssuedTo = new Label(content, 0);
            lblIssuedTo.setText(SecurityMessages._26);
            data = new GridData();
            data.verticalAlignment = 1;
            data.horizontalIndent = 5;
            lblIssuedTo.setLayoutData((Object)data);
            Label lblIssuedToValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblIssuedToValue.setLayoutData((Object)data);
            Label lblIssuedBy = new Label(content, 0);
            lblIssuedBy.setText(SecurityMessages._27);
            data = new GridData();
            data.horizontalIndent = 5;
            data.verticalAlignment = 1;
            lblIssuedBy.setLayoutData((Object)data);
            Label lblIssuedByValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblIssuedByValue.setLayoutData((Object)data);
            Label lblSerialNum = new Label(content, 0);
            lblSerialNum.setText(SecurityMessages._23);
            data = new GridData();
            data.horizontalIndent = 5;
            lblSerialNum.setLayoutData((Object)data);
            Label lblSerialNumValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblSerialNumValue.setLayoutData((Object)data);
            Label lblAlgorithm = new Label(content, 0);
            lblAlgorithm.setText(SecurityMessages._29);
            data = new GridData();
            data.horizontalIndent = 5;
            lblAlgorithm.setLayoutData((Object)data);
            Label lblAlgorithmValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblAlgorithmValue.setLayoutData((Object)data);
            Label lblSignature = new Label(content, 0);
            lblSignature.setText(SecurityMessages._24);
            data = new GridData();
            data.verticalAlignment = 1;
            data.horizontalIndent = 5;
            lblSignature.setLayoutData((Object)data);
            Text lblSignatureValue = new Text(content, 2632);
            data = new GridData(768);
            data.heightHint = 60;
            data.horizontalIndent = 5;
            lblSignatureValue.setLayoutData((Object)data);
            lblVersionValue.setText(String.valueOf(this.cert.getType()) + " V." + this.cert.getVersion());
            lblSubjectValue.setText(this.cert.getSubjectDN().getName());
            lblSigAlgValue.setText(String.valueOf(this.cert.getSigAlgName()) + ", OID = " + this.cert.getSigAlgOID());
            lblKeyValue.setText(this.cert.getPublicKey().getAlgorithm());
            lblPublicKeyValue.setText(ConnectUtil.this.toHexString(this.cert.getPublicKey().getEncoded()));
            lblIssuedToValue.setText(this.cert.getSubjectDN().getName());
            lblIssuedByValue.setText(this.cert.getIssuerDN().getName());
            DateFormat df = DateFormat.getDateInstance((int)1);
            String validity = NLS.bind((String)SecurityMessages._30, (Object[])new Object[]{df.format(this.cert.getNotBefore()), df.format(this.cert.getNotAfter())});
            lblValidityValue.setText(validity);
            lblSerialNumValue.setText(this.cert.getSerialNumber().toString());
            lblAlgorithmValue.setText(this.cert.getSigAlgName());
            lblSignatureValue.setText(ConnectUtil.this.toHexString(this.cert.getSignature()));
            return content;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }
    }

    class SaveCertificate
    extends Dialog {
        private X509Certificate cert = null;
        private String alias = null;
        private Text txtAliasValue = null;
        private Button okBtn = null;
        private String title = SecurityMessages._17;
        private Label lblErrMsg = null;
        private Label errorIcon = null;
        private KeyStore ks = null;

        public SaveCertificate(Shell shell) {
            super(shell);
        }

        protected void init(X509Certificate cer) {
            this.cert = cer;
            String storePath = HyadesUIPlugin.getKeyStoreLocation();
            String passw = HyadesUIPlugin.getInstance().getWorkspaceName();
            try {
                this.ks = KeystoreHelper.createKeyStore((String)storePath, (String)passw);
            }
            catch (KeyStoreException exc) {
                Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._57, (Object)HyadesUIPlugin.getKeyStoreLocation()), (Throwable)exc);
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._59, (IStatus)err);
            }
            catch (NoSuchAlgorithmException e) {
                Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._47, (Object)HyadesUIPlugin.getKeyStoreLocation()), (Throwable)e);
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._59, (IStatus)err);
            }
            catch (CertificateException exc) {
                Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._46, (Object)storePath), (Throwable)exc);
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._59, (IStatus)err);
            }
            catch (NoSuchProviderException e) {
                Status err = new Status(4, "org.eclipse.core.resources", 4, SecurityMessages._58, (Throwable)e);
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)NLS.bind((String)SecurityMessages._57, (Object)HyadesUIPlugin.getKeyStoreLocation()), (IStatus)err);
            }
            catch (IOException e) {
                Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._61, (Object)storePath), (Throwable)e);
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._59, (IStatus)err);
            }
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(this.title);
            Composite content = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            GridData data = GridUtil.createFill();
            data.widthHint = 450;
            layout.numColumns = 2;
            content.setLayout((Layout)layout);
            content.setLayoutData((Object)data);
            this.errorIcon = new Label(content, 0);
            this.errorIcon.setImage(Display.getCurrent().getSystemImage(1));
            data = new GridData();
            data.horizontalIndent = 5;
            this.errorIcon.setLayoutData((Object)data);
            this.errorIcon.setVisible(false);
            this.lblErrMsg = new Label(content, 0);
            String text = SecurityMessages._65;
            text = text.length() > SecurityMessages._66.length() ? text : SecurityMessages._66;
            this.lblErrMsg.setText(text);
            data = new GridData();
            data.horizontalIndent = 5;
            this.lblErrMsg.setLayoutData((Object)data);
            this.lblErrMsg.setVisible(false);
            Label lblAlias = new Label(content, 0);
            lblAlias.setText(SecurityMessages._1);
            data = new GridData();
            data.verticalAlignment = 1;
            data.horizontalIndent = 5;
            lblAlias.setLayoutData((Object)data);
            this.txtAliasValue = new Text(content, 2048);
            this.txtAliasValue.addModifyListener(new ModifyListener(this){
                final /* synthetic */ SaveCertificate this$1;
                {
                    this.this$1 = saveCertificate;
                }

                public void modifyText(ModifyEvent e) {
                    String value = SaveCertificate.access$0(this.this$1).getText();
                    if (value == null || value.trim().length() == 0) {
                        SaveCertificate.access$1(this.this$1).setVisible(true);
                        SaveCertificate.access$1(this.this$1).setText(SecurityMessages._65);
                        SaveCertificate.access$2(this.this$1).setVisible(true);
                        SaveCertificate.access$3(this.this$1).setEnabled(false);
                    } else {
                        try {
                            Enumeration<String> enu = SaveCertificate.access$4(this.this$1).aliases();
                            while (enu.hasMoreElements()) {
                                String entry = enu.nextElement();
                                if (!entry.equals(value.trim())) continue;
                                SaveCertificate.access$1(this.this$1).setVisible(true);
                                SaveCertificate.access$1(this.this$1).setText(SecurityMessages._66);
                                SaveCertificate.access$2(this.this$1).setVisible(true);
                                SaveCertificate.access$3(this.this$1).setEnabled(false);
                            }
                        }
                        catch (Exception exception) {}
                        SaveCertificate.access$5(this.this$1, value.trim());
                        SaveCertificate.access$1(this.this$1).setVisible(false);
                        SaveCertificate.access$2(this.this$1).setVisible(false);
                        SaveCertificate.access$3(this.this$1).setEnabled(true);
                    }
                }
            });
            data = new GridData(768);
            data.heightHint = 10;
            data.horizontalIndent = 5;
            this.txtAliasValue.setLayoutData((Object)data);
            return content;
        }

        protected void okPressed() {
            String storePath = HyadesUIPlugin.getKeyStoreLocation();
            String passw = HyadesUIPlugin.getInstance().getWorkspaceName();
            try {
                this.ks.setCertificateEntry(this.alias, this.cert);
                KeystoreHelper.persistKeyStore((KeyStore)this.ks, (String)storePath, (String)passw);
            }
            catch (IOException e) {
                Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._54, (Object)storePath), (Throwable)e);
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._53, (IStatus)err);
            }
            catch (CertificateException exc) {
                Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._55, (Object)storePath), (Throwable)exc);
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._53, (IStatus)err);
            }
            catch (KeyStoreException exc) {
                Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._56, (Object)HyadesUIPlugin.getKeyStoreLocation()), (Throwable)exc);
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._53, (IStatus)err);
            }
            catch (NoSuchAlgorithmException exc2) {
                Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._47, (Object)HyadesUIPlugin.getKeyStoreLocation()), (Throwable)exc2);
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._53, (IStatus)err);
            }
            this.setReturnCode(0);
            this.close();
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.okBtn = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.okBtn.setEnabled(false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        static /* synthetic */ Text access$0(SaveCertificate saveCertificate) {
            return saveCertificate.txtAliasValue;
        }

        static /* synthetic */ Label access$1(SaveCertificate saveCertificate) {
            return saveCertificate.lblErrMsg;
        }

        static /* synthetic */ Label access$2(SaveCertificate saveCertificate) {
            return saveCertificate.errorIcon;
        }

        static /* synthetic */ Button access$3(SaveCertificate saveCertificate) {
            return saveCertificate.okBtn;
        }

        static /* synthetic */ KeyStore access$4(SaveCertificate saveCertificate) {
            return saveCertificate.ks;
        }

        static /* synthetic */ void access$5(SaveCertificate saveCertificate, String string) {
            saveCertificate.alias = string;
        }
    }
}

