/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.internal.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.security.KeystoreHelper;
import org.eclipse.hyades.security.internal.util.SecurityMessages;
import org.eclipse.hyades.security.internal.util.SecurityUI;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class ImportSecurityCertificatePage
extends WizardPage
implements Listener {
    private SecurityUI _securityUI;

    public ImportSecurityCertificatePage(IWorkbench workbench, IStructuredSelection selection) {
        super(SecurityMessages._5);
        this.setTitle(SecurityMessages._5);
        this.setDescription(SecurityMessages._14);
        this.setImageDescriptor(HyadesUIImages.INSTANCE.getImageDescriptor("import_cert_wiz.gif"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = GridUtil.createFill();
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        composite.setLayoutData((Object)data);
        Shell shell = this.getShell();
        this._securityUI = new SecurityUI(shell);
        this._securityUI.createContents(composite);
        this._securityUI.registerListener(this);
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    protected boolean determinePageCompletion() {
        boolean complete = this._securityUI.validateDialog();
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    public boolean finish() {
        KeyStore ks;
        String storePath = HyadesUIPlugin.getKeyStoreLocation();
        String passw = HyadesUIPlugin.getInstance().getWorkspaceName();
        try {
            ks = this.getKeyStore();
            this._securityUI.loadCertificate(ks);
        }
        catch (FileNotFoundException e) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._45, (Object)this._securityUI.getPath()), (Throwable)e);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._31, (IStatus)err);
            return false;
        }
        catch (IOException e) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._61, (Object)this._securityUI.getPath()), (Throwable)e);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._31, (IStatus)err);
            return false;
        }
        catch (CertificateException exc) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._60, (Object)this._securityUI.getPath()), (Throwable)exc);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._31, (IStatus)err);
            return false;
        }
        catch (KeyStoreException exc) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._49, (Object)HyadesUIPlugin.getKeyStoreLocation()), (Throwable)exc);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._31, (IStatus)err);
            return false;
        }
        catch (NoSuchProviderException exc2) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._58, (Object)HyadesUIPlugin.getKeyStoreLocation()), (Throwable)exc2);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)NLS.bind((String)SecurityMessages._57, (Object)HyadesUIPlugin.getKeyStoreLocation()), (IStatus)err);
            return false;
        }
        catch (NoSuchAlgorithmException exc2) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._47, (Object)HyadesUIPlugin.getKeyStoreLocation()), (Throwable)exc2);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._31, (IStatus)err);
            return false;
        }
        try {
            KeystoreHelper.persistKeyStore((KeyStore)ks, (String)storePath, (String)passw);
        }
        catch (IOException e) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._54, (Object)storePath), (Throwable)e);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._53, (IStatus)err);
            return false;
        }
        catch (CertificateException exc) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._55, (Object)storePath), (Throwable)exc);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._53, (IStatus)err);
            return false;
        }
        catch (KeyStoreException exc) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._56, (Object)HyadesUIPlugin.getKeyStoreLocation()), (Throwable)exc);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._53, (IStatus)err);
            return false;
        }
        catch (NoSuchAlgorithmException exc2) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._47, (Object)HyadesUIPlugin.getKeyStoreLocation()), (Throwable)exc2);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._53, (IStatus)err);
            return false;
        }
        return true;
    }

    public void handleEvent(Event e) {
        this.setPageComplete(this.determinePageCompletion());
    }

    private KeyStore getKeyStore() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        return KeystoreHelper.createKeyStore((String)HyadesUIPlugin.getKeyStoreLocation(), (String)HyadesUIPlugin.getInstance().getWorkspaceName());
    }
}

