/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui;

import com.ibm.icu.text.MessageFormat;
import java.net.URL;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.adapter.HyadesAdapterFactory;
import org.eclipse.hyades.ui.filters.internal.util.ScopeContainer;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.internal.util.ResourceBundleManager;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.hyades.ui.util.ILogger;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class HyadesUIPlugin
extends AbstractUIPlugin {
    private static final String KEYSTORE = "keystore.dat";
    public static final String EP_EDITOR_EXTENSIONS = "editorExtensions";
    public static final String EP_ANALYZER_EXTENSIONS = "analyzerExtensions";
    public static final String EP_REPORT_EXTENSIONS = "reportExtensions";
    public static final String EP_TYPE_DESCRIPTIONS = "typeDescriptions";
    public static final String EP_TYPE_VALIDATORS = "typeValidators";
    public static final String EP_SAMPLE_WIZARD = "sampleWizards";
    public static final String EP_NAVIGATOR_EXTENSIONS = "navigatorExtensions";
    public static final String PLUGIN_ID = "org.eclipse.hyades.ui";
    private static HyadesUIPlugin instance;
    private ILogger logger;
    private ResourceBundleManager resourceBundleManager;
    private ResourceBundle resourceBundle;
    private static String PREFERENCE_FILTER_SELECTION_KEY;
    private static String PREFERENCE_STRING_SEPARATOR;
    private static String PREFERENCE_STRING_VALUE_SEPARATOR;
    static /* synthetic */ Class class$0;

    static {
        PREFERENCE_FILTER_SELECTION_KEY = "filters.filterSelection";
        PREFERENCE_STRING_SEPARATOR = "\n";
        PREFERENCE_STRING_VALUE_SEPARATOR = ";";
    }

    public HyadesUIPlugin() {
        instance = this;
    }

    public static HyadesUIPlugin getInstance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        this.resourceBundleManager = new ResourceBundleManager();
        this.resourceBundleManager.add(this.getResourceBundle());
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)HyadesAdapterFactory.INSTANCE, (Class)clazz);
        super.start(context);
        Runnable operation = new Runnable(){

            public void run() {
                try {
                    HyadesUIImages.INSTANCE.initialize(new URL(HyadesUIPlugin.this.getBundle().getEntry("/"), "icons/full/"), HyadesUIPlugin.this.getImageRegistry());
                }
                catch (Exception e) {
                    HyadesUIPlugin.logError(e);
                }
            }
        };
        if (Display.getCurrent() == Display.getDefault()) {
            operation.run();
        } else {
            Display.getDefault().asyncExec(operation);
        }
        this.restoreFilterSelections();
    }

    public void stop(BundleContext context) throws Exception {
        this.storeFilterSelections();
        NavigatorExtensionUtil.disposeAll();
        this.resourceBundleManager.dispose();
        instance = null;
        this.savePluginPreferences();
        this.logger = null;
        Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)HyadesAdapterFactory.INSTANCE);
        HyadesAdapterFactory.INSTANCE.dispose();
        super.stop(context);
    }

    public static ILogger getLogger() {
        if (HyadesUIPlugin.instance.logger == null) {
            HyadesUIPlugin.instance.logger = new ILogger(){

                public void logError(Throwable throwable) {
                    this.logError(throwable);
                }

                public void logError(String text) {
                    this.logError(text);
                }

                public void logInfo(String text) {
                    this.logInfo(text);
                }
            };
        }
        return HyadesUIPlugin.instance.logger;
    }

    public static String getID() {
        return PLUGIN_ID;
    }

    public static void logError(Throwable throwable) {
        Status status = new Status(1, HyadesUIPlugin.getID(), 0, throwable.toString(), throwable);
        HyadesUIPlugin.getInstance().getLog().log((IStatus)status);
    }

    public static void logError(String text) {
        HyadesUIPlugin.logError(new Throwable(text));
    }

    public static void logInfo(String text) {
        Status status = new Status(3, HyadesUIPlugin.getID(), 0, text, new Throwable(text));
        HyadesUIPlugin.getInstance().getLog().log((IStatus)status);
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            try {
                this.resourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)PLUGIN_ID));
            }
            catch (Exception exception) {
                this.resourceBundle = null;
            }
        }
        return this.resourceBundle;
    }

    public static String getString(String key) {
        try {
            return HyadesUIPlugin.instance.resourceBundleManager.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getString(String key, String arg) {
        try {
            return HyadesUIPlugin.instance.resourceBundleManager.getString(key, arg);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getString(String key, String[] args) {
        try {
            return HyadesUIPlugin.instance.resourceBundleManager.getString(key, args);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public boolean openPerspectiveSwitchDialog(Shell shell, String perspectiveId, IPreferenceStore preferenceStore, String preferenceKey, String message) {
        if (this.isCurrentPerspective(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), perspectiveId)) {
            return false;
        }
        String perspectiveName = this.getPerspectiveLabel(perspectiveId);
        if (perspectiveName == null) {
            return false;
        }
        String preferenceValue = preferenceStore.getString(preferenceKey);
        if (preferenceValue == null || preferenceValue.length() == 0) {
            preferenceValue = "prompt";
            preferenceStore.setValue(preferenceKey, preferenceValue);
        }
        boolean saveAndChange = false;
        if ("prompt".equals(preferenceValue)) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)UIMessages._52, (String)MessageFormat.format((String)message, (Object[])new String[]{perspectiveName}), null, (boolean)false, (IPreferenceStore)preferenceStore, (String)preferenceKey);
            boolean bl = saveAndChange = dialog.getReturnCode() == 2;
        }
        if (!this.getContributions(perspectiveId)) {
            return false;
        }
        preferenceValue = preferenceStore.getString(preferenceKey);
        if ("always".equals(preferenceValue)) {
            return true;
        }
        return saveAndChange && !"never".equals(preferenceValue);
    }

    private boolean isCurrentPerspective(IWorkbenchWindow window, String perspectiveId) {
        IPerspectiveDescriptor perspectiveDescriptor;
        IWorkbenchPage page;
        boolean isCurrent = false;
        if (window != null && (page = window.getActivePage()) != null && (perspectiveDescriptor = page.getPerspective()) != null) {
            isCurrent = perspectiveId.equals(perspectiveDescriptor.getId());
        }
        return isCurrent;
    }

    private String getPerspectiveLabel(String perspectiveId) {
        IPerspectiveDescriptor newPerspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        if (newPerspective == null) {
            return null;
        }
        return newPerspective.getLabel();
    }

    private boolean getContributions(String perspectiveId) {
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor finalPersp = reg.findPerspectiveWithId(perspectiveId);
        if (finalPersp != null && finalPersp instanceof IPluginContribution) {
            HashSet enabledIds;
            IWorkbenchActivitySupport workbenchActivitySupport;
            IActivityManager activityManager;
            IIdentifier identifier;
            Set idActivities;
            IPluginContribution contribution = (IPluginContribution)finalPersp;
            if (contribution.getPluginId() != null && !(idActivities = (identifier = (activityManager = (workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport()).getActivityManager()).getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)contribution))).getActivityIds()).isEmpty() && (enabledIds = new HashSet(activityManager.getEnabledActivityIds())).addAll(idActivities)) {
                workbenchActivitySupport.setEnabledActivityIds(enabledIds);
            }
        } else {
            HyadesUIPlugin.logError("Unable to find perspective " + perspectiveId);
            return false;
        }
        return true;
    }

    public static String getKeyStoreLocation() {
        return Platform.getPluginStateLocation((Plugin)instance).append(KEYSTORE).toOSString();
    }

    public String getWorkspaceName() {
        IPath workspace = Platform.getLocation();
        int nr = workspace.segmentCount();
        return workspace.segment(nr - 1);
    }

    private void storeFilterSelections() {
        ScopeContainer scopeContainer = ScopeContainer.instance();
        StringBuffer filterSelectionStr = new StringBuffer();
        String[] scopes = scopeContainer.scopes();
        String selectedFilterName = null;
        int i = 0;
        while (i < scopes.length) {
            selectedFilterName = scopeContainer.getSelectedFilterName(scopes[i]);
            if (selectedFilterName != null) {
                filterSelectionStr.append(scopes[i]);
                filterSelectionStr.append(PREFERENCE_STRING_VALUE_SEPARATOR);
                filterSelectionStr.append(selectedFilterName);
                filterSelectionStr.append(PREFERENCE_STRING_SEPARATOR);
            }
            ++i;
        }
        filterSelectionStr.append(PREFERENCE_STRING_SEPARATOR);
        String[] viewers = scopeContainer.viewers();
        String selectedScope = null;
        int i2 = 0;
        while (i2 < viewers.length) {
            selectedScope = scopeContainer.getSelectedScope(viewers[i2]);
            if (selectedScope != null) {
                filterSelectionStr.append(viewers[i2]);
                filterSelectionStr.append(PREFERENCE_STRING_VALUE_SEPARATOR);
                filterSelectionStr.append(selectedScope);
                filterSelectionStr.append(PREFERENCE_STRING_SEPARATOR);
            }
            ++i2;
        }
        this.getPluginPreferences().setValue(PREFERENCE_FILTER_SELECTION_KEY, filterSelectionStr.toString());
    }

    private void restoreFilterSelections() {
        int sIdx;
        String filterSelectionStr = this.getPluginPreferences().getString(PREFERENCE_FILTER_SELECTION_KEY);
        if (filterSelectionStr == null || "".equals(filterSelectionStr)) {
            return;
        }
        ScopeContainer scopeContainer = ScopeContainer.instance();
        int idx = filterSelectionStr.indexOf(PREFERENCE_STRING_SEPARATOR);
        while (idx > 0) {
            String scopeSelectedFilterStr = filterSelectionStr.substring(0, idx);
            sIdx = scopeSelectedFilterStr.indexOf(PREFERENCE_STRING_VALUE_SEPARATOR);
            String scope = scopeSelectedFilterStr.substring(0, sIdx);
            String selectedFilter = scopeSelectedFilterStr.substring(sIdx + 1);
            scopeContainer.setSelectedFilterName(scope, selectedFilter);
            filterSelectionStr = filterSelectionStr.substring(idx + 1);
            idx = filterSelectionStr.indexOf(PREFERENCE_STRING_SEPARATOR);
        }
        filterSelectionStr = filterSelectionStr.substring(1);
        idx = filterSelectionStr.indexOf(PREFERENCE_STRING_SEPARATOR);
        while (idx >= 0) {
            String viewerSelectedScope = filterSelectionStr.substring(0, idx);
            sIdx = viewerSelectedScope.indexOf(PREFERENCE_STRING_VALUE_SEPARATOR);
            String viewer = viewerSelectedScope.substring(0, sIdx);
            String selectedScope = viewerSelectedScope.substring(sIdx + 1);
            scopeContainer.setSelectedScope(viewer, selectedScope);
            filterSelectionStr = filterSelectionStr.substring(idx + 1);
            idx = filterSelectionStr.indexOf(PREFERENCE_STRING_SEPARATOR);
        }
    }
}

