/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.filters.internal.dialogs;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.filters.IAdvancedTabAttributeSet;
import org.eclipse.hyades.ui.filters.IFilterAttribute;
import org.eclipse.hyades.ui.filters.internal.dialogs.FilterElement;
import org.eclipse.hyades.ui.filters.internal.dialogs.FilterElementSet;
import org.eclipse.hyades.ui.filters.internal.dialogs.FiltersTabUI;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class FiltersAdvancedUI
extends FiltersTabUI {
    private Table _table;
    private Button _addBtn;
    private Button _editBtn;
    private Button _removeBtn;
    private Composite result;
    private CheckboxTableViewer _tableViewer;
    public static IFilterAttribute[] _attributes;
    private FilterElementSet _filterElementSet;

    protected FiltersAdvancedUI(IAdvancedTabAttributeSet attributes) {
        _attributes = attributes.getAttributes();
    }

    public Control createControl(Composite parent) {
        this.result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        this.result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        this.result.setLayoutData((Object)data);
        Label _contentLabel = new Label(this.result, 0);
        _contentLabel.setText(UIMessages._85);
        data = new GridData();
        data.horizontalSpan = 2;
        _contentLabel.setLayoutData((Object)data);
        Composite tableGroup = new Composite(this.result, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        tableGroup.setLayout((Layout)layout);
        data = new GridData();
        data.heightHint = 250;
        data.widthHint = 400;
        tableGroup.setLayoutData((Object)data);
        this.initializeTable(tableGroup);
        Composite btnGroup = new Composite(this.result, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        btnGroup.setLayout((Layout)layout);
        btnGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite addGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        addGroup.setLayout((Layout)layout);
        addGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        this._addBtn = this.createModifyButton(addGroup, UIMessages._86, UIMessages._87);
        this._addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersAdvancedUI.this.addButtonPressed();
            }
        });
        this._editBtn = this.createModifyButton(addGroup, UIMessages._88, UIMessages._89);
        this._editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersAdvancedUI.this.editButtonPressed();
            }
        });
        this._removeBtn = this.createModifyButton(addGroup, UIMessages._90, UIMessages._91);
        this._removeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersAdvancedUI.this.removeButtonPressed();
            }
        });
        Composite moveGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        moveGroup.setLayout((Layout)layout);
        moveGroup.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn.setEnabled(false);
        this._removeBtn.setEnabled(false);
        return this.result;
    }

    private Button createModifyButton(Composite parent, String text, String toolTipText) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setToolTipText(toolTipText);
        button.setLayoutData((Object)GridUtil.createHorizontalFill());
        return button;
    }

    protected void initializeTable(Composite parent) {
        this.createTable(parent);
        this._tableViewer = new CheckboxTableViewer(this._table);
        this.createColumns();
        this._tableViewer.setContentProvider((IContentProvider)new FilterSetContentProvider());
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new FilterSetLabelProvider());
        this._tableViewer.setInput(new Object());
    }

    private void createTable(Composite parent) {
        this._table = new Table(parent, 68354);
        this._table.setLinesVisible(true);
        this._table.setLayoutData((Object)GridUtil.createFill());
        this._table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersAdvancedUI.this.tableSelect();
            }
        });
    }

    private void createColumns() {
        TableLayout layout = new TableLayout();
        this._table.setLayout((Layout)layout);
        this._table.setHeaderVisible(true);
        String[] headers = new String[]{UIMessages._82, UIMessages._83, UIMessages._84};
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnPixelData(120, true), new ColumnPixelData(70, true), new ColumnPixelData(130, true)};
        TableColumn[] columns = new TableColumn[headers.length];
        int i = 0;
        while (i < headers.length) {
            layout.addColumnData(layouts[i]);
            TableColumn tc = new TableColumn(this._table, 0, i);
            tc.setResizable(layouts[i].resizable);
            tc.setText(headers[i]);
            columns[i] = tc;
            ++i;
        }
    }

    public boolean storeValues(IPreferenceStore store, String preferenceProperty) {
        return true;
    }

    public boolean storeValues(IPreferenceStore store) {
        return true;
    }

    public Composite getControl() {
        return this.result;
    }

    protected void enableButtons() {
        int selection = this._table.getSelectionIndex();
        int selectionCount = this._table.getSelectionCount();
        this._removeBtn.setEnabled(this.getTableLength() > 0 && selection != -1);
        this._editBtn.setEnabled(this.getTableLength() > 0 && selection != -1 && selectionCount == 1);
    }

    protected void selectTableItem(Table table, int selection) {
        table.setFocus();
        table.setSelection(selection);
        table.showSelection();
    }

    private void showEditDialog(String title, FilterElement fe) {
        EditDialog dialog = fe != null ? new EditDialog(this.result.getShell(), title, fe.attribute(), fe.operator(), fe.value()) : new EditDialog(this.result.getShell(), title, null, null, null);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            if (fe != null) {
                fe.setAttribute(dialog.attribute());
                fe.setOperator(dialog.operator());
                fe.setValue(dialog.value());
                this._tableViewer.refresh();
            } else {
                this._filterElementSet.addFilterElement(new FilterElement(dialog.attribute(), dialog.operator(), dialog.value()));
                this._tableViewer.refresh();
                this.selectTableItem(this._table, this.getTableLength() - 1);
            }
        }
        this.validateValues();
    }

    private void validateValues() {
        int i = 0;
        while (i < this._filterElementSet.size()) {
            FilterElement fe = this._filterElementSet.filterElement(i);
            String errorMsg = fe.attribute().validate(fe.operator(), fe.value());
            if (errorMsg != null) {
                this.setError(errorMsg);
                return;
            }
            ++i;
        }
        this.noError();
    }

    private void addButtonPressed() {
        this.showEditDialog(UIMessages._101, null);
        this.enableButtons();
    }

    private void editButtonPressed() {
        int idx = this._table.getSelectionIndex();
        if (idx != -1) {
            FilterElement fe = this.getFilterElement(idx);
            this.showEditDialog(UIMessages._102, fe);
        }
    }

    private void removeButtonPressed() {
        int selection = this._table.getSelectionIndex();
        int[] indeces = this._table.getSelectionIndices();
        int i = 0;
        while (i < indeces.length) {
            this._filterElementSet.removeFilterElement(this._filterElementSet.filterElement(indeces[i]));
            ++i;
        }
        this._tableViewer.refresh();
        int size = this.getTableLength();
        if (size > 0) {
            if (selection > 0 && selection < size) {
                this.selectTableItem(this._table, selection - 1);
            } else {
                this.selectTableItem(this._table, 0);
            }
        }
        this.enableButtons();
        this.validateValues();
    }

    private void tableSelect() {
        this.enableButtons();
    }

    public String getTabName() {
        return UIMessages._81;
    }

    public Image getTabImage() {
        return HyadesUIImages.INSTANCE.getImage("view_filter_obj.gif");
    }

    private FilterElement getFilterElement(int idx) {
        return (FilterElement)this._tableViewer.getElementAt(idx);
    }

    private int getTableLength() {
        return this._filterElementSet.size();
    }

    private IFilterAttribute getAttributeFromString(String attributeStr) {
        int i = 0;
        while (i < _attributes.length) {
            if (_attributes[i].displayText().equals(attributeStr)) {
                return _attributes[i];
            }
            ++i;
        }
        return null;
    }

    private IFilterAttribute getAttributeFromID(String id) {
        int i = 0;
        while (i < _attributes.length) {
            if (_attributes[i].id().equals(id)) {
                return _attributes[i];
            }
            ++i;
        }
        return null;
    }

    public void initializeFrom(SimpleSearchQuery filter) {
        FilterElementSet filterElementSet = new FilterElementSet();
        if (filter.getWhereExpression() != null && filter.getWhereExpression() instanceof LogicalExpression) {
            LogicalExpression logicalExpression = (LogicalExpression)filter.getWhereExpression();
            EList filterElements = logicalExpression.getArguments();
            int i = 0;
            while (i < filterElements.size()) {
                IFilterAttribute filterAttribute;
                WhereExpression whereExpression = (WhereExpression)filterElements.get(i);
                String whereExpressionName = whereExpression.getName();
                int idx = whereExpressionName.indexOf(":");
                if (idx >= 0 && (filterAttribute = this.getAttributeFromID(whereExpressionName.substring(idx + 1))) != null) {
                    String feOperator = filterAttribute.getOperator(whereExpression);
                    String feValue = filterAttribute.getValue(whereExpression);
                    if (feOperator != null && feValue != null) {
                        filterElementSet.addFilterElement(new FilterElement(filterAttribute, feOperator, feValue));
                    }
                }
                ++i;
            }
        }
        this._filterElementSet = filterElementSet;
        this._tableViewer.refresh();
    }

    public SimpleSearchQuery performApply() {
        SimpleSearchQuery filter = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
        EList arguments = logicalExpression.getArguments();
        int i = 0;
        while (i < this._filterElementSet.size()) {
            FilterElement fe = this._filterElementSet.filterElement(i);
            WhereExpression whereExpression = fe.attribute().getWhereExpression(fe.operator(), fe.value());
            if (whereExpression != null) {
                whereExpression.setName(FiltersAdvancedUI.getWhereExpressionName(logicalExpression, fe.attribute()));
                arguments.add((Object)whereExpression);
            }
            ++i;
        }
        filter.setWhereExpression((WhereExpression)logicalExpression);
        return filter;
    }

    protected void selectItem(int item) {
        if (item >= 0 && item < this._table.getItemCount()) {
            this.selectTableItem(this._table, item);
        }
    }

    public static String getWhereExpressionName(LogicalExpression advancedLogicalExpression, IFilterAttribute filterAttribute) {
        return "AD" + advancedLogicalExpression.getArguments().size() + ":" + filterAttribute.id();
    }

    public class FilterSetLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            FilterElement fe = (FilterElement)element;
            if (columnIndex == 0) {
                return fe.attribute().displayText();
            }
            if (columnIndex == 1) {
                return fe.operator();
            }
            if (columnIndex == 2) {
                return fe.value();
            }
            return null;
        }

        public void dispose() {
        }
    }

    public class FilterSetContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (FiltersAdvancedUI.this._filterElementSet != null) {
                return FiltersAdvancedUI.this._filterElementSet.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class EditDialog
    extends Dialog {
        private IFilterAttribute _attribute;
        private String _operator;
        private String _value;
        private Combo _AttributeText;
        private Combo _OperatorText;
        private Text _ValueText;
        private String _title;

        public EditDialog(Shell shell, String title, IFilterAttribute attribute, String operator, String value) {
            super(shell);
            this._attribute = attribute;
            this._operator = operator;
            this._value = value;
            this._title = title;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this._title);
        }

        public IFilterAttribute attribute() {
            return this._attribute;
        }

        public String operator() {
            return this._operator;
        }

        public String value() {
            return this._value;
        }

        private void attributeUpdate(IFilterAttribute attribute) {
            this._ValueText.setText(attribute.defaultValue());
            this._OperatorText.removeAll();
            String[] operators = attribute.operators();
            int i = 0;
            while (i < operators.length) {
                this._OperatorText.add(operators[i]);
                ++i;
            }
            this._OperatorText.select(0);
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            result.setLayout((Layout)layout);
            GridData data = GridUtil.createFill();
            data.widthHint = 400;
            result.setLayoutData((Object)data);
            Label label = new Label(result, 0);
            label.setText(UIMessages._82);
            this._AttributeText = new Combo(result, 2056);
            this._AttributeText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._AttributeText.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ EditDialog this$1;
                {
                    this.this$1 = editDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    EditDialog.access$1(this.this$1, FiltersAdvancedUI.access$1(EditDialog.access$2(this.this$1), EditDialog.access$0(this.this$1).getText().trim()));
                }
            });
            int i = 0;
            while (i < _attributes.length) {
                this._AttributeText.add(_attributes[i].displayText());
                ++i;
            }
            label = new Label(result, 0);
            label.setText(UIMessages._83);
            this._OperatorText = new Combo(result, 2056);
            this._OperatorText.setLayoutData((Object)GridUtil.createHorizontalFill());
            label = new Label(result, 0);
            label.setText(UIMessages._84);
            this._ValueText = new Text(result, 2048);
            this._ValueText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._AttributeText.select(0);
            if (this._attribute != null) {
                this._AttributeText.setText(this._attribute.displayText());
            }
            this.attributeUpdate(FiltersAdvancedUI.this.getAttributeFromString(this._AttributeText.getText().trim()));
            if (this._operator != null) {
                this._OperatorText.setText(this._operator);
            }
            if (this._value != null) {
                this._ValueText.setText(this._value);
            }
            this._AttributeText.setFocus();
            this.setContextHelpId((Control)result);
            return result;
        }

        protected void okPressed() {
            this._attribute = FiltersAdvancedUI.this.getAttributeFromString(this._AttributeText.getText().trim());
            this._operator = this._OperatorText.getText();
            this._value = this._ValueText.getText();
            super.okPressed();
        }

        private void setContextHelpId(Control control) {
        }

        static /* synthetic */ Combo access$0(EditDialog editDialog) {
            return editDialog._AttributeText;
        }

        static /* synthetic */ void access$1(EditDialog editDialog, IFilterAttribute iFilterAttribute) {
            editDialog.attributeUpdate(iFilterAttribute);
        }

        static /* synthetic */ FiltersAdvancedUI access$2(EditDialog editDialog) {
            return editDialog.FiltersAdvancedUI.this;
        }
    }
}

