/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.filters.internal.dialogs;

import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.filters.internal.dialogs.FilterTypeDialog;
import org.eclipse.hyades.ui.filters.internal.dialogs.FilterUIUtil;
import org.eclipse.hyades.ui.filters.internal.dialogs.FiltersDialog;
import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.internal.filters.FilterTypesManager;
import org.eclipse.hyades.ui.internal.filters.IFilterType;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class FiltersEditDialog
extends Dialog {
    private TableViewer _filtersListViewer;
    private FilterInformationManager _fi;
    private Button _newButton;
    private Button _removeButton;
    private Button _editButton;
    private String _selectedFilterName = null;

    protected FiltersEditDialog(FilterInformationManager fi) {
        super(Display.getDefault().getActiveShell());
        this._fi = fi;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(UIMessages._79);
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageLabel(composite);
        Composite listComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        listComposite.setLayout((Layout)layout);
        this._filtersListViewer = new TableViewer(listComposite, 2050);
        GridData data = new GridData(256);
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 200;
        data.widthHint = 200;
        this._filtersListViewer.getTable().setLayoutData((Object)data);
        this._filtersListViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersEditDialog.this.tableSelect();
            }
        });
        this._filtersListViewer.setLabelProvider((IBaseLabelProvider)new FilterSetLabelProvider());
        this._filtersListViewer.setContentProvider((IContentProvider)new FilterSetContentProvider());
        this._filtersListViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        this._filtersListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this._filtersListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
        this.createButtonsControl(composite);
        this._filtersListViewer.setInput((Object)this._fi);
        this._filtersListViewer.setSorter(null);
        this._filtersListViewer.refresh();
        this.setInitialSelection();
        this.enableButtons();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, String.valueOf(HyadesUIPlugin.getID()) + ".mgrproftr");
        return composite;
    }

    private Label createMessageLabel(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(UIMessages._103);
        return label;
    }

    private Control createButtonsControl(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(258);
        data.grabExcessHorizontalSpace = true;
        buttonComposite.setLayoutData((Object)data);
        this._newButton = this.createModifyButton(buttonComposite, UIMessages._104);
        this._newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersEditDialog.this.createFilterSet();
            }
        });
        this._editButton = this.createModifyButton(buttonComposite, UIMessages._105);
        this._editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersEditDialog.this.editFilterSet();
            }
        });
        this._removeButton = this.createModifyButton(buttonComposite, UIMessages._106);
        this._removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersEditDialog.this.removeFilterSets();
            }
        });
        this._newButton.setEnabled(true);
        return buttonComposite;
    }

    private Button createModifyButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        GridData data = new GridData(256);
        button.setLayoutData((Object)data);
        button.setText(text);
        return button;
    }

    private void createFilterSet() {
        FilterTypeDialog filterTypeDialog = FilterUIUtil.getFiltersTypeDialog(this._fi);
        filterTypeDialog.open();
        IFilterType type = filterTypeDialog.selectedFilterType();
        if (type == null) {
            return;
        }
        FilterQueries fq = this._fi.createFilterQueries(type.id());
        FiltersDialog filtersDialog = FilterUIUtil.getFiltersDialog(fq, this._fi, 0);
        filtersDialog.open();
        if (filtersDialog.getReturnCode() == 0) {
            this._fi.addFilter(fq);
            this._filtersListViewer.refresh();
            this.setSelectedFilter(fq.name());
            this.enableButtons();
        }
    }

    private void editFilterSet() {
        int idx = this._filtersListViewer.getTable().getSelectionIndex();
        if (idx != -1) {
            FilterQueries sel = this._fi.filter(idx);
            FilterQueries copy = sel.copy();
            FiltersDialog filtersDialog = FilterUIUtil.getFiltersDialog(copy, this._fi, 0);
            filtersDialog.open();
            if (filtersDialog.getReturnCode() == 0) {
                this._fi.removeFilter(sel);
                this._fi.addFilter(copy);
                this._filtersListViewer.refresh();
                this.setSelectedFilter(copy.name());
            }
        }
    }

    private void removeFilterSets() {
        int selection = this._filtersListViewer.getTable().getSelectionIndex();
        this._fi.removeFilters(this._filtersListViewer.getTable().getSelectionIndices());
        this._filtersListViewer.refresh();
        int size = this._fi.size();
        if (size > 0) {
            if (selection > 0 && selection < size) {
                this.selectTableItem(this._filtersListViewer.getTable(), selection - 1);
            } else {
                this.selectTableItem(this._filtersListViewer.getTable(), 0);
            }
        }
        this.enableButtons();
    }

    protected void selectTableItem(Table table, int selection) {
        table.setFocus();
        table.setSelection(selection);
        table.showSelection();
    }

    protected void enableButtons() {
        int selection = this._filtersListViewer.getTable().getSelectionIndex();
        int selectionCount = this._filtersListViewer.getTable().getSelectionCount();
        this._removeButton.setEnabled(this._fi.size() > 0 && selection != -1);
        this._editButton.setEnabled(this._fi.size() > 0 && selection != -1 && selectionCount == 1);
    }

    private void tableSelect() {
        this.enableButtons();
    }

    protected void okPressed() {
        int selection = this._filtersListViewer.getTable().getSelectionIndex();
        super.okPressed();
        this._fi.save();
        this._selectedFilterName = selection >= 0 ? this._fi.filter(selection).name() : null;
    }

    protected void cancelPressed() {
        super.cancelPressed();
        this._fi.restore();
    }

    public String selectedFilterName() {
        return this._selectedFilterName;
    }

    public void selectedFilterName(String selectedFilterName) {
        this._selectedFilterName = selectedFilterName;
    }

    private void setInitialSelection() {
        this.setSelectedFilter(this._selectedFilterName);
    }

    private void setSelectedFilter(String name) {
        if (name != null) {
            int i = 0;
            while (i < this._fi.size()) {
                if (name.equals(this._fi.filter(i).name())) {
                    this.selectTableItem(this._filtersListViewer.getTable(), i);
                    return;
                }
                ++i;
            }
        }
    }

    public class FilterSetLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            return ((FilterQueries)element).name();
        }

        public Image getImage(Object element) {
            ImageDescriptor icon = FilterTypesManager.instance().getFilterType(((FilterQueries)element).type()).icon();
            if (icon != null) {
                return icon.createImage();
            }
            return null;
        }

        public void dispose() {
        }
    }

    public class FilterSetContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (FiltersEditDialog.this._fi != null && FiltersEditDialog.this._fi == inputElement) {
                return FiltersEditDialog.this._fi.getFiltersArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

