/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.filters.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.filters.internal.util.FilterResourceFileHandler;
import org.eclipse.hyades.ui.internal.util.UIMessages;

public class FilterResourceHandler
extends FilterResourceFileHandler {
    private static String TYPE_DIR = "/filterresources/";
    private static String TYPE_FILE = ".filtxmi";
    private static String FILTERS_FILE_NAME = "filters";
    private static String DEFAULT_FILTER_KEY_PREFIX = "org.eclipse.hyades.ui.filters.internal.defaultFilters.";
    private static FilterResourceHandler _instance = null;
    private static List _filtersToAddOnInstanceLoad = null;
    private static List _keysAddToPreferencesOnInstanceLoad = null;

    protected FilterResourceHandler(URI uri) {
        super(uri);
    }

    public static FilterResourceHandler instance() {
        if (_instance == null) {
            _instance = new FilterResourceHandler(FilterResourceHandler.createMasterListFileURI());
            FilterResourceHandler.addFiltersOnInstanceLoad(null);
            FilterResourceHandler.defaultFiltersAddedForKey(null, true);
        }
        return _instance;
    }

    public static URI createMasterListFileURI() {
        String fileName = String.valueOf(HyadesUIPlugin.getInstance().getStateLocation().toString()) + TYPE_DIR + FILTERS_FILE_NAME + TYPE_FILE;
        return URI.createFileURI((String)fileName);
    }

    public FilterQueries createFilterQueries(String type) {
        return this.createFilterQueries(type, null, null);
    }

    public FilterQueries createFilterQueries(String type, SimpleSearchQuery standardQuery, SimpleSearchQuery advancedQuery) {
        return FilterResourceHandler.createFilterQueries(type, this.getNewFilterSetName(), standardQuery, advancedQuery);
    }

    public static FilterQueries createFilterQueries(String type, String name, SimpleSearchQuery standardQuery, SimpleSearchQuery advancedQuery) {
        FilterQueries fq = new FilterQueries();
        fq.type(type);
        fq.name(name);
        if (standardQuery != null) {
            fq.standard(standardQuery);
        } else {
            fq.standard(ExtensionsFactory.eINSTANCE.createSimpleSearchQuery());
        }
        if (advancedQuery != null) {
            fq.advanced(advancedQuery);
        } else {
            fq.advanced(ExtensionsFactory.eINSTANCE.createSimpleSearchQuery());
        }
        return fq;
    }

    private String getNewFilterSetName() {
        String defaultName = UIMessages._110;
        int i = 1;
        String name = defaultName;
        while (this.filter(name) != null) {
            name = String.valueOf(defaultName) + " (" + i + ")";
            ++i;
        }
        return name;
    }

    public static synchronized void addFiltersOnInstanceLoad(List filters) {
        if (_filtersToAddOnInstanceLoad == null) {
            _filtersToAddOnInstanceLoad = new ArrayList();
        }
        if (filters != null) {
            _filtersToAddOnInstanceLoad.addAll(filters);
        }
        if (_instance == null) {
            return;
        }
        int i = 0;
        while (i < _filtersToAddOnInstanceLoad.size()) {
            _instance.addFilter((FilterQueries)_filtersToAddOnInstanceLoad.get(i));
            ++i;
        }
        _instance.save();
        _filtersToAddOnInstanceLoad.clear();
    }

    public static synchronized boolean isDefaultFiltersAddedForKey(String key) {
        if (HyadesUIPlugin.getInstance().getPluginPreferences().getBoolean(String.valueOf(DEFAULT_FILTER_KEY_PREFIX) + key)) {
            return true;
        }
        if (_keysAddToPreferencesOnInstanceLoad != null) {
            int i = 0;
            while (i < _keysAddToPreferencesOnInstanceLoad.size()) {
                if (key.equals(_keysAddToPreferencesOnInstanceLoad.get(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static synchronized void defaultFiltersAddedForKey(String key, boolean added) {
        if (_keysAddToPreferencesOnInstanceLoad == null) {
            _keysAddToPreferencesOnInstanceLoad = new ArrayList();
        }
        if (key != null) {
            if (added) {
                _keysAddToPreferencesOnInstanceLoad.add(String.valueOf(DEFAULT_FILTER_KEY_PREFIX) + key);
            } else {
                _keysAddToPreferencesOnInstanceLoad.remove(String.valueOf(DEFAULT_FILTER_KEY_PREFIX) + key);
                HyadesUIPlugin.getInstance().getPluginPreferences().setValue(String.valueOf(DEFAULT_FILTER_KEY_PREFIX) + key, false);
                HyadesUIPlugin.getInstance().savePluginPreferences();
            }
        }
        if (_instance == null) {
            return;
        }
        int i = 0;
        while (i < _keysAddToPreferencesOnInstanceLoad.size()) {
            HyadesUIPlugin.getInstance().getPluginPreferences().setValue((String)_keysAddToPreferencesOnInstanceLoad.get(i), true);
            ++i;
        }
        HyadesUIPlugin.getInstance().savePluginPreferences();
        _keysAddToPreferencesOnInstanceLoad.clear();
    }
}

