/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.action;

import java.util.Set;
import org.eclipse.hyades.ui.internal.extension.INavigatorLayout;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;

public class LayoutAction
extends Action {
    private INavigator _navigator;
    private INavigatorLayout _layout;
    private ImageDescriptor _imageDescriptor;
    private IPreferenceStore _store;
    private String _preferenceKey;
    private int _preferenceValue;

    public LayoutAction(INavigator navigator, INavigatorLayout layout, String label, ImageDescriptor imageDescriptor, IPreferenceStore store, String preferenceKey, int preferenceValue) {
        super(label, 8);
        this._navigator = navigator;
        this._layout = layout;
        this._imageDescriptor = imageDescriptor;
        this._store = store;
        this._preferenceKey = preferenceKey;
        this._preferenceValue = preferenceValue;
    }

    public ImageDescriptor getImageDescriptor() {
        return this._imageDescriptor;
    }

    public INavigatorLayout getLayout() {
        return this._layout;
    }

    public void run() {
        if (this.isChecked() && this._navigator.getLayout() != this._layout) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    Tree tree = ((TreeViewer)LayoutAction.this._navigator.getViewer()).getTree();
                    tree.setRedraw(false);
                    Set visible = UIUtil.getVisibleViewerNodes((TreeViewer)LayoutAction.this._navigator.getViewer());
                    LayoutAction.this._navigator.setLayout(LayoutAction.this._layout);
                    LayoutAction.this.updatePreferences();
                    UIUtil.setVisibleViewerNodes((TreeViewer)LayoutAction.this._navigator.getViewer(), visible);
                    tree.setRedraw(true);
                }
            });
        }
    }

    private void updatePreferences() {
        this._store.setValue(this._preferenceKey, this._preferenceValue);
    }
}

