/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.classloader;

import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.hyades.ui.internal.classloader.AbstractClassLoader;
import org.eclipse.hyades.ui.internal.util.FileUtil;

public class FileClassLoader
extends AbstractClassLoader {
    private String fileDir;

    public FileClassLoader(String fileDir) {
        this.fileDir = fileDir;
    }

    public FileClassLoader(ClassLoader parent, String fileDir) {
        super(parent);
        this.fileDir = fileDir;
    }

    protected String getFileDir() {
        return this.fileDir;
    }

    protected byte[] loadFileBytes(String fileName) {
        if (fileName == null) {
            return null;
        }
        try {
            byte[] byArray;
            block6: {
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(fileName);
                    byte[] result = new byte[((InputStream)inputStream).available()];
                    ((InputStream)inputStream).read(result);
                    byArray = result;
                    Object var4_5 = null;
                    if (inputStream == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    if (inputStream != null) {
                        ((InputStream)inputStream).close();
                    }
                    throw throwable;
                }
                ((InputStream)inputStream).close();
            }
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected byte[] loadClassBytes(String className, String fileDir) {
        if (className == null) {
            return null;
        }
        className = this.formatClassName(className);
        String fileName = null;
        fileName = fileDir != null ? FileUtil.appendPath(fileDir, className) : className;
        return this.loadFileBytes(fileName);
    }

    protected byte[] loadClassBytes(String className) {
        return this.loadClassBytes(className, this.fileDir);
    }
}

