/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.util.IDisposable;

class AssociationDescriptorEntry
implements IDisposable {
    private String type;
    private Set typedAssociationDescriptors;
    private List commonAssociationDescriptors;
    private Set avoidedAssociationDescriptors;
    private IAssociationDescriptor defaultAssociationDescriptor;

    public AssociationDescriptorEntry(List commonAssociationDescriptors, String type) {
        this.type = type;
        this.commonAssociationDescriptors = commonAssociationDescriptors;
        this.typedAssociationDescriptors = new HashSet();
        this.avoidedAssociationDescriptors = new HashSet();
    }

    public void dispose() {
        this.commonAssociationDescriptors = null;
        this.defaultAssociationDescriptor = null;
        this.avoidedAssociationDescriptors.clear();
    }

    public String getType() {
        return this.type;
    }

    public boolean addTypedAssociationDescriptor(IAssociationDescriptor associationDescriptor) {
        if (associationDescriptor == null) {
            return false;
        }
        this.avoidedAssociationDescriptors.remove(associationDescriptor);
        return this.typedAssociationDescriptors.add(associationDescriptor);
    }

    public boolean removeTypedAssociationDescriptor(IAssociationDescriptor associationDescriptor) {
        if (associationDescriptor == null) {
            return false;
        }
        this.avoidedAssociationDescriptors.remove(associationDescriptor);
        this.typedAssociationDescriptors.remove(associationDescriptor);
        if (this.defaultAssociationDescriptor == associationDescriptor) {
            this.defaultAssociationDescriptor = null;
        }
        return true;
    }

    public void removeAllTypedAssociationDescriptor() {
        if (this.typedAssociationDescriptors.contains(this.defaultAssociationDescriptor)) {
            this.defaultAssociationDescriptor = null;
        }
        this.avoidedAssociationDescriptors.clear();
        this.typedAssociationDescriptors.clear();
    }

    protected Set getTypedAssociationDescriptor() {
        return Collections.unmodifiableSet(this.typedAssociationDescriptors);
    }

    public IAssociationDescriptor[] getAssociationDescriptors() {
        ArrayList<IAssociationDescriptor> arrayList = new ArrayList<IAssociationDescriptor>(this.typedAssociationDescriptors);
        arrayList.addAll(this.commonAssociationDescriptors);
        if (arrayList.isEmpty()) {
            return new IAssociationDescriptor[0];
        }
        arrayList.removeAll(this.avoidedAssociationDescriptors);
        IAssociationDescriptor associationDescriptor = this.getDefault();
        if (associationDescriptor != null) {
            arrayList.remove(associationDescriptor);
            arrayList.add(0, associationDescriptor);
        }
        return arrayList.toArray(new IAssociationDescriptor[arrayList.size()]);
    }

    public void setDefault(IAssociationDescriptor associationDescriptor) {
        if (associationDescriptor.applyTo(this.type) && !this.avoidedAssociationDescriptors.contains(associationDescriptor)) {
            this.defaultAssociationDescriptor = associationDescriptor;
        }
    }

    public IAssociationDescriptor getDefault() {
        if (this.defaultAssociationDescriptor == null || !this.defaultAssociationDescriptor.applyTo(this.type) || this.avoidedAssociationDescriptors.contains(this.defaultAssociationDescriptor)) {
            IAssociationDescriptor descriptor;
            this.defaultAssociationDescriptor = null;
            Iterator i = this.typedAssociationDescriptors.iterator();
            while (i.hasNext()) {
                descriptor = (IAssociationDescriptor)i.next();
                if (this.avoidedAssociationDescriptors.contains(descriptor)) continue;
                this.defaultAssociationDescriptor = descriptor;
                return descriptor;
            }
            i = this.commonAssociationDescriptors.iterator();
            while (i.hasNext()) {
                descriptor = (IAssociationDescriptor)i.next();
                if (this.avoidedAssociationDescriptors.contains(descriptor)) continue;
                this.defaultAssociationDescriptor = descriptor;
                return descriptor;
            }
        }
        return this.defaultAssociationDescriptor;
    }

    public boolean addToAvoidedSet(IAssociationDescriptor associationDescriptor) {
        if (associationDescriptor == null || !associationDescriptor.applyTo(this.type)) {
            return false;
        }
        if (this.avoidedAssociationDescriptors.add(associationDescriptor)) {
            if (this.defaultAssociationDescriptor == associationDescriptor) {
                this.defaultAssociationDescriptor = null;
            }
            return true;
        }
        return false;
    }

    public boolean removeFromAvoidedSet(IAssociationDescriptor associationDescriptor) {
        if (associationDescriptor == null || !associationDescriptor.applyTo(this.type)) {
            return false;
        }
        return this.avoidedAssociationDescriptors.remove(associationDescriptor);
    }

    public void removeAllFromAvoidedSet() {
        this.avoidedAssociationDescriptors.clear();
    }

    public Set avoidedAssociationDescriptors() {
        return Collections.unmodifiableSet(this.avoidedAssociationDescriptors);
    }
}

