/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.filters;

import com.ibm.icu.text.Collator;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.ui.filters.IAdvancedTabAttributeSet;
import org.eclipse.hyades.ui.filters.internal.util.FilterType;
import org.eclipse.hyades.ui.internal.filters.IFilterType;
import org.eclipse.jface.resource.ImageDescriptor;

public class FilterTypesManager {
    private static FilterTypesManager instance;
    private Map filterTypes;
    private Map filterScopes;
    protected final String FILTER_TYPES_EXTENTION_POINT = "filterTypes";

    protected FilterTypesManager() {
    }

    public static FilterTypesManager instance() {
        if (instance == null) {
            instance = new FilterTypesManager();
        }
        return instance;
    }

    public IFilterType[] getFilterTypes(String[] scope) {
        if (this.filterTypes == null) {
            this.initialize();
        }
        Vector filterTypesV = new Vector();
        int i = 0;
        while (i < scope.length) {
            Vector filterTypesVi = (Vector)this.filterScopes.get(scope[i]);
            if (filterTypesVi != null) {
                int j = 0;
                while (j < filterTypesVi.size()) {
                    if (!filterTypesV.contains(filterTypesVi.elementAt(j))) {
                        filterTypesV.addElement(filterTypesVi.elementAt(j));
                    }
                    ++j;
                }
            }
            ++i;
        }
        IFilterType[] iFilterTypes = new IFilterType[filterTypesV.size()];
        filterTypesV.toArray(iFilterTypes);
        return iFilterTypes;
    }

    public IFilterType getFilterType(String id) {
        if (this.filterTypes == null) {
            this.initialize();
        }
        return (IFilterType)this.filterTypes.get(id);
    }

    private void initialize() {
        this.filterTypes = new HashMap();
        this.filterScopes = new HashMap();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.hyades.ui", "filterTypes");
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement elem = elements[i];
                String id = elem.getAttribute("id");
                String name = elem.getAttribute("name");
                if (id != null && name != null) {
                    String iconPath = elem.getAttribute("icon");
                    ImageDescriptor icon = null;
                    if (iconPath != null) {
                        try {
                            URL pluginInstallUrl = Platform.getBundle((String)elem.getDeclaringExtension().getNamespace()).getEntry("/");
                            icon = ImageDescriptor.createFromURL((URL)new URL(pluginInstallUrl + iconPath));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    String description = elem.getAttribute("description");
                    FiltersStandardTabUI standardTabUI = null;
                    IAdvancedTabAttributeSet advancedTabAttributeSet = null;
                    try {
                        if (!"".equals(elem.getAttribute("standardTabUI")) && elem.getAttribute("standardTabUI") != null) {
                            standardTabUI = (FiltersStandardTabUI)elem.createExecutableExtension("standardTabUI");
                        }
                        if (!"".equals(elem.getAttribute("advancedAttributes")) && elem.getAttribute("advancedAttributes") != null) {
                            advancedTabAttributeSet = (IAdvancedTabAttributeSet)elem.createExecutableExtension("advancedAttributes");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    IConfigurationElement[] appliesToElems = elem.getChildren("appliesTo");
                    Vector<String> scopesV = new Vector<String>();
                    int k = 0;
                    while (k < appliesToElems.length) {
                        scopesV.addElement(appliesToElems[k].getAttribute("filterScope"));
                        ++k;
                    }
                    String[] scope = new String[scopesV.size()];
                    scopesV.toArray(scope);
                    if (standardTabUI != null || advancedTabAttributeSet != null) {
                        FilterType filterType = new FilterType(id, name, icon, description, standardTabUI, advancedTabAttributeSet, scope);
                        this.filterTypes.put(filterType.id(), filterType);
                        int j = 0;
                        while (j < filterType.scope().length) {
                            Vector<FilterType> filterTypesV = (Vector<FilterType>)this.filterScopes.get(filterType.scope()[j]);
                            if (filterTypesV != null) {
                                filterTypesV.addElement(filterType);
                            } else {
                                filterTypesV = new Vector<FilterType>();
                                filterTypesV.addElement(filterType);
                                this.filterScopes.put(filterType.scope()[j], filterTypesV);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    public static String firstScopeIntersection(String[] scopeSorted, String[] scopeOther) {
        int i = 0;
        while (i < scopeOther.length) {
            if (Arrays.binarySearch(scopeSorted, scopeOther[i], new Comparator(){

                public int compare(Object a, Object b) {
                    String str1 = (String)a;
                    String str2 = (String)b;
                    if (str1 == null) {
                        str1 = "";
                    }
                    if (str2 == null) {
                        str2 = "";
                    }
                    return Collator.getInstance().compare(str1, str2);
                }
            }) >= 0) {
                return scopeOther[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean scopesHaveIntersection(String[] scopeSorted, String[] scopeOther) {
        return FilterTypesManager.firstScopeIntersection(scopeSorted, scopeOther) != null;
    }
}

