/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.filters;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;

public class ModelUtils {
    public static BinaryExpression createBinaryExpression(EStructuralFeature feature, RelationalOperators operator, String value, boolean caseInsensitive) {
        String[] values = new String[]{value};
        return ModelUtils.createBinaryExpression(feature, operator, values, caseInsensitive);
    }

    public static BinaryExpression createBinaryExpression(EStructuralFeature feature, RelationalOperators operator, String[] values, boolean caseInsensitive) {
        BinaryExpression binaryExpression = ExtensionsFactory.eINSTANCE.createBinaryExpression();
        SimpleOperand leftOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        leftOperand.setFeature(feature);
        binaryExpression.setLeftOperand((Operand)leftOperand);
        binaryExpression.setOperator(operator);
        int i = 0;
        while (i < values.length) {
            SimpleOperand rightOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
            if (feature instanceof EAttribute) {
                rightOperand.setValueType(((EAttribute)feature).getEAttributeType());
            }
            rightOperand.setValue((Object)values[i]);
            binaryExpression.getRightOperands().add((Object)rightOperand);
            ++i;
        }
        binaryExpression.setCaseInsensitive(caseInsensitive);
        return binaryExpression;
    }
}

