/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator;

import com.ibm.icu.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.ui.internal.navigator.ITreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigatorFrameSource;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.IFrameSource;
import org.eclipse.ui.views.framelist.TreeFrame;

public abstract class TreeNavigator
extends Navigator
implements ITreeNavigator,
IDoubleClickListener,
IPropertyChangeListener {
    protected static final String SET_WORKING_SET = "WORKING_SET";
    protected static final String TAG_FRAME = "FRAME";
    protected static final String TAG_EXPAND_STATE = "EXPAND_STATE";
    private FrameList frameList;
    private ResourceWorkingSetFilter workingSetFilter = this.createWorkingSetFilter();

    public TreeNavigator(String navigatorID) {
        super(navigatorID);
        this.getPlugin().getWorkbench().getWorkingSetManager().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        this.frameList = null;
        this.workingSetFilter = null;
        this.getViewer().removeDoubleClickListener((IDoubleClickListener)this);
        this.getPlugin().getWorkbench().getWorkingSetManager().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected ResourceWorkingSetFilter createWorkingSetFilter() {
        return new ResourceWorkingSetFilter();
    }

    protected ResourceWorkingSetFilter getWorkingSetFilter() {
        return this.workingSetFilter;
    }

    public TreeViewer getTreeViewer() {
        return (TreeViewer)this.getViewer();
    }

    protected void loadSettings() {
        super.loadSettings();
        this.initWorkingSet();
    }

    protected void initWorkingSet() {
        IWorkingSetManager workingSetManager;
        IWorkingSet workingSet;
        ResourceWorkingSetFilter workingSetFilter = this.getWorkingSetFilter();
        if (workingSetFilter == null) {
            return;
        }
        String workingSetName = this.getSettings().get(SET_WORKING_SET);
        if (workingSetName != null && !workingSetName.equals("") && (workingSet = (workingSetManager = this.getPlugin().getWorkbench().getWorkingSetManager()).getWorkingSet(workingSetName)) != null) {
            workingSetFilter.setWorkingSet(workingSet);
        }
    }

    protected StructuredViewer createViewer(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent, 770);
        treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        if (this.getWorkingSetFilter() != null) {
            treeViewer.addFilter((ViewerFilter)this.getWorkingSetFilter());
        }
        this.adjustTreeViewer(treeViewer);
        return treeViewer;
    }

    protected void adjustTreeViewer(TreeViewer treeViewer) {
    }

    public void doubleClick(DoubleClickEvent event) {
        if (event.getViewer() == this.getTreeViewer()) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object element = selection.getFirstElement();
            if (this.getTreeViewer().isExpandable(element)) {
                this.getTreeViewer().setExpandedState(element, !this.getTreeViewer().getExpandedState(element));
            }
        }
    }

    protected void loadMemento(IMemento memento) {
        this.loadFrame(memento);
        super.loadMemento(memento);
        this.loadExpandState(memento);
    }

    public void saveState(IMemento memento) {
        this.saveFrame(memento);
        super.saveState(memento);
        this.saveExpandState(memento);
    }

    protected boolean loadFrame(IMemento memento) {
        FrameList frameList = this.getFrameList();
        if (frameList == null) {
            return false;
        }
        IMemento frameMemento = memento.getChild(TAG_FRAME);
        if (frameMemento == null) {
            return false;
        }
        TreeFrame frame = new TreeFrame((AbstractTreeViewer)this.getTreeViewer());
        frame.restoreState(frameMemento);
        if (frame.getInput() == null) {
            return false;
        }
        this.getTreeViewer().getTree().deselectAll();
        this.getTreeViewer().setSelection((ISelection)new StructuredSelection(frame.getInput()));
        IStructuredSelection structuredSelection = this.getStructuredSelection();
        if (!structuredSelection.isEmpty()) {
            frame.setInput(structuredSelection.getFirstElement());
        }
        frame.setName(this.getFrameName(frame.getInput()));
        frame.setToolTipText(this.getFrameToolTipText(frame.getInput()));
        frameList.gotoFrame((Frame)frame);
        return true;
    }

    protected void loadExpandState(IMemento memento) {
        IMemento expandedMemento = memento.getChild(TAG_EXPAND_STATE);
        if (expandedMemento == null) {
            return;
        }
        List expanded = this.loadElements(expandedMemento);
        if (!expanded.isEmpty()) {
            ((TreeViewer)this.getViewer()).setExpandedElements(expanded.toArray());
        }
    }

    protected boolean saveFrame(IMemento memento) {
        FrameList frameList = this.getFrameList();
        if (frameList == null) {
            return false;
        }
        if (frameList.getCurrentIndex() == 0) {
            return false;
        }
        TreeFrame currentFrame = (TreeFrame)frameList.getCurrentFrame();
        IMemento frameMemento = memento.createChild(TAG_FRAME);
        currentFrame.saveState(frameMemento);
        return true;
    }

    protected void saveExpandState(IMemento memento) {
        IStructuredSelection structuredSelection = this.convertFromViewer((ISelection)new StructuredSelection(((TreeViewer)this.getViewer()).getExpandedElements()));
        IMemento expandedMemento = memento.createChild(TAG_EXPAND_STATE);
        Iterator i = structuredSelection.iterator();
        while (i.hasNext()) {
            this.saveElement(expandedMemento, i.next());
        }
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        ResourceWorkingSetFilter workingSetFilter = this.getWorkingSetFilter();
        if (workingSetFilter == null) {
            return;
        }
        TreeViewer treeViewer = (TreeViewer)this.getViewer();
        Object[] expanded = treeViewer.getExpandedElements();
        ISelection selection = treeViewer.getSelection();
        workingSetFilter.setWorkingSet(workingSet);
        if (workingSet != null) {
            this.getSettings().put(SET_WORKING_SET, workingSet.getName());
        } else {
            this.getSettings().put(SET_WORKING_SET, "");
        }
        this.updateTitle();
        treeViewer.refresh();
        treeViewer.setExpandedElements(expanded);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            treeViewer.reveal(structuredSelection.getFirstElement());
        }
    }

    public IWorkingSet getWorkingSet() {
        ResourceWorkingSetFilter workingSetFilter = this.getWorkingSetFilter();
        if (workingSetFilter == null) {
            return null;
        }
        return workingSetFilter.getWorkingSet();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        Object newValue = event.getNewValue();
        Object oldValue = event.getOldValue();
        IWorkingSet filterWorkingSet = this.getWorkingSet();
        if ("workingSetRemove".equals(property) && oldValue == filterWorkingSet) {
            this.setWorkingSet(null);
        } else if ("workingSetNameChange".equals(property) && newValue == filterWorkingSet) {
            this.updateTitle();
        } else if ("workingSetContentChange".equals(property) && newValue == filterWorkingSet) {
            this.getViewer().refresh();
        }
    }

    public FrameList getFrameList() {
        return this.frameList;
    }

    public String getFrameName(Object element) {
        return ((ILabelProvider)this.getTreeViewer().getLabelProvider()).getText(element);
    }

    public String getFrameToolTipText(Object element) {
        return this.getFrameName(element);
    }

    protected FrameList createFrameList() {
        TreeNavigatorFrameSource frameSource = this.createFrameSource();
        if (frameSource == null) {
            return null;
        }
        FrameList frameList = new FrameList((IFrameSource)frameSource);
        frameSource.connectTo(frameList);
        return frameList;
    }

    protected TreeNavigatorFrameSource createFrameSource() {
        return new TreeNavigatorFrameSource(this);
    }

    protected void initContextMenu() {
        super.initContextMenu();
        this.frameList = this.createFrameList();
    }

    public void updateTitle() {
        Object input = this.getViewer().getInput();
        String viewName = this.getConfigurationElement().getAttribute("name");
        IWorkingSet workingSet = this.workingSetFilter.getWorkingSet();
        if (input == null || input.equals(this.getInitialViewerInput())) {
            this.setPartName(viewName);
            if (workingSet != null) {
                this.setTitleToolTip(MessageFormat.format((String)UIMessages._144, (Object[])new Object[]{workingSet.getName()}));
            } else {
                this.setTitleToolTip("");
            }
        } else {
            ILabelProvider labelProvider = (ILabelProvider)this.getTreeViewer().getLabelProvider();
            String inputToolTip = this.getFrameToolTipText(input);
            this.setPartName(NLS.bind((String)UIMessages._39, (Object[])new String[]{viewName, labelProvider.getText(input)}));
            if (workingSet != null) {
                this.setTitleToolTip(workingSet.getName());
            } else {
                this.setTitleToolTip(inputToolTip);
            }
        }
    }
}

