/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.hyades.loaders.util.IPagingList;
import org.eclipse.hyades.models.cbe.CBEDefaultEvent;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBMatchPattern;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;

public class AnalysisHelper {
    private static AnalysisHelper instance;
    private Map analysisResults = new Hashtable(89);
    private IPagingList currentList = null;
    private final String LINESEPARATOR = System.getProperty("line.separator");
    private final String DELIMITER = "--------------------------------------------------------------------";

    protected AnalysisHelper() {
    }

    public static AnalysisHelper getInstance() {
        if (instance == null) {
            instance = new AnalysisHelper();
        }
        return instance;
    }

    public IPagingList getPagingList() {
        return this.currentList;
    }

    public void setPagingList(IPagingList newList) {
        this.currentList = newList;
    }

    public Object[] getResults(CBEDefaultEvent event) {
        if (this.currentList == null) {
            return null;
        }
        String id = this.currentList.getInternalId((Object)event);
        if (id != null && this.analysisResults != null) {
            return (Object[])this.analysisResults.get(id);
        }
        return null;
    }

    public boolean putResults(CBEDefaultEvent event, Object[] result) {
        if (this.currentList == null) {
            return false;
        }
        String id = this.currentList.getInternalId((Object)event);
        if (id == null) {
            return false;
        }
        if (this.analysisResults == null) {
            this.analysisResults = new Hashtable(89);
        }
        return this.analysisResults.put(id, result) != null;
    }

    public boolean resetResults(CBEDefaultEvent event) {
        if (this.currentList == null) {
            return false;
        }
        String id = this.currentList.getInternalId((Object)event);
        if (id == null) {
            return false;
        }
        if (this.analysisResults == null) {
            return false;
        }
        this.analysisResults.remove(id);
        return true;
    }

    public String formatSymptoms(List symptomList) {
        StringBuffer analysisBuffer = new StringBuffer();
        int size = symptomList.size();
        int idx = 0;
        while (idx < size) {
            analysisBuffer.append(this.LINESEPARATOR);
            analysisBuffer.append("--------------------------------------------------------------------");
            analysisBuffer.append(this.LINESEPARATOR);
            SDBSymptom symptom = (SDBSymptom)symptomList.get(idx);
            analysisBuffer.append(symptom.getDescription()).append(this.LINESEPARATOR);
            EList list = symptom.getPatterns();
            int i = 0;
            while (i < list.size()) {
                analysisBuffer.append(((SDBMatchPattern)list.get(i)).getValue()).append(this.LINESEPARATOR);
                ++i;
            }
            list = symptom.getSolutions();
            i = 0;
            while (i < list.size()) {
                SDBSolution sol = (SDBSolution)list.get(i);
                analysisBuffer.append(((SDBSolution)list.get(i)).getDescription()).append(this.LINESEPARATOR);
                EList directives = sol.getDirectives();
                int j = 0;
                while (j < directives.size()) {
                    analysisBuffer.append(((SDBDirective)directives.get(j)).getDescription()).append(this.LINESEPARATOR);
                    ++j;
                }
                ++i;
            }
            ++idx;
        }
        return analysisBuffer.toString().trim();
    }

    public String formatSymptoms(Object[] symptoms) {
        StringBuffer analysisBuffer = new StringBuffer();
        int l = symptoms.length;
        int idx = 0;
        while (idx < l) {
            analysisBuffer.append(this.LINESEPARATOR);
            analysisBuffer.append("--------------------------------------------------------------------");
            analysisBuffer.append(this.LINESEPARATOR);
            SDBSymptom symptom = (SDBSymptom)symptoms[idx];
            analysisBuffer.append(symptom.getDescription()).append(this.LINESEPARATOR);
            EList list = symptom.getPatterns();
            int i = 0;
            while (i < list.size()) {
                analysisBuffer.append(((SDBMatchPattern)list.get(i)).getValue()).append(this.LINESEPARATOR);
                ++i;
            }
            list = symptom.getSolutions();
            i = 0;
            while (i < list.size()) {
                SDBSolution sol = (SDBSolution)list.get(i);
                analysisBuffer.append(((SDBSolution)list.get(i)).getDescription()).append(this.LINESEPARATOR);
                EList directives = sol.getDirectives();
                int j = 0;
                while (j < directives.size()) {
                    analysisBuffer.append(((SDBDirective)directives.get(j)).getDescription()).append(this.LINESEPARATOR);
                    ++j;
                }
                ++i;
            }
            ++idx;
        }
        return analysisBuffer.toString().trim();
    }

    public boolean isXMI(CBEDefaultEvent event) {
        Resource res = event.eResource();
        return res instanceof XMIResourceImpl;
    }

    public boolean isAnalyzed(CBEDefaultEvent event) {
        if (this.currentList == null) {
            return false;
        }
        String id = this.currentList.getInternalId((Object)event);
        if (id != null && this.analysisResults != null) {
            return this.analysisResults.get(id) != null;
        }
        return false;
    }

    public void dispose() {
        if (this.analysisResults == null) {
            return;
        }
        this.analysisResults.clear();
        this.analysisResults = null;
    }
}

