/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.hyades.ui.internal.util.RuntimeExceptionDecorator;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.PlatformUI;

public class CoreUtil {
    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        PrintStream errorPS = new PrintStream(errorStream);
        throwable.printStackTrace(errorPS);
        errorPS.flush();
        String stackTrace = errorStream.toString();
        try {
            errorStream.close();
        }
        catch (Exception exception) {}
        return stackTrace;
    }

    public static IElementFactory getElementFactory(String factoryId) {
        return PlatformUI.getWorkbench().getElementFactory(factoryId);
    }

    public static boolean dispose(Map map) {
        if (map == null) {
            return true;
        }
        boolean ret = CoreUtil.dispose(map.values());
        map.clear();
        return ret;
    }

    public static boolean dispose(Collection disposableCandidates) {
        if (disposableCandidates == null) {
            return true;
        }
        Iterator i = disposableCandidates.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (object instanceof IDisposable) {
                ((IDisposable)object).dispose();
                continue;
            }
            if (object instanceof Collection) {
                CoreUtil.dispose((Collection)object);
                continue;
            }
            if (!(object instanceof Map)) continue;
            CoreUtil.dispose((Map)object);
        }
        try {
            disposableCandidates.clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
        return true;
    }

    public static Object getObjectFieldValue(Object object, String fieldName, boolean throwException) throws RuntimeException {
        if (object == null || fieldName == null) {
            return null;
        }
        RuntimeExceptionDecorator red = null;
        Field field = null;
        Class<?> currentClass = object.getClass();
        while (field == null && currentClass != null) {
            try {
                field = currentClass.getDeclaredField(fieldName);
            }
            catch (Exception e) {
                if (throwException && red == null) {
                    red = new RuntimeExceptionDecorator(e);
                }
                currentClass = currentClass.getSuperclass();
            }
        }
        if (field == null) {
            if (red != null) {
                throw red;
            }
            return null;
        }
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception e) {
            if (throwException) {
                throw new RuntimeExceptionDecorator(e);
            }
            return null;
        }
    }

    public static Object invokeObjectMethod(Object object, String methodName, Object[] arguments, boolean throwException) throws RuntimeException {
        Class[] parameterTypes = null;
        if (arguments != null) {
            parameterTypes = new Class[arguments.length];
            int i = 0;
            int maxi = arguments.length;
            while (i < maxi) {
                parameterTypes[i] = arguments[i].getClass();
                ++i;
            }
        }
        return CoreUtil.invokeObjectMethod(object, methodName, parameterTypes, arguments, throwException);
    }

    public static Object invokeObjectMethod(Object object, String methodName, Class[] parameterTypes, Object[] arguments, boolean throwException) throws RuntimeException {
        if (object == null || methodName == null) {
            return null;
        }
        if (parameterTypes == null) {
            parameterTypes = new Class[]{};
        }
        if (arguments == null) {
            arguments = new Object[]{};
        }
        RuntimeExceptionDecorator red = null;
        Method method = null;
        Class<?> currentClass = object.getClass();
        while (method == null && currentClass != null) {
            try {
                method = currentClass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (Exception e) {
                if (throwException && red == null) {
                    red = new RuntimeExceptionDecorator(e);
                }
                currentClass = currentClass.getSuperclass();
            }
        }
        if (method == null) {
            if (red != null) {
                throw red;
            }
            return null;
        }
        try {
            method.setAccessible(true);
            return method.invoke(object, arguments);
        }
        catch (Exception e) {
            if (throwException) {
                throw new RuntimeExceptionDecorator(e);
            }
            return null;
        }
    }
}

