/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.security.AccessController;
import java.util.Map;
import sun.security.action.GetPropertyAction;

public class FileUtil {
    public static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        if ((path = path.trim().replace('\\', '/')).endsWith("/") && !path.endsWith("//")) {
            path = path.substring(0, path.length() - "/".length());
        }
        return path;
    }

    public static String appendPath(String path1, String path2) {
        path1 = FileUtil.normalizePath(path1);
        path2 = FileUtil.normalizePath(path2);
        if (path1 == null || path1.trim().length() == 0) {
            return path2;
        }
        if (path2 == null || path2.trim().length() == 0) {
            return path1;
        }
        if (path1.endsWith("//")) {
            if (path2.startsWith("/") && path2.length() > 1) {
                path2 = path2.substring(1);
            }
        } else if (!path2.startsWith("/")) {
            path2 = "/" + path2;
        }
        return String.valueOf(path1) + path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int streamCopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        InputStream inputStream2 = inputStream;
        synchronized (inputStream2) {
            OutputStream outputStream2 = outputStream;
            synchronized (outputStream2) {
                int totalBytes = 0;
                int length = 0;
                byte[] buffer = new byte[256];
                while ((length = inputStream.read(buffer)) != -1) {
                    totalBytes += length;
                    outputStream.write(buffer, 0, length);
                }
                return totalBytes;
            }
        }
    }

    public static String removeLastSegment(String path) {
        int index = (path = FileUtil.normalizePath(path)).lastIndexOf("/");
        if (index < 0) {
            return "";
        }
        return path.substring(0, index);
    }

    public static String getLastSegment(String path) {
        int index = (path = FileUtil.normalizePath(path)).lastIndexOf("/");
        if (index >= 0) {
            path = path.substring(index + 1);
        }
        return path;
    }

    public static File getValidFileOrDirectory(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            return file.getAbsoluteFile().getCanonicalFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean writeToFile(String encoding, File file, boolean append, String text) {
        File validFile;
        if (file == null) {
            return false;
        }
        if (!append && (validFile = FileUtil.getValidFileOrDirectory(file)) != null && file.isFile() && file.exists()) {
            validFile.delete();
            file = validFile;
        }
        if (text == null || text.length() == 0) {
            return true;
        }
        try {
            return FileUtil.writeToOutputStream(encoding, new FileOutputStream(file.toString(), append), text);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean writeToOutputStream(String encoding, OutputStream outputStream, String text) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 60->66)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String readFromFile(String encoding, File file, boolean keepOpen) throws IOException {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        return FileUtil.readFromInputStream(encoding, new FileInputStream(file), keepOpen);
    }

    public static String readFromInputStream(String encoding, InputStream inputStream, boolean keepOpen) throws IOException {
        String string;
        block3: {
            StringBuffer buffer = new StringBuffer();
            try {
                int ch;
                InputStreamReader isr = null;
                isr = encoding != null ? new InputStreamReader(inputStream, encoding) : new InputStreamReader(inputStream);
                BufferedReader in = new BufferedReader(isr);
                while ((ch = ((Reader)in).read()) > -1) {
                    buffer.append((char)ch);
                }
                string = buffer.toString();
                Object var7_8 = null;
                if (keepOpen || inputStream == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var7_9 = null;
                    if (keepOpen || inputStream == null) break block4;
                    inputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        return string;
    }

    /*
     * Exception decompiling
     */
    public static Map getZipEntryDataByZipEntryName(String zipFileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 106->109)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getFileExtension(File file) {
        if (file == null || file.isDirectory()) {
            return "";
        }
        return FileUtil.getFileExtension(file.getName());
    }

    public static String getFileExtension(String file) {
        if (file == null) {
            return "";
        }
        int index = file.lastIndexOf(".");
        if (index < 0) {
            return "";
        }
        if (index == file.length() - 1) {
            return "";
        }
        return file.substring(index + 1);
    }

    public static boolean isParent(File parentCandidate, File fileToAnalyse) {
        if (fileToAnalyse == null || parentCandidate == null) {
            return false;
        }
        parentCandidate = parentCandidate.getAbsoluteFile();
        fileToAnalyse = fileToAnalyse.getAbsoluteFile();
        while (fileToAnalyse != null) {
            if (parentCandidate.equals(fileToAnalyse)) {
                return true;
            }
            fileToAnalyse = fileToAnalyse.getParentFile();
        }
        return false;
    }

    public static File getTempDir() {
        GetPropertyAction a = new GetPropertyAction("java.io.tmpdir");
        String tmpdir = AccessController.doPrivileged(a);
        return new File(tmpdir);
    }

    public static int delete(File file) {
        if (file.isFile()) {
            return file.delete() ? 1 : 0;
        }
        if (file.isDirectory()) {
            int counter = 0;
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                counter += FileUtil.delete(files[i]);
                ++i;
            }
            return counter += file.delete() ? 1 : 0;
        }
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int copyFiles(File[] files, File toDirectory, boolean overwrite) throws IOException {
        if (files == null || files.length == 0 || toDirectory == null) {
            return 0;
        }
        if (toDirectory.exists()) {
            if (!toDirectory.isDirectory()) {
                return 0;
            }
        } else {
            toDirectory.mkdirs();
        }
        int copyCount = 0;
        int i = 0;
        int max = files.length;
        while (true) {
            block10: {
                Object var9_9;
                File newFile;
                block12: {
                    block11: {
                        if (i >= max) {
                            return copyCount;
                        }
                        if (files[i] == null || !files[i].exists() || !files[i].isFile()) break block10;
                        newFile = new File(toDirectory, files[i].getName());
                        if (newFile.exists() && newFile.isFile()) break block11;
                        newFile.createNewFile();
                        break block12;
                    }
                    if (!overwrite) break block10;
                }
                FileInputStream inputStream = new FileInputStream(files[i]);
                FileOutputStream outputStream = new FileOutputStream(newFile);
                try {
                    FileUtil.streamCopy(inputStream, outputStream);
                    ++copyCount;
                }
                catch (Throwable throwable) {
                    var9_9 = null;
                    inputStream.close();
                    outputStream.close();
                    throw throwable;
                }
                {
                    var9_9 = null;
                }
                inputStream.close();
                outputStream.close();
            }
            ++i;
        }
    }
}

