/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.TimeZones;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;

public class PreferencesUtil {
    public static final String SYMPTOM_DB_PATH_KEY = "symptom_db_path";
    public static final String[] TIME_ZONE_LIST = new String[]{TimeZones.MIT, TimeZones.HST, TimeZones.AST, TimeZones.PST, TimeZones.America_Phoenix, TimeZones.MST, TimeZones.America_Regina, TimeZones.CST, TimeZones.America_Bogota, TimeZones.EST, TimeZones.America_Santiago, TimeZones.America_Caracas, TimeZones.PRT, TimeZones.CNT, TimeZones.AGT, TimeZones.BET, TimeZones.Atlantic_South_Georgia, TimeZones.Atlantic_Azores, TimeZones.GMT, TimeZones.Africa_Casablanca, TimeZones.ECT, TimeZones.Europe_Prague, TimeZones.Europe_Paris, TimeZones.Europe_Warsaw, TimeZones.EET, TimeZones.Europe_Bucharest, TimeZones.Africa_Cairo, TimeZones.Africa_Harare, TimeZones.Europe_Moscow, TimeZones.Asia_Baghdad, TimeZones.Asia_Tehran, TimeZones.NET, TimeZones.Asia_Kabul, TimeZones.Asia_Yekaterinburg, TimeZones.Asia_Tashkent, TimeZones.IST, TimeZones.BST, TimeZones.VST, TimeZones.CTT, TimeZones.JST, TimeZones.Asia_Yakutsk, TimeZones.Australia_Adelaide, TimeZones.Australia_Darwin, TimeZones.AET, TimeZones.Pacific_Guam, TimeZones.Asia_Vladivostok, TimeZones.Australia_Hobart, TimeZones.SST, TimeZones.NST, TimeZones.Pacific_Fiji, TimeZones.Pacific_Enderbufy};
    public static final String[] TIME_ZONE_IDS = new String[]{"MIT", "HST", "AST", "PST", "America_Phoenix", "MST", "America_Regina", "CST", "America_Bogota", "EST", "America_Santiago", "America_Caracas", "PRT", "CNT", "AGT", "BET", "Atlantic_South_Georgia", "Atlantic_Azores", "GMT", "Africa_Casablanca", "ECT", "Europe_Prague", "Europe_Paris", "Europe_Warsaw", "EET", "Europe_Bucharest", "Africa_Cairo", "Africa_Harare", "Europe_Moscow", "Asia_Baghdad", "Asia_Tehran", "NET", "Asia_Kabul", "Asia_Yekaterinburg", "Asia_Tashkent", "IST", "BST", "VST", "CTT", "JST", "Asia_Yakutsk", "Australia_Adelaide", "Australia_Darwin", "AET", "Pacific_Guam", "Asia_Vladivostok", "Australia_Hobart", "SST", "NST", "Pacific_Fiji", "Pacific_Enderbufy"};
    public static final String[] TIME_ZONE_LIST_OFFSET = new String[]{"GMT-11:00", "GMT-10:00", "GMT-09:00", "GMT-08:00", "GMT-07:00", "GMT-07:00", "GMT-06:00", "GMT-06:00", "GMT-05:00", "GMT-05:00", "GMT-04:00", "GMT-04:00", "GMT-04:00", "GMT-03:30", "GMT-03:00", "GMT-03:00", "GMT-02:00", "GMT-01:00", "GMT", "GMT", "GMT+01:00", "GMT+01:00", "GMT+01:00", "GMT+01:00", "GMT+02:00", "GMT+02:00", "GMT+02:00", "GMT+02:00", "GMT+03:00", "GMT+03:00", "GMT+03:30", "GMT+04:00", "GMT+04:30", "GMT+05:00", "GMT+05:00", "GMT+05:30", "GMT+06:00", "GMT+07:00", "GMT+08:00", "GMT+09:00", "GMT+09:00", "GMT+09:30", "GMT+09:30", "GMT+10:00", "GMT+10:00", "GMT+10:00", "GMT+10:00", "GMT+11:00", "GMT+12:00", "GMT+12:00", "GMT+13:00"};

    public static IPreferenceStore doGetPreferenceStore() {
        IPreferenceStore store = HyadesUIPlugin.getInstance().getPreferenceStore();
        try {
            PreferenceStore sourceStore = PreferencesUtil.getPreferencesStore("org.eclipse.hyades.sdb", false);
            if (sourceStore == null) {
                sourceStore = PreferencesUtil.getPreferencesStore("org.eclipse.hyades.sdb", true);
            }
            if (sourceStore != null) {
                PreferencesUtil.mergePreferenceStore(sourceStore, store);
            }
            if ((sourceStore = PreferencesUtil.getPreferencesStore("org.eclipse.tptp.platform.log.views", false)) != null) {
                PreferencesUtil.mergePreferenceStore(sourceStore, store);
            }
            HyadesUIPlugin.getInstance().savePluginPreferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return store;
    }

    public static void mergePreferenceStore(PreferenceStore sourceStore, IPreferenceStore targetStore) {
        try {
            sourceStore.load();
            String sdbSource = sourceStore.getString(SYMPTOM_DB_PATH_KEY);
            if (sdbSource != null && sdbSource.trim().length() > 0) {
                String sdbTarget = targetStore.getString(SYMPTOM_DB_PATH_KEY);
                if (sdbTarget == null || sdbTarget != null && sdbTarget.trim().length() == 0) {
                    targetStore.putValue(SYMPTOM_DB_PATH_KEY, sdbSource);
                    sourceStore.setValue(SYMPTOM_DB_PATH_KEY, "");
                } else {
                    int idx = sdbSource.indexOf(";");
                    StringBuffer bf = null;
                    int lastIndex = -1;
                    while (true) {
                        String filePath;
                        if (idx > 1 && sdbSource.charAt(idx - 2) == ',') {
                            filePath = sdbSource.substring(0, idx - 2);
                            if (sdbTarget.indexOf(filePath) < 0) {
                                if (bf == null) {
                                    bf = new StringBuffer();
                                    bf.append(sdbTarget);
                                }
                                bf.append(sdbSource.substring(0, idx));
                            }
                        } else {
                            if (idx >= 0 || sdbSource.length() <= 1 || sdbSource.charAt(sdbSource.length() - 2) != ',' || sdbTarget.indexOf(filePath = sdbSource.substring(lastIndex + 1, sdbSource.length() - 2)) >= 0) break;
                            if (bf == null) {
                                bf = new StringBuffer();
                                bf.append(sdbTarget);
                            }
                            bf.append(sdbSource.substring(lastIndex + 1, sdbSource.length()));
                            break;
                        }
                        lastIndex = idx;
                        idx = sdbSource.indexOf(";", idx + 1);
                    }
                    if (bf != null && bf.length() > 0) {
                        targetStore.putValue(SYMPTOM_DB_PATH_KEY, bf.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static PreferenceStore getPreferencesStore(String pluginID, boolean eclipse2) {
        IPath path = Platform.getPluginStateLocation((Plugin)ResourcesPlugin.getPlugin());
        File file = null;
        PreferenceStore ps = null;
        file = eclipse2 ? path.removeLastSegments(1).addTrailingSeparator().append(pluginID).addTrailingSeparator().append("pref_store.ini").toFile() : path.removeLastSegments(1).addTrailingSeparator().append("org.eclipse.core.runtime").addTrailingSeparator().append(".settings").addTrailingSeparator().append(String.valueOf(pluginID) + ".prefs").toFile();
        if (file.exists()) {
            ps = new PreferenceStore(file.getAbsolutePath());
        }
        return ps;
    }

    public static void savePreferences() {
        HyadesUIPlugin.getInstance().savePluginPreferences();
    }
}

