/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.filters.internal.util.FilterResourceFileHandler;
import org.eclipse.hyades.ui.filters.internal.util.FilterResourceHandler;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.hyades.ui.internal.wizard.ExportImportFilterWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ExportFilterWizardPage
extends ExportImportFilterWizardPage {
    public ExportFilterWizardPage(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("FilterExportPage", aWorkbench, selection);
        this.setTitle(UIMessages._127);
        this.setDescription(UIMessages._128);
        this.setImageDescriptor(HyadesUIImages.INSTANCE.getImageDescriptor("filter_export_wiz.gif"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        this.createBoldLabel(composite, UIMessages._129);
        this.createDoubleList(composite, UIMessages._130, UIMessages._131);
        this.createSourceGroup(composite);
        this.createSpacer(composite);
        this.initializeValues();
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, String.valueOf(HyadesUIPlugin.getID()) + ".pfie0002");
    }

    protected List populateFilterList() {
        FilterResourceHandler resource = FilterResourceHandler.instance();
        Object[] filterQueries = resource.toArray();
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < filterQueries.length) {
            list.add(filterQueries[i]);
            ++i;
        }
        return list;
    }

    public boolean finish() {
        List filtersToExport = this.getDoubleList().getTargetItems();
        String exportFile = this.sourceNameField.getText().trim();
        if (!exportFile.endsWith(".filtxml")) {
            exportFile = String.valueOf(exportFile) + ".filtxml";
        }
        FilterResourceFileHandler exportResourceHandler = FilterResourceFileHandler.instance(URI.createFileURI((String)exportFile));
        exportResourceHandler.clear();
        int i = 0;
        while (i < filtersToExport.size()) {
            exportResourceHandler.addFilter(((FilterQueries)filtersToExport.get(i)).copy());
            ++i;
        }
        exportResourceHandler.save();
        exportResourceHandler.unload();
        return true;
    }

    protected boolean validateLists() {
        return true;
    }
}

