/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.report.ReportDescription;
import org.eclipse.hyades.ui.internal.report.ReportManager;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesReportExtensionsWizard;
import org.eclipse.hyades.ui.internal.wizard.HyadesReportGeneratorsExtensionRegistryReader;
import org.eclipse.hyades.ui.internal.wizard.HyadesReportSelectionWizardPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement;
import org.eclipse.hyades.ui.internal.wizard.selection.WizardElement;
import org.eclipse.hyades.ui.report.IReportDescription;
import org.eclipse.hyades.ui.report.IReportGenerator;
import org.eclipse.hyades.ui.report.ReportGeneratorWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.osgi.framework.Bundle;

public class HyadesReportWizard
extends HyadesWizard {
    private static String REPORT_WIZARD_KEY = "HyadesReportWizard";
    HyadesReportSelectionWizardPage reportSelectionPage;

    public HyadesReportWizard() {
        this.setWindowTitle(UIMessages._152);
        IDialogSettings dialogSettings = HyadesUIPlugin.getInstance().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection(REPORT_WIZARD_KEY);
        if (settings == null) {
            settings = dialogSettings.addNewSection(REPORT_WIZARD_KEY);
        }
        this.setDialogSettings(settings);
        this.setForcePreviousAndNextButtons(true);
    }

    protected void initPages() {
        this.reportSelectionPage = new HyadesReportSelectionWizardPage("report", this.getWorkbench(), this.getSelection(), this.getWizardElements(), UIMessages._156);
        this.reportSelectionPage.setTitle(UIMessages._155);
        this.reportSelectionPage.setDescription(UIMessages._156);
    }

    private IWizardElement[] getWizardElements() {
        LinkedList<WizardElement> wizardElems = new LinkedList<WizardElement>();
        try {
            Iterator it = HyadesReportGeneratorsExtensionRegistryReader.getInstance().getWizardCategoryElements().iterator();
            while (it.hasNext()) {
                String icon_path;
                IConfigurationElement elem = (IConfigurationElement)it.next();
                ReportGeneratorWizard wiz = (ReportGeneratorWizard)elem.createExecutableExtension("class");
                if (!wiz.isAvailable((ISelection)this.getSelection())) continue;
                WizardElement wizardElement = new WizardElement((IWizard)wiz);
                wizardElement.setId(elem.getAttribute("id"));
                wizardElement.setLabel(elem.getAttribute("name"));
                wizardElement.setDescription(elem.getAttribute("description"));
                ImageDescriptor imageDescriptor = null;
                String symbolicName = elem.getDeclaringExtension().getNamespace();
                Bundle bundle = Platform.getBundle((String)symbolicName);
                if (bundle != null && bundle.getState() == 32 && (icon_path = elem.getAttribute("icon")) != null) {
                    URL url = new URL(bundle.getEntry("/"), icon_path);
                    imageDescriptor = ImageDescriptor.createFromURL((URL)url);
                }
                wizardElement.setImageDescriptor(imageDescriptor);
                wizardElems.add(wizardElement);
            }
            ReportManager manager = ReportManager.getInstance();
            IReportDescription[] list = manager.getReportDescriptions();
            int idx = 0;
            while (idx < list.length) {
                ReportDescription data = (ReportDescription)list[idx];
                IReportGenerator gen = null;
                gen = data.getReportGenerator();
                if (gen != null && gen.isAvailable((ISelection)this.getSelection())) {
                    WizardElement wizardElement = new WizardElement((IWizard)new HyadesReportExtensionsWizard(gen));
                    wizardElement.setId(data.getName());
                    wizardElement.setLabel(data.getName());
                    wizardElement.setDescription("wizard.Report.Description");
                    wizardElems.add(wizardElement);
                }
                ++idx;
            }
        }
        catch (Exception e) {
            HyadesUIPlugin.logError(e);
        }
        IWizardElement[] arrayOfWizardElement = new IWizardElement[wizardElems.size()];
        wizardElems.toArray(arrayOfWizardElement);
        return arrayOfWizardElement;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.reportSelectionPage);
    }

    public boolean performFinish() {
        try {
            FinishOperation op = new FinishOperation();
            this.getContainer().run(false, false, (IRunnableWithProgress)op);
            IFile reportFile = op.getReportFile();
            this.reportSelectionPage.saveWidgetValues();
            if (reportFile == null) {
                return false;
            }
            BasicNewResourceWizard.selectAndReveal((IResource)reportFile, (IWorkbenchWindow)this.getWorkbench().getActiveWorkbenchWindow());
            this.open(reportFile);
        }
        catch (InterruptedException e) {
            HyadesUIPlugin.logError(e);
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable exception = e.getTargetException();
            HyadesUIPlugin.logError(exception);
            String error = exception.getLocalizedMessage();
            if (error == null || error.length() == 0) {
                error = exception.getMessage();
            }
            if (error == null || error.length() == 0) {
                error = exception.getClass().getName();
            }
            MessageDialog.openError((Shell)this.getShell(), (String)UIMessages._8, (String)NLS.bind((String)UIMessages._160, (Object)error));
            return false;
        }
        return true;
    }

    private void open(IFile file) {
        IPreferenceStore store = HyadesUIPlugin.getInstance().getPreferenceStore();
        store.setValue("REPORT_OPEN_EDITOR", this.reportSelectionPage.openEditor());
        if (this.reportSelectionPage.openEditor()) {
            UIUtil.openEditor(file, null, false);
        }
    }

    class FinishOperation
    extends WorkspaceModifyOperation {
        private IFile indexReport = null;

        FinishOperation() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                try {
                    IWizard selectedWizard = HyadesReportWizard.this.reportSelectionPage.getSelectedNode().getWizard();
                    if (selectedWizard instanceof ReportGeneratorWizard) {
                        monitor.beginTask("", 1);
                        this.indexReport = ((ReportGeneratorWizard)selectedWizard).generate((IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
                    }
                }
                catch (Throwable e) {
                    throw new InvocationTargetException(e);
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var3_6 = null;
            }
            monitor.done();
        }

        public IFile getReportFile() {
            return this.indexReport;
        }
    }
}

