/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class LocationPage
extends WizardNewFileCreationPage {
    private String fileExtension;
    private boolean allowOverwrite = false;

    public LocationPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    public void setAllowOverwrite(boolean allowOverwrite) {
        this.allowOverwrite = allowOverwrite;
    }

    public boolean allowOverwrite() {
        return this.allowOverwrite;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    protected boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (!this.allowOverwrite()) {
            IPath path = this.getContainerFullPath();
            if (path != null) {
                String name;
                int lastIndexOfExtension;
                String fileName = this.getFileName();
                if (fileName.length() == 0 || fileName.equals("." + this.getFileExtension())) {
                    this.setErrorMessage(UIMessages._22);
                    return false;
                }
                if (fileName.startsWith(".")) {
                    this.setErrorMessage(UIMessages._23);
                    return false;
                }
                String invalidChar = UIUtil.validateOSFileName(fileName);
                if (invalidChar != null) {
                    if (Character.isDigit(invalidChar.charAt(0))) {
                        Object[] errors = new String[]{UIMessages._27, UIMessages._28};
                        this.setErrorMessage(NLS.bind((String)UIMessages._24, (Object[])errors));
                        return false;
                    }
                    if (invalidChar.trim().equals("-")) {
                        Object[] errors = new String[]{UIMessages._27, "-"};
                        this.setErrorMessage(NLS.bind((String)UIMessages._24, (Object[])errors));
                        return false;
                    }
                    Object[] errors = new String[]{UIMessages._27, invalidChar};
                    this.setErrorMessage(NLS.bind((String)UIMessages._25, (Object[])errors));
                    return false;
                }
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path.append(fileName));
                if (resource != null && resource.exists()) {
                    this.setErrorMessage(UIMessages._138);
                    return false;
                }
                String fileExtension = this.getFileExtension();
                if (fileExtension != null && (lastIndexOfExtension = fileName.lastIndexOf(fileExtension)) > 0 && (name = fileName.substring(0, lastIndexOfExtension - 1)).endsWith("." + fileExtension)) {
                    this.setMessage(NLS.bind((String)UIMessages._26, (Object)fileName), 2);
                    return true;
                }
            } else {
                this.setErrorMessage(UIMessages._21);
                return false;
            }
        }
        return super.validatePage();
    }

    protected void createAdvancedControls(Composite parent) {
    }

    protected String getNewFileLabel() {
        return UIMessages._2;
    }

    protected IStatus validateLinkedResource() {
        return new Status(0, HyadesUIPlugin.getID(), 0, "", null);
    }

    public String getFileName() {
        String name = super.getFileName();
        if (this.fileExtension != null) {
            name = String.valueOf(name) + "." + this.fileExtension;
        }
        return name;
    }

    public String getItemName() {
        return super.getFileName();
    }
}

